/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.LazyHintComputationFactory;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyHintComputation
implements CancellableTask<CompilationInfo> {
    private FileObject file;
    private boolean cancelled;
    private CreatorBasedLazyFixList delegate;

    public LazyHintComputation(FileObject fileObject) {
        this.file = fileObject;
    }

    public synchronized void cancel() {
        this.cancelled = true;
        if (this.delegate != null) {
            this.delegate.cancel();
        }
    }

    private synchronized void setDelegate(CreatorBasedLazyFixList creatorBasedLazyFixList) {
        this.delegate = creatorBasedLazyFixList;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    private synchronized void resume() {
        this.cancelled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CompilationInfo compilationInfo) {
        this.resume();
        boolean bl = false;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            linkedList.addAll(LazyHintComputationFactory.getAndClearToCompute(this.file));
            if (this.isCancelled()) {
                bl = true;
                return;
            }
            while (!linkedList.isEmpty()) {
                if (this.isCancelled()) {
                    bl = true;
                    return;
                }
                Iterator iterator = (CreatorBasedLazyFixList)linkedList.remove(0);
                this.setDelegate((CreatorBasedLazyFixList)((Object)iterator));
                ((CreatorBasedLazyFixList)((Object)iterator)).compute(compilationInfo);
                this.setDelegate(null);
                if (!this.isCancelled()) continue;
                linkedList.add(0, iterator);
                bl = true;
                return;
            }
        }
        finally {
            if (bl && !linkedList.isEmpty()) {
                for (CreatorBasedLazyFixList creatorBasedLazyFixList : linkedList) {
                    LazyHintComputationFactory.addToCompute(this.file, creatorBasedLazyFixList);
                }
            }
        }
    }
}

