/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.hints.MagicSurroundWithTryCatch;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UncaughtExceptionCreator
implements ErrorRule<Void> {
    private static final Set<ElementKind> EXECUTABLE_ELEMENTS = EnumSet.of(ElementKind.CONSTRUCTOR, ElementKind.METHOD);
    static final Set<Tree.Kind> STATEMENT_KINDS;

    private List<? extends TypeMirror> findUncauchedExceptions(CompilationInfo compilationInfo, TreePath treePath, List<? extends TypeMirror> list) {
        ArrayList<? extends TypeMirror> arrayList = new ArrayList<TypeMirror>();
        arrayList.addAll(list);
        while (treePath != null) {
            Object object;
            Element element = compilationInfo.getTrees().getElement(treePath);
            if (element != null && EXECUTABLE_ELEMENTS.contains((Object)element.getKind())) {
                object = (ExecutableElement)element;
                arrayList.removeAll(object.getThrownTypes());
                break;
            }
            object = treePath.getLeaf();
            if (object.getKind() == Tree.Kind.TRY) {
                TryTree tryTree = (TryTree)object;
                for (CatchTree catchTree : tryTree.getCatches()) {
                    TreePath treePath2 = new TreePath(new TreePath(treePath, catchTree), catchTree.getParameter());
                    VariableElement variableElement = (VariableElement)compilationInfo.getTrees().getElement(treePath2);
                    arrayList.remove(variableElement.asType());
                }
            }
            treePath = treePath.getParentPath();
        }
        return arrayList;
    }

    @Override
    public Set<String> getCodes() {
        return Collections.singleton("compiler.err.unreported.exception.need.to.catch.or.throw");
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<Void> data) {
        AnnotatedConstruct annotatedConstruct;
        Object object;
        TreePath treePath2;
        ArrayList<Fix> arrayList = new ArrayList<Fix>();
        List<AnnotatedConstruct> list = null;
        block4: for (treePath2 = compilationInfo.getTreeUtilities().pathFor(n + 1); treePath2 != null; treePath2 = treePath2.getParentPath()) {
            object = treePath2.getLeaf();
            switch (object.getKind()) {
                case NEW_CLASS: 
                case METHOD_INVOCATION: {
                    Element element = compilationInfo.getTrees().getElement(treePath2);
                    if (element != null && EXECUTABLE_ELEMENTS.contains((Object)element.getKind())) {
                        list = ((ExecutableElement)element).getThrownTypes();
                    }
                    treePath2 = treePath2.getParentPath();
                    break block4;
                }
                case THROW: {
                    annotatedConstruct = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath2, ((ThrowTree)object).getExpression()));
                    list = Collections.singletonList(annotatedConstruct);
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (list != null) {
            list = this.findUncauchedExceptions(compilationInfo, treePath2, list);
            for (object = treePath2; object != null && ((TreePath)object).getLeaf().getKind() != Tree.Kind.METHOD; object = ((TreePath)object).getParentPath()) {
            }
            ExecutableElement executableElement = annotatedConstruct = object != null ? (ExecutableElement)compilationInfo.getTrees().getElement((TreePath)object) : null;
            if (annotatedConstruct != null) {
                for (TypeMirror object2 : list) {
                    if (object2.getKind() == TypeKind.ERROR) continue;
                    arrayList.add(new AddThrowsClauseHintImpl(compilationInfo.getJavaSource(), ((Object)Utilities.getTypeName((TypeMirror)object2, (boolean)true)).toString(), TypeMirrorHandle.create((TypeMirror)object2), (ElementHandle<ExecutableElement>)ElementHandle.create((Element)annotatedConstruct)));
                }
            }
            if (!list.isEmpty()) {
                ArrayList arrayList2 = new ArrayList();
                for (TypeMirror typeMirror : list) {
                    if (typeMirror.getKind() == TypeKind.ERROR) continue;
                    arrayList2.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
                }
                arrayList.add(new MagicSurroundWithTryCatch(compilationInfo.getJavaSource(), arrayList2, n));
            }
        }
        return arrayList;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return UncaughtExceptionCreator.class.getName();
    }

    @Override
    public String getDisplayName() {
        return "Add Throws Clause and Surround With try-catch Fixes";
    }

    @Override
    public String getDescription() {
        return "Add Throws Clause and Surround With try-catch Fixes";
    }

    static {
        HashSet<Tree.Kind> hashSet = new HashSet<Tree.Kind>();
        for (Tree.Kind kind : Tree.Kind.values()) {
            Class<? extends Tree> clazz = kind.asInterface();
            if (clazz == null || !StatementTree.class.isAssignableFrom(clazz)) continue;
            hashSet.add(kind);
        }
        STATEMENT_KINDS = Collections.unmodifiableSet(EnumSet.copyOf(hashSet));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddThrowsClauseHintImpl
    implements Fix {
        private JavaSource js;
        private String fqn;
        private TypeMirrorHandle thandle;
        private ElementHandle<ExecutableElement> method;

        public AddThrowsClauseHintImpl(JavaSource javaSource, String string, TypeMirrorHandle typeMirrorHandle, ElementHandle<ExecutableElement> elementHandle) {
            this.js = javaSource;
            this.fqn = string;
            this.thandle = typeMirrorHandle;
            this.method = elementHandle;
        }

        public String getText() {
            return "Add throws clause for " + this.fqn;
        }

        public ChangeInfo implement() {
            try {
                this.js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws Exception {
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        MethodTree methodTree = workingCopy.getTrees().getTree((ExecutableElement)AddThrowsClauseHintImpl.this.method.resolve((CompilationInfo)workingCopy));
                        assert (methodTree != null);
                        assert (methodTree.getKind() == Tree.Kind.METHOD);
                        MethodTree methodTree2 = workingCopy.getTreeMaker().addMethodThrows(methodTree, (ExpressionTree)workingCopy.getTreeMaker().Type(AddThrowsClauseHintImpl.this.thandle.resolve((CompilationInfo)workingCopy)));
                        workingCopy.rewrite((Tree)methodTree, (Tree)methodTree2);
                    }
                }).commit();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SurroundWithTryCatch
    implements Fix {
        private JavaSource js;
        private List<TypeMirrorHandle> thandles;
        private int offset;

        public SurroundWithTryCatch(JavaSource javaSource, List<TypeMirrorHandle> list, int n) {
            this.js = javaSource;
            this.thandles = list;
            this.offset = n;
        }

        public String getText() {
            return "Surround with try-catch";
        }

        public ChangeInfo implement() {
            try {
                this.js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws Exception {
                        TreePath treePath;
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        for (treePath = workingCopy.getTreeUtilities().pathFor(SurroundWithTryCatch.this.offset + 1); treePath != null && !STATEMENT_KINDS.contains((Object)treePath.getLeaf().getKind()); treePath = treePath.getParentPath()) {
                        }
                        TreeMaker treeMaker = workingCopy.getTreeMaker();
                        Tree tree = treePath.getLeaf();
                        BlockTree blockTree = treeMaker.Block(Collections.singletonList((StatementTree)tree), false);
                        ArrayList<CatchTree> arrayList = new ArrayList<CatchTree>();
                        for (TypeMirrorHandle typeMirrorHandle : SurroundWithTryCatch.this.thandles) {
                            arrayList.add(treeMaker.Catch(treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"ex", treeMaker.Type(typeMirrorHandle.resolve((CompilationInfo)workingCopy)), null), treeMaker.Block(Collections.emptyList(), false)));
                        }
                        workingCopy.rewrite(tree, (Tree)treeMaker.Try(blockTree, arrayList, null));
                    }
                }).commit();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            return null;
        }
    }
}

