/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.RAMFile;

class RAMInputStream
extends BufferedIndexInput
implements Cloneable {
    private RAMFile file;
    private long pointer = 0L;
    private long length;

    public RAMInputStream(RAMFile f) {
        this.file = f;
        this.length = this.file.length;
    }

    public void readInternal(byte[] dest, int destOffset, int len) {
        int bytesToCopy;
        long start = this.pointer;
        for (int remainder = len; remainder != 0; remainder -= bytesToCopy) {
            int bufferNumber = (int)(start / 1024L);
            int bufferOffset = (int)(start % 1024L);
            int bytesInBuffer = 1024 - bufferOffset;
            bytesToCopy = bytesInBuffer >= remainder ? remainder : bytesInBuffer;
            byte[] buffer = (byte[])this.file.buffers.get(bufferNumber);
            System.arraycopy(buffer, bufferOffset, dest, destOffset, bytesToCopy);
            destOffset += bytesToCopy;
            start += (long)bytesToCopy;
        }
        this.pointer += (long)len;
    }

    public void close() {
    }

    public void seekInternal(long pos) {
        this.pointer = pos;
    }

    public long length() {
        return this.length;
    }
}

