/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.ElementNode;
import org.netbeans.modules.java.navigation.base.FiltersDescription;
import org.netbeans.modules.java.navigation.base.FiltersManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassMemberFilters {
    private ClassMemberPanelUI ui;
    private static final String SHOW_NON_PUBLIC = "show_non_public";
    private static final String SHOW_STATIC = "show_static";
    private static final String SHOW_FIELDS = "show_fields";
    private static final String SHOW_INHERITED = "show_inherited";
    private FiltersManager filters;
    private boolean naturalSort = false;

    ClassMemberFilters(ClassMemberPanelUI classMemberPanelUI) {
        this.ui = classMemberPanelUI;
    }

    public FiltersManager getInstance() {
        if (this.filters == null) {
            this.filters = ClassMemberFilters.createFilters();
        }
        return this.filters;
    }

    public JComponent getComponent() {
        FiltersManager filtersManager = this.getInstance();
        return filtersManager.getComponent();
    }

    public Collection<ElementNode.Description> filter(Collection<ElementNode.Description> collection) {
        boolean bl = this.filters.isSelected(SHOW_NON_PUBLIC);
        boolean bl2 = this.filters.isSelected(SHOW_STATIC);
        boolean bl3 = this.filters.isSelected(SHOW_FIELDS);
        ArrayList<ElementNode.Description> arrayList = new ArrayList<ElementNode.Description>(collection.size());
        for (ElementNode.Description description : collection) {
            if (!bl && !description.modifiers.contains((Object)Modifier.PUBLIC) || !bl2 && description.modifiers.contains((Object)Modifier.STATIC) || !bl3 && description.kind == ElementKind.FIELD) continue;
            arrayList.add(description);
        }
        Collections.sort(arrayList, this.isNaturalSort() ? ElementNode.Description.POSITION_COMPARATOR : ElementNode.Description.ALPHA_COMPARATOR);
        return arrayList;
    }

    public boolean isNaturalSort() {
        return this.naturalSort;
    }

    public void setNaturalSort(boolean bl) {
        this.naturalSort = bl;
        this.ui.sort();
    }

    private static FiltersManager createFilters() {
        FiltersDescription filtersDescription = new FiltersDescription();
        filtersDescription.addFilter(SHOW_FIELDS, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowFields"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowFieldsTip"), true, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/filterHideFields.gif")), null);
        filtersDescription.addFilter(SHOW_STATIC, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowStatic"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowStaticTip"), true, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/filterHideStatic.png")), null);
        filtersDescription.addFilter(SHOW_NON_PUBLIC, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowNonPublic"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowNonPublicTip"), true, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/filterHideNonPublic.png")), null);
        return FiltersDescription.createManager(filtersDescription);
    }
}

