/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.javadoc.Doc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public final class JavaMembersModel
extends DefaultTreeModel {
    static Element[] EMPTY_ELEMENTS_ARRAY = new Element[0];
    static ElementHandle[] EMPTY_ELEMENTHANDLES_ARRAY = new ElementHandle[0];
    private String pattern = "";
    private String patternLowerCase = "";
    private FileObject fileObject;
    private ElementHandle[] elementHandles;

    public JavaMembersModel(FileObject fileObject, Element[] elementArray, CompilationInfo compilationInfo) {
        super(null);
        this.fileObject = fileObject;
        if (elementArray == null || elementArray.length == 0) {
            this.elementHandles = EMPTY_ELEMENTHANDLES_ARRAY;
        } else {
            ArrayList<ElementHandle> arrayList = new ArrayList<ElementHandle>(elementArray.length);
            for (Element element : elementArray) {
                arrayList.add(ElementHandle.create((Element)element));
            }
            this.elementHandles = arrayList.toArray(EMPTY_ELEMENTHANDLES_ARRAY);
        }
        this.update(elementArray, compilationInfo);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
        this.patternLowerCase = string == null ? null : string.toLowerCase();
    }

    public void update() {
        this.update(this.elementHandles);
    }

    private void update(final ElementHandle[] elementHandleArray) {
        if (elementHandleArray == null && elementHandleArray.length == 0) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ArrayList<Element> arrayList = new ArrayList<Element>(elementHandleArray.length);
                        for (ElementHandle elementHandle : elementHandleArray) {
                            arrayList.add(elementHandle.resolve((CompilationInfo)compilationController));
                        }
                        Element[] elementArray = arrayList.toArray(EMPTY_ELEMENTS_ARRAY);
                        JavaMembersModel.this.update(elementArray, (CompilationInfo)compilationController);
                    }
                }, true);
                return;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private void update(Element[] elementArray, CompilationInfo compilationInfo) {
        if (elementArray == null && elementArray.length == 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (Element element : elementArray) {
            if (element.getKind() == ElementKind.PACKAGE) {
                defaultMutableTreeNode.add(new PackageTreeNode(this.fileObject, (PackageElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM) {
                defaultMutableTreeNode.add(new TypeTreeNode(this.fileObject, (TypeElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                defaultMutableTreeNode.add(new ConstructorTreeNode(this.fileObject, (ExecutableElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() == ElementKind.METHOD) {
                defaultMutableTreeNode.add(new MethodTreeNode(this.fileObject, (ExecutableElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() == ElementKind.FIELD) {
                defaultMutableTreeNode.add(new FieldTreeNode(this.fileObject, (VariableElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            defaultMutableTreeNode.add(new EnumConstantTreeNode(this.fileObject, (VariableElement)element, compilationInfo));
        }
        this.setRoot(defaultMutableTreeNode);
    }

    boolean patternMatch(JavaElement javaElement) {
        return Utils.patternMatch(javaElement, this.pattern, this.patternLowerCase);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractMembersTreeNode
    extends DefaultMutableTreeNode
    implements JavaElement {
        private FileObject fileObject;
        private ElementHandle<? extends Element> elementHandle;
        private ElementKind elementKind;
        private Set<Modifier> modifiers;
        private String name = "";
        private String label = "";
        private String tooltip = null;
        private Icon icon = null;
        private String javaDoc = "";

        AbstractMembersTreeNode(FileObject fileObject, Element element, CompilationInfo compilationInfo) {
            this.fileObject = fileObject;
            this.elementHandle = ElementHandle.create((Element)element);
            this.elementKind = element.getKind();
            this.modifiers = element.getModifiers();
            this.setName(element.getSimpleName().toString());
            this.setIcon(UiUtils.getElementIcon((ElementKind)element.getKind(), element.getModifiers()));
            this.setLabel(Utils.format(element));
            this.setToolTip(Utils.format(element, true));
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
            if (doc != null) {
                StringBuilder stringBuilder = new StringBuilder();
                this.setJavaDoc(doc.getRawCommentText());
            }
            this.loadChildren(element, compilationInfo);
        }

        @Override
        public FileObject getFileObject() {
            return this.fileObject;
        }

        @Override
        public String getName() {
            return this.name;
        }

        protected void setName(String string) {
            this.name = string;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        protected void setLabel(String string) {
            this.label = string;
        }

        @Override
        public String getTooltip() {
            return this.tooltip;
        }

        protected void setToolTip(String string) {
            this.tooltip = string;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        protected void setIcon(Icon icon) {
            this.icon = icon;
        }

        protected void setElementHandle(ElementHandle<? extends Element> elementHandle) {
            this.elementHandle = elementHandle;
        }

        @Override
        public String getJavaDoc() {
            return this.javaDoc;
        }

        public void setJavaDoc(String string) {
            this.javaDoc = string;
        }

        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        @Override
        public ElementHandle getElementHandle() {
            return this.elementHandle;
        }

        @Override
        public void gotoElement() {
            this.openElementHandle();
        }

        protected abstract void loadChildren(Element var1, CompilationInfo var2);

        @Override
        public String toString() {
            return this.getLabel();
        }

        protected void openElementHandle() {
            if (this.elementHandle == null) {
                return;
            }
            UiUtils.open((FileObject)this.fileObject, this.elementHandle);
        }
    }

    private class ConstructorTreeNode
    extends AbstractMembersTreeNode {
        ConstructorTreeNode(FileObject fileObject, ExecutableElement executableElement, CompilationInfo compilationInfo) {
            super(fileObject, executableElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    private class EnumConstantTreeNode
    extends AbstractMembersTreeNode {
        EnumConstantTreeNode(FileObject fileObject, VariableElement variableElement, CompilationInfo compilationInfo) {
            super(fileObject, variableElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    private class FieldTreeNode
    extends AbstractMembersTreeNode {
        FieldTreeNode(FileObject fileObject, VariableElement variableElement, CompilationInfo compilationInfo) {
            super(fileObject, variableElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    private class MethodTreeNode
    extends AbstractMembersTreeNode {
        MethodTreeNode(FileObject fileObject, ExecutableElement executableElement, CompilationInfo compilationInfo) {
            super(fileObject, executableElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    private class PackageTreeNode
    extends AbstractMembersTreeNode {
        PackageTreeNode(FileObject fileObject, PackageElement packageElement, CompilationInfo compilationInfo) {
            super(fileObject, packageElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    private class TypeTreeNode
    extends AbstractMembersTreeNode {
        private boolean inSuperClassRole;

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo) {
            this(fileObject, typeElement, compilationInfo, false);
        }

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, boolean bl) {
            super(fileObject, typeElement, compilationInfo);
            this.inSuperClassRole = bl;
        }

        public boolean isLeaf() {
            return false;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
            this.loadChildren(element, compilationInfo, 0);
        }

        protected int loadChildren(Element element, CompilationInfo compilationInfo, int n) {
            Element element2;
            Object object;
            TypeElement typeElement = (TypeElement)element;
            List<? extends Element> list = typeElement.getEnclosedElements();
            for (Element object3 : list) {
                object = null;
                if (object3.getKind() == ElementKind.CLASS || object3.getKind() == ElementKind.INTERFACE || object3.getKind() == ElementKind.ENUM) {
                    if (!JavaMembersAndHierarchyOptions.isShowInner() || JavaMembersAndHierarchyOptions.isShowInherited()) continue;
                    object = new TypeTreeNode(this.getFileObject(), (TypeElement)object3, compilationInfo);
                } else {
                    Object object2 = object3.getModifiers();
                    if (object3.getKind() == ElementKind.CONSTRUCTOR) {
                        if (!JavaMembersAndHierarchyOptions.isShowConstructors()) continue;
                        element2 = (ExecutableElement)object3;
                        if (!object2.contains((Object)Modifier.PUBLIC) && !object2.contains((Object)Modifier.PROTECTED) && !object2.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPackage() || object2.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected() || object2.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate()) continue;
                        object = new ConstructorTreeNode(this.getFileObject(), (ExecutableElement)element2, compilationInfo);
                    } else if (object3.getKind() == ElementKind.METHOD) {
                        if (!JavaMembersAndHierarchyOptions.isShowMethods()) continue;
                        element2 = (ExecutableElement)object3;
                        if (!object2.contains((Object)Modifier.PUBLIC) && !object2.contains((Object)Modifier.PROTECTED) && !object2.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPackage() || object2.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected() || object2.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate() || object2.contains((Object)Modifier.STATIC) && !JavaMembersAndHierarchyOptions.isShowStatic()) continue;
                        object = new MethodTreeNode(this.getFileObject(), (ExecutableElement)element2, compilationInfo);
                    } else if (object3.getKind() == ElementKind.FIELD) {
                        if (!JavaMembersAndHierarchyOptions.isShowFields()) continue;
                        element2 = (VariableElement)object3;
                        if (!object2.contains((Object)Modifier.PUBLIC) && !object2.contains((Object)Modifier.PROTECTED) && !object2.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPackage() || object2.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected() || object2.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate() || object2.contains((Object)Modifier.STATIC) && !JavaMembersAndHierarchyOptions.isShowStatic()) continue;
                        object = new FieldTreeNode(this.getFileObject(), (VariableElement)element2, compilationInfo);
                    } else if (object3.getKind() == ElementKind.ENUM_CONSTANT) {
                        if (!JavaMembersAndHierarchyOptions.isShowEnumConstants()) continue;
                        element2 = (VariableElement)object3;
                        if (!object2.contains((Object)Modifier.PUBLIC) && !object2.contains((Object)Modifier.PROTECTED) && !object2.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPackage() || object2.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected() || object2.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate() || object2.contains((Object)Modifier.STATIC) && !JavaMembersAndHierarchyOptions.isShowStatic()) continue;
                        object = new EnumConstantTreeNode(this.getFileObject(), (VariableElement)element2, compilationInfo);
                    }
                    if (object == null || !JavaMembersModel.this.patternMatch((JavaElement)object)) continue;
                }
                if (object == null) continue;
                this.insert((MutableTreeNode)object, n++);
            }
            if (JavaMembersAndHierarchyOptions.isShowInherited()) {
                TypeElement typeElement2;
                TypeMirror typeMirror = typeElement.getSuperclass();
                if (typeMirror.getKind() != TypeKind.NONE && (typeElement2 = (TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement()) != null && !typeElement2.getQualifiedName().toString().equals(Object.class.getName())) {
                    object = SourceUtils.getFile((Element)typeElement2, (ClasspathInfo)compilationInfo.getClasspathInfo());
                    this.insert(new TypeTreeNode((FileObject)object, typeElement2, compilationInfo, true), n++);
                }
                List<? extends TypeMirror> list2 = typeElement.getInterfaces();
                for (Object object2 : list2) {
                    element2 = (TypeElement)((DeclaredType)object2).asElement();
                    FileObject fileObject = SourceUtils.getFile((Element)element2, (ClasspathInfo)compilationInfo.getClasspathInfo());
                    this.insert(new TypeTreeNode(fileObject, (TypeElement)element2, compilationInfo, true), n++);
                }
            }
            if (JavaMembersAndHierarchyOptions.isShowInner() && !this.inSuperClassRole && JavaMembersAndHierarchyOptions.isShowInherited()) {
                for (Element element3 : list) {
                    if (element3.getKind() != ElementKind.CLASS && element3.getKind() != ElementKind.INTERFACE && element3.getKind() != ElementKind.ENUM) continue;
                    object = new TypeTreeNode(this.getFileObject(), (TypeElement)element3, compilationInfo);
                    this.insert((MutableTreeNode)object, n++);
                }
            }
            return n;
        }
    }
}

