/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class JavadocTopComponent
extends TopComponent {
    private static final Logger LOGGER = Logger.getLogger(JavadocTopComponent.class.getName());
    private static JavadocTopComponent instance;
    public static final String ICON_PATH = "org/netbeans/modules/java/navigation/resources/javadoc_action.png";
    private static final String PREFERRED_ID = "JavadocTopComponent";
    private static final Rectangle ZERO;
    private JEditorPane javadocEditorPane;
    private JScrollPane javadocScrollPane;

    private JavadocTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(JavadocTopComponent.class, (String)"CTL_JavadocTopComponent"));
        this.setToolTipText(NbBundle.getMessage(JavadocTopComponent.class, (String)"HINT_JavadocTopComponent"));
        this.setIcon(Utilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    void setJavadoc(String string, String string2) {
        if (string2 == null) {
            this.javadocEditorPane.setText("");
        } else {
            string2 = string2.replaceAll("@author ", "<b>Author:</b> ").replaceAll("@deprecated ", "<b>Deprecated:</b> ").replaceAll("@exception ", "<b>Exception:</b> ").replaceAll("@param ", "<b>Parameter:</b> ").replaceAll("@return ", "<b>Return:</b> ").replaceAll("@see ", "<b>See:</b> ").replaceAll("@since ", "<b>Since:</b> ").replaceAll("@throws ", "<b>Throws:</b> ").replaceAll("@version ", "<b>Version:</b> ");
            this.javadocEditorPane.setText("<html><head></head><body>" + (string == null ? "" : "<b>" + string + "</b><br><hr>") + string2.replaceAll("\n", "<br>") + "</body>" + "</html>");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavadocTopComponent.this.javadocEditorPane.scrollRectToVisible(ZERO);
            }
        });
    }

    public static boolean shouldUpdate() {
        if (instance == null) {
            return false;
        }
        return instance.isShowing();
    }

    private void initComponents() {
        this.javadocScrollPane = new JScrollPane();
        this.javadocEditorPane = new JEditorPane();
        this.javadocEditorPane.setBackground(new Color(255, 255, 222));
        this.javadocEditorPane.setContentType("text/html");
        this.javadocEditorPane.setEditable(false);
        this.javadocScrollPane.setViewportView(this.javadocEditorPane);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.javadocScrollPane, -1, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.javadocScrollPane, -1, 300, Short.MAX_VALUE));
    }

    public static synchronized JavadocTopComponent getDefault() {
        if (instance == null) {
            instance = new JavadocTopComponent();
        }
        return instance;
    }

    public static synchronized JavadocTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            LOGGER.log(Level.WARNING, "Cannot find MyWindow component. It will not be located properly in the window system.");
            return JavadocTopComponent.getDefault();
        }
        if (topComponent instanceof JavadocTopComponent) {
            return (JavadocTopComponent)topComponent;
        }
        LOGGER.log(Level.WARNING, "There seem to be multiple components with the 'JavadocTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return JavadocTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static {
        ZERO = new Rectangle(0, 0, 1, 1);
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return JavadocTopComponent.getDefault();
        }
    }
}

