/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import org.netbeans.modules.java.navigation.base.TapPanel;

final class TrivialLayout
implements LayoutManager {
    TrivialLayout() {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public void layoutContainer(Container container) {
        if (container instanceof TapPanel) {
            this.layoutTapPanel((TapPanel)container);
        } else {
            this.layoutComp(container);
        }
    }

    private void layoutComp(Container container) {
        Component[] componentArray = container.getComponents();
        if (componentArray.length > 1) {
            Dimension dimension = componentArray[0].getPreferredSize();
            Dimension dimension2 = componentArray[1].getPreferredSize();
            int n = 0;
            dimension.width += 10;
            if (dimension2.height > dimension.height) {
                n = dimension2.height / 2 - dimension.height / 2;
            }
            if (container.getWidth() - dimension.width < dimension2.width) {
                componentArray[0].setBounds(0, 0, 0, 0);
                componentArray[1].setBounds(0, 0, container.getWidth(), container.getHeight());
            } else {
                componentArray[0].setBounds(0, n, dimension.width, dimension.height);
                componentArray[1].setBounds(dimension.width + 1, 0, container.getWidth() - dimension.width, Math.min(container.getHeight(), dimension2.height));
            }
        }
    }

    private void layoutTapPanel(TapPanel tapPanel) {
        Component[] componentArray = tapPanel.getComponents();
        if (componentArray.length > 1) {
            Dimension dimension = componentArray[0].getPreferredSize();
            Dimension dimension2 = componentArray[1].getPreferredSize();
            int n = 0;
            if (dimension2.height > dimension.height) {
                n = dimension2.height / 2 - dimension.height / 2 + 2;
            }
            if (tapPanel.isExpanded()) {
                int n2 = tapPanel.getOrientation() == 0 ? 0 : tapPanel.getMinimumHeight();
                int n3 = Math.min(tapPanel.getHeight() - tapPanel.getMinimumHeight(), dimension2.height);
                if (tapPanel.getWidth() - dimension.width < dimension2.width) {
                    componentArray[0].setBounds(0, 0, 0, 0);
                    componentArray[1].setBounds(0, n2, tapPanel.getWidth(), n3);
                } else {
                    componentArray[0].setBounds(0, n2 + n, dimension.width, dimension.height);
                    componentArray[1].setBounds(dimension.width + 1, n2, tapPanel.getWidth() - dimension.width, n3);
                }
            } else {
                componentArray[0].setBounds(0, 0, 0, 0);
                componentArray[1].setBounds(0, 0, 0, 0);
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(20, 10);
        Component[] componentArray = container.getComponents();
        TapPanel tapPanel = (TapPanel)container;
        if (componentArray.length > 1) {
            Dimension dimension2 = componentArray[0].getPreferredSize();
            Dimension dimension3 = componentArray[1].getPreferredSize();
            dimension.width = dimension2.width + dimension3.width;
            dimension.height = tapPanel.isExpanded() ? Math.max(dimension2.height, dimension3.height) + tapPanel.getMinimumHeight() : tapPanel.getMinimumHeight();
        }
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }
}

