/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.project.uiapi.DefaultProjectDeletePanel;
import org.netbeans.modules.project.uiapi.DefaultProjectRenamePanel;
import org.netbeans.modules.project.uiapi.ProjectCopyPanel;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ProjectOperations;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultProjectOperationsImplementation {
    private static final ErrorManager ERR = ErrorManager.getDefault();
    private static final double NOTIFY_WORK = 0.1;
    private static final double FIND_PROJECT_WORK = 0.1;
    static final int MAX_WORK = 100;

    private DefaultProjectOperationsImplementation() {
    }

    private static String getDisplayName(Project project) {
        return ProjectUtils.getInformation((Project)project).getDisplayName();
    }

    private static boolean performDelete(Project project, List<FileObject> list, ProgressHandle progressHandle) throws Exception {
        try {
            progressHandle.start(list.size() + 1);
            int n = 0;
            progressHandle.progress(NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Progress_Cleaning_Project"));
            ProjectOperations.notifyDeleting((Project)project);
            progressHandle.progress(++n);
            for (FileObject fileObject : list) {
                progressHandle.progress(NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Progress_Deleting_File", (Object)FileUtil.getFileDisplayName((FileObject)fileObject)));
                if (fileObject != null) {
                    fileObject.delete();
                }
                progressHandle.progress(++n);
            }
            FileObject fileObject = project.getProjectDirectory();
            if (fileObject.getChildren().length == 0) {
                fileObject.delete();
            }
            progressHandle.finish();
            ProjectOperations.notifyDeleted((Project)project);
            return true;
        }
        catch (Exception exception) {
            String string = DefaultProjectOperationsImplementation.getDisplayName(project);
            String string2 = NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Project_cannot_be_deleted.", (Object)string);
            ErrorManager.getDefault().annotate((Throwable)exception, string2);
            return false;
        }
    }

    public static void deleteProject(Project project) {
        DefaultProjectOperationsImplementation.deleteProject(project, new GUIUserInputHandler());
    }

    static void deleteProject(final Project project, UserInputHandler userInputHandler) {
        Object object;
        String string = DefaultProjectOperationsImplementation.getDisplayName(project);
        FileObject fileObject = project.getProjectDirectory();
        if (ERR.isLoggable(1)) {
            ERR.log(1, "delete started: " + string);
        }
        List list = ProjectOperations.getMetadataFiles((Project)project);
        List list2 = ProjectOperations.getDataFiles((Project)project);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        arrayList.addAll(list2);
        ProgressHandle progressHandle = arrayList.iterator();
        while (progressHandle.hasNext()) {
            object = (FileObject)progressHandle.next();
            if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)object)) continue;
            progressHandle.remove();
        }
        progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Delete_Project_Caption"));
        object = new DefaultProjectDeletePanel(progressHandle, string, FileUtil.getFileDisplayName((FileObject)fileObject), !list2.isEmpty());
        String string2 = NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Delete_Project_Caption");
        userInputHandler.showConfirmationDialog((JComponent)object, project, string2, "Yes_Button", "No_Button", true, new Executor((DefaultProjectDeletePanel)object, arrayList, progressHandle, list){
            final /* synthetic */ DefaultProjectDeletePanel val$deletePanel;
            final /* synthetic */ List val$allFiles;
            final /* synthetic */ ProgressHandle val$handle;
            final /* synthetic */ List val$metadataFiles;
            {
                this.val$deletePanel = defaultProjectDeletePanel;
                this.val$allFiles = list;
                this.val$handle = progressHandle;
                this.val$metadataFiles = list2;
            }

            public void execute() throws Exception {
                DefaultProjectOperationsImplementation.close(project);
                if (this.val$deletePanel.isDeleteSources()) {
                    DefaultProjectOperationsImplementation.performDelete(project, this.val$allFiles, this.val$handle);
                } else {
                    DefaultProjectOperationsImplementation.performDelete(project, this.val$metadataFiles, this.val$handle);
                }
            }
        });
        if (ERR.isLoggable(1)) {
            ERR.log(1, "delete done: " + string);
        }
    }

    public static void copyProject(final Project project) {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Copy_Project_Handle"));
        final ProjectCopyPanel projectCopyPanel = new ProjectCopyPanel(progressHandle, project, false);
        progressHandle.start(100);
        DefaultProjectOperationsImplementation.showConfirmationDialog(projectCopyPanel, project, NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Copy_Project_Caption"), "Copy_Button", null, false, new Executor(){

            public void execute() throws Exception {
                String string = projectCopyPanel.getNewName();
                File file = FileUtil.normalizeFile((File)projectCopyPanel.getNewDirectory());
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (fileObject == null) {
                    fileObject = DefaultProjectOperationsImplementation.createFolder(file.getParentFile(), file.getName());
                }
                DefaultProjectOperationsImplementation.doCopyProject(progressHandle, project, string, fileObject);
            }
        });
    }

    static void doCopyProject(ProgressHandle progressHandle, Project project, String string, FileObject fileObject) throws Exception {
        try {
            int n = 100;
            double d = 0.0;
            progressHandle.progress((int)d);
            ProjectOperations.notifyCopying((Project)project);
            d = (double)n * 0.1;
            progressHandle.progress((int)d);
            FileObject fileObject2 = fileObject.createFolder(string);
            FileObject fileObject3 = project.getProjectDirectory();
            List<FileObject> list = Arrays.asList(fileObject3.getChildren());
            double d2 = (double)n * 0.7000000000000001 / (double)list.size();
            for (FileObject fileObject4 : list) {
                DefaultProjectOperationsImplementation.doCopy(project, fileObject4, fileObject2);
                int n2 = (int)d;
                if (n2 >= (int)(d += d2)) continue;
                progressHandle.progress((int)d);
            }
            ProjectManager.getDefault().clearNonProjectCache();
            Project project2 = ProjectManager.getDefault().findProject(fileObject2);
            assert (project2 != null);
            progressHandle.progress((int)(d += (double)n * 0.1));
            ProjectOperations.notifyCopied((Project)project, (Project)project2, (File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)string);
            progressHandle.progress((int)(d += (double)n * 0.1));
            ProjectManager.getDefault().saveProject(project2);
            DefaultProjectOperationsImplementation.open(project2, false);
            progressHandle.progress(n);
            progressHandle.finish();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().annotate((Throwable)exception, NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ERR_Cannot_Move", (Object)exception.getLocalizedMessage()));
            throw exception;
        }
    }

    public static void moveProject(final Project project) {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Move_Project_Handle"));
        final ProjectCopyPanel projectCopyPanel = new ProjectCopyPanel(progressHandle, project, true);
        progressHandle.start(100);
        DefaultProjectOperationsImplementation.showConfirmationDialog(projectCopyPanel, project, NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Move_Project_Caption"), "Move_Button", null, false, new Executor(){

            public void execute() throws Exception {
                String string = projectCopyPanel.getProjectFolderName();
                String string2 = projectCopyPanel.getNewName();
                File file = FileUtil.normalizeFile((File)projectCopyPanel.getNewDirectory());
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (fileObject == null) {
                    fileObject = DefaultProjectOperationsImplementation.createFolder(file.getParentFile(), file.getName());
                }
                DefaultProjectOperationsImplementation.doMoveProject(progressHandle, project, string, string2, fileObject, "ERR_Cannot_Move");
            }
        });
    }

    public static void renameProject(Project project) {
        DefaultProjectOperationsImplementation.renameProject(project, null);
    }

    public static void renameProject(final Project project, String string) {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Rename_Project_Handle"));
        final DefaultProjectRenamePanel defaultProjectRenamePanel = new DefaultProjectRenamePanel(progressHandle, project, string);
        progressHandle.start(100);
        DefaultProjectOperationsImplementation.showConfirmationDialog(defaultProjectRenamePanel, project, NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Rename_Project_Caption"), "Rename_Button", null, false, new Executor(){

            public void execute() throws Exception {
                String string = defaultProjectRenamePanel.getNewName();
                if (defaultProjectRenamePanel.getRenameProjectFolder()) {
                    DefaultProjectOperationsImplementation.doMoveProject(progressHandle, project, string, string, project.getProjectDirectory().getParent(), "ERR_Cannot_Rename");
                } else {
                    boolean bl = true;
                    Project project3 = OpenProjects.getDefault().getMainProject();
                    boolean bl2 = project3 != null && project.getProjectDirectory().equals(project3.getProjectDirectory());
                    Project project2 = null;
                    try {
                        progressHandle.switchToIndeterminate();
                        progressHandle.switchToDeterminate(5);
                        int n = 0;
                        FileObject fileObject = project.getProjectDirectory();
                        File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
                        Collection collection = project.getLookup().lookupAll(MoveOperationImplementation.class);
                        DefaultProjectOperationsImplementation.close(project);
                        progressHandle.progress(++n);
                        for (MoveOperationImplementation moveOperationImplementation : collection) {
                            moveOperationImplementation.notifyMoving();
                        }
                        progressHandle.progress(++n);
                        for (MoveOperationImplementation moveOperationImplementation : collection) {
                            moveOperationImplementation.notifyMoved(null, file, string);
                        }
                        progressHandle.progress(++n);
                        ProjectManager.getDefault().clearNonProjectCache();
                        project2 = ProjectManager.getDefault().findProject(fileObject);
                        assert (project2 != null);
                        bl = false;
                        progressHandle.progress(++n);
                        collection = project2.getLookup().lookupAll(MoveOperationImplementation.class);
                        for (MoveOperationImplementation moveOperationImplementation : collection) {
                            moveOperationImplementation.notifyMoved(project, file, string);
                        }
                        ProjectManager.getDefault().saveProject(project2);
                        DefaultProjectOperationsImplementation.open(project2, bl2);
                        progressHandle.progress(++n);
                        progressHandle.finish();
                    }
                    catch (Exception exception) {
                        if (bl) {
                            DefaultProjectOperationsImplementation.open(project, bl2);
                        } else {
                            assert (project2 != null);
                            DefaultProjectOperationsImplementation.open(project2, bl2);
                        }
                        ErrorManager.getDefault().annotate((Throwable)exception, NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ERR_Cannot_Rename", (Object)exception.getLocalizedMessage()));
                        throw exception;
                    }
                }
            }
        });
    }

    static void doMoveProject(ProgressHandle progressHandle, Project project, String string, String string2, FileObject fileObject, String string3) throws Exception {
        boolean bl = true;
        Project project2 = OpenProjects.getDefault().getMainProject();
        boolean bl2 = project2 != null && project.getProjectDirectory().equals(project2.getProjectDirectory());
        FileObject fileObject2 = null;
        try {
            int n;
            int n2 = 100;
            double d = 0.0;
            progressHandle.progress((int)d);
            ProjectOperations.notifyMoving((Project)project);
            DefaultProjectOperationsImplementation.close(project);
            d = (double)n2 * 0.1;
            progressHandle.progress((int)d);
            FileObject fileObject3 = project.getProjectDirectory();
            List<FileObject> list = Arrays.asList(fileObject3.getChildren());
            double d2 = (double)n2 * 0.7000000000000001 / (double)list.size() / 2.0;
            fileObject2 = fileObject.createFolder(string);
            for (FileObject fileObject4 : list) {
                DefaultProjectOperationsImplementation.doCopy(project, fileObject4, fileObject2);
                n = (int)d;
                if (n >= (int)(d += d2)) continue;
                progressHandle.progress((int)d);
            }
            bl = false;
            for (FileObject fileObject4 : list) {
                DefaultProjectOperationsImplementation.doDelete(project, fileObject4);
                n = (int)d;
                if (n >= (int)(d += d2)) continue;
                progressHandle.progress((int)d);
            }
            if (fileObject3.getChildren().length == 0) {
                fileObject3.delete();
            }
            ProjectManager.getDefault().clearNonProjectCache();
            Project project3 = ProjectManager.getDefault().findProject(fileObject2);
            progressHandle.progress((int)(d += (double)n2 * 0.1));
            assert (project3 != null);
            ProjectOperations.notifyMoved((Project)project, (Project)project3, (File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)string2);
            progressHandle.progress((int)(d += (double)n2 * 0.1));
            ProjectManager.getDefault().saveProject(project3);
            DefaultProjectOperationsImplementation.open(project3, bl2);
            progressHandle.progress(n2);
            progressHandle.finish();
        }
        catch (Exception exception) {
            if (bl) {
                DefaultProjectOperationsImplementation.open(project, bl2);
            } else {
                assert (fileObject2 != null);
                ProjectManager.getDefault().clearNonProjectCache();
                Project project4 = ProjectManager.getDefault().findProject(fileObject2);
                assert (project4 != null);
                DefaultProjectOperationsImplementation.open(project4, bl2);
            }
            ErrorManager.getDefault().annotate((Throwable)exception, NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)string3, (Object)exception.getLocalizedMessage()));
            throw exception;
        }
    }

    private static void doCopy(Project project, FileObject fileObject, FileObject fileObject2) throws IOException {
        if (!VisibilityQuery.getDefault().isVisible(fileObject)) {
            return;
        }
        if (!project.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)fileObject).getProjectDirectory())) {
            return;
        }
        if (fileObject.isFolder()) {
            FileObject fileObject3 = fileObject2.createFolder(fileObject.getNameExt());
            for (FileObject fileObject4 : fileObject.getChildren()) {
                DefaultProjectOperationsImplementation.doCopy(project, fileObject4, fileObject3);
            }
        } else {
            assert (fileObject.isData());
            FileObject fileObject5 = FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)fileObject.getName(), (String)fileObject.getExt());
        }
    }

    private static FileObject createFolder(File file, String string) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            return fileObject.createFolder(string);
        }
        return DefaultProjectOperationsImplementation.createFolder(file.getParentFile(), file.getName()).createFolder(string);
    }

    private static boolean doDelete(Project project, FileObject fileObject) throws IOException {
        if (!project.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)fileObject).getProjectDirectory())) {
            return false;
        }
        if (fileObject.isFolder()) {
            boolean bl = true;
            for (FileObject fileObject2 : fileObject.getChildren()) {
                bl &= DefaultProjectOperationsImplementation.doDelete(project, fileObject2);
            }
            if (bl) {
                fileObject.delete();
            }
            return bl;
        }
        assert (fileObject.isData());
        fileObject.delete();
        return true;
    }

    private static JComponent wrapPanel(JComponent jComponent) {
        jComponent.setBorder(new EmptyBorder(12, 12, 12, 12));
        return jComponent;
    }

    private static void showConfirmationDialog(final JComponent jComponent, Project project, String string, String string2, String string3, boolean bl, final Executor executor) {
        final JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)("LBL_" + string2)));
        final JButton jButton2 = new JButton(string3 == null ? NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"LBL_Cancel_Button") : NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)("LBL_" + string3)));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)("ACSD_" + string2)));
        jButton2.getAccessibleContext().setAccessibleDescription(string3 == null ? NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ACSD_Cancel_Button") : NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)("ACSD_" + string3)));
        assert (jComponent instanceof InvalidablePanel);
        ((InvalidablePanel)((Object)jComponent)).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jButton.setEnabled(((InvalidablePanel)((Object)jComponent)).isPanelValid());
            }
        });
        jButton.setEnabled(((InvalidablePanel)((Object)jComponent)).isPanelValid());
        final Dialog[] dialogArray = new Dialog[1];
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)(bl ? jComponent : DefaultProjectOperationsImplementation.wrapPanel(jComponent)), string, true, new Object[]{jButton, jButton2}, (Object)(string3 != null ? jButton2 : jButton), 0, null, new ActionListener(){
            private boolean operationRunning;

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.operationRunning) {
                    return;
                }
                if (dialogArray[0] instanceof JDialog) {
                    ((JDialog)dialogArray[0]).getRootPane().getInputMap(1).remove(KeyStroke.getKeyStroke(27, 0));
                    ((JDialog)dialogArray[0]).setDefaultCloseOperation(0);
                }
                this.operationRunning = true;
                if (actionEvent.getSource() == jButton) {
                    Container container;
                    jButton.setEnabled(false);
                    jButton2.setEnabled(false);
                    ((InvalidablePanel)((Object)jComponent)).showProgress();
                    for (container = jComponent; container != null && !(container instanceof Window); container = container.getParent()) {
                    }
                    if (container != null) {
                        ((Window)container).pack();
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            Exception exception = null;
                            try {
                                executor.execute();
                            }
                            catch (Exception exception2) {
                                exception = exception2;
                            }
                            final Exception exception3 = exception;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    dialogArray[0].setVisible(false);
                                    if (exception3 != null) {
                                        ErrorManager.getDefault().notify(1, (Throwable)exception3);
                                        ErrorManager.getDefault().notify(256, (Throwable)exception3);
                                    }
                                }
                            });
                        }
                    });
                } else {
                    dialogArray[0].setVisible(false);
                }
            }
        });
        if (bl) {
            dialogDescriptor.setMessageType(3);
        }
        dialogDescriptor.setClosingOptions(new Object[0]);
        dialogArray[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialogArray[0].setVisible(true);
        dialogArray[0].dispose();
        dialogArray[0] = null;
    }

    static String computeError(File file, String string, boolean bl) {
        return DefaultProjectOperationsImplementation.computeError(file, string, null, bl);
    }

    static String computeError(File file, String string, String string2, boolean bl) {
        File file2 = file;
        if (!file.exists()) {
            for (file2 = file.getParentFile(); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
            }
            if (file2 == null) {
                return NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ERR_Location_Does_Not_Exist");
            }
        }
        if (!file2.canWrite()) {
            return NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ERR_Location_Read_Only");
        }
        if (string.length() == 0) {
            return NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ERR_Project_Name_Must_Entered");
        }
        File file3 = null;
        file3 = string2 == null ? new File(file, string) : new File(string2);
        if (file3.exists() && !bl) {
            return NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ERR_Project_Folder_Exists");
        }
        if (string.indexOf(47) != -1 || string.indexOf(92) != -1) {
            return NbBundle.getMessage(DefaultProjectOperationsImplementation.class, (String)"ERR_Not_Valid_Filename", (Object)string);
        }
        return null;
    }

    private static void close(final Project project) {
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                LifecycleManager.getDefault().saveAll();
                Action action = CommonProjectActions.closeProjectAction();
                Action action2 = action = action instanceof ContextAwareAction ? ((ContextAwareAction)action).createContextAwareInstance(Lookups.fixed((Object[])new Object[]{project})) : null;
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(new ActionEvent(project, -1, ""));
                } else {
                    OpenProjects.getDefault().close(new Project[]{project});
                }
                return null;
            }
        });
    }

    private static void open(final Project project, final boolean bl) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                OpenProjects.getDefault().open(new Project[]{project}, false);
                if (bl) {
                    OpenProjects.getDefault().setMainProject(project);
                }
            }
        });
    }

    static interface Executor {
        public void execute() throws Exception;
    }

    private static final class GUIUserInputHandler
    implements UserInputHandler {
        private GUIUserInputHandler() {
        }

        public void showConfirmationDialog(JComponent jComponent, Project project, String string, String string2, String string3, boolean bl, Executor executor) {
            DefaultProjectOperationsImplementation.showConfirmationDialog(jComponent, project, string, string2, string3, bl, executor);
        }
    }

    public static interface InvalidablePanel {
        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public boolean isPanelValid();

        public void showProgress();
    }

    static interface UserInputHandler {
        public void showConfirmationDialog(JComponent var1, Project var2, String var3, String var4, String var5, boolean var6, Executor var7);
    }
}

