/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.uiapi.DefaultProjectOperationsImplementation;
import org.netbeans.spi.project.support.ProjectOperations;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ProjectCopyPanel
extends JPanel
implements DocumentListener,
DefaultProjectOperationsImplementation.InvalidablePanel {
    private Project project;
    private boolean isMove;
    private boolean invalid;
    private List<ChangeListener> listeners;
    private ProgressHandle handle;
    private JButton browse;
    private JLabel errorMessage;
    private JLabel extSourcesWarning;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel nameLabel;
    private JPanel progress;
    private JPanel progressImpl;
    private JTextField projectFolder;
    private JTextField projectLocation;
    private JTextField projectName;
    private String lastComputedName;

    public ProjectCopyPanel(ProgressHandle progressHandle, Project project, boolean bl) {
        this.project = project;
        this.isMove = bl;
        this.listeners = new ArrayList<ChangeListener>();
        this.handle = progressHandle;
        this.initComponents();
        this.setProject();
        this.projectName.getDocument().addDocumentListener(this);
        this.projectLocation.getDocument().addDocumentListener(this);
        if (bl) {
            this.nameLabel.setVisible(false);
            this.projectName.setVisible(false);
        }
        if (Boolean.getBoolean("org.netbeans.modules.project.uiapi.DefaultProjectOperations.showProgress")) {
            ((CardLayout)this.progress.getLayout()).show(this.progress, "progress");
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.projectLocation = new JTextField();
        this.nameLabel = new JLabel();
        this.projectName = new JTextField();
        this.browse = new JButton();
        this.jLabel4 = new JLabel();
        this.projectFolder = new JTextField();
        this.extSourcesWarning = new JLabel();
        this.errorMessage = new JLabel();
        this.progress = new JPanel();
        this.jPanel4 = new JPanel();
        this.progressImpl = new JPanel();
        this.jLabel5 = new JLabel();
        this.jPanel3 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectCopyPanel.class, (String)"ACSD_Copy_Move_Panel", (Object[])new Object[]{new Integer(this.isMove ? 1 : 0)}));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProjectCopyPanel.class, (String)"LBL_Copy_Move_Dialog_Text", (Object[])new Object[]{new Integer(this.isMove ? 1 : 0), ProjectUtils.getInformation((Project)this.project).getDisplayName()}));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.projectLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ProjectCopyPanel.class, (String)"LBL_Project_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.projectLocation.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.add((Component)this.projectLocation, gridBagConstraints);
        this.projectLocation.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectCopyPanel.class, (String)"ACSN_Project_Location", (Object[])new Object[0]));
        this.projectLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectCopyPanel.class, (String)"ACSD_Project_Location", (Object[])new Object[0]));
        this.nameLabel.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(ProjectCopyPanel.class, (String)"LBL_Project_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.projectName.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 5);
        this.add((Component)this.projectName, gridBagConstraints);
        this.projectName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectCopyPanel.class, (String)"ACSN_Project_Name", (Object[])new Object[0]));
        this.projectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectCopyPanel.class, (String)"ACSD_Project_Name", (Object[])new Object[0]));
        Mnemonics.setLocalizedText((AbstractButton)this.browse, (String)NbBundle.getMessage(ProjectCopyPanel.class, (String)"LBL_Browse", (Object[])new Object[0]));
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectCopyPanel.this.browseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.browse, gridBagConstraints);
        this.browse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectCopyPanel.class, (String)"ACSD_Browse", (Object[])new Object[0]));
        this.jLabel4.setLabelFor(this.projectFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ProjectCopyPanel.class, (String)"LBL_Project_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.projectFolder.setColumns(30);
        this.projectFolder.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.add((Component)this.projectFolder, gridBagConstraints);
        this.projectFolder.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectCopyPanel.class, (String)"ACSN_Project_Folder", (Object[])new Object[0]));
        this.projectFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectCopyPanel.class, (String)"ACSD_Project_Folder", (Object[])new Object[0]));
        this.extSourcesWarning.setForeground(UIManager.getColor("nb.errorForeground"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.extSourcesWarning, gridBagConstraints);
        this.errorMessage.setForeground(UIManager.getColor("nb.errorForeground"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.errorMessage, gridBagConstraints);
        this.progress.setLayout(new CardLayout());
        this.progress.add((Component)this.jPanel4, "not-progress");
        this.progressImpl.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ProjectCopyPanel.class, (String)"LBL_Copying_Moving", (Object[])new Object[]{this.isMove ? new Integer(1) : new Integer(0)}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.progressImpl.add((Component)this.jLabel5, gridBagConstraints);
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add(ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.progressImpl.add((Component)this.jPanel3, gridBagConstraints);
        this.progress.add((Component)this.progressImpl, "progress");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.progress, gridBagConstraints);
    }

    private void browseActionPerformed(ActionEvent actionEvent) {
        File file = new File(this.projectLocation.getText());
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showOpenDialog(null) == 0) {
            this.projectLocation.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private String computeValidProjectName(String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            this.lastComputedName = string2;
            return string2;
        }
        int n = 1;
        String string3 = string2;
        if (new File(file, string3).exists()) {
            while (new File(file, string3 = string2 + "_" + n).exists()) {
                ++n;
            }
        }
        this.lastComputedName = string3;
        return string3;
    }

    private void setProject() {
        FileObject fileObject = this.project.getProjectDirectory().getParent();
        File file = FileUtil.toFile((FileObject)fileObject);
        this.projectLocation.setText(file.getAbsolutePath());
        if (this.isMove) {
            this.projectName.setText(ProjectUtils.getInformation((Project)this.project).getName());
        } else {
            this.projectName.setText(this.computeValidProjectName(file.getAbsolutePath(), ProjectUtils.getInformation((Project)this.project).getName()));
        }
        this.updateProjectFolder();
        this.validateDialog();
        if (this.hasExternalSources() && !this.isMove) {
            this.extSourcesWarning.setText(NbBundle.getMessage(ProjectCopyPanel.class, (String)"WRN_External_Sources"));
            this.invalid = true;
        }
    }

    private boolean hasExternalSources() {
        for (FileObject fileObject : ProjectOperations.getDataFiles((Project)this.project)) {
            if (FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject)) continue;
            return true;
        }
        return false;
    }

    public String getNewName() {
        return this.projectName.getText();
    }

    public String getProjectFolderName() {
        return this.project.getProjectDirectory().getNameExt();
    }

    public File getNewDirectory() {
        return new File(this.projectLocation.getText());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().equals(this.projectLocation.getDocument()) && this.lastComputedName != null && this.lastComputedName.equals(this.projectName.getText())) {
            this.projectName.setText(this.computeValidProjectName(new File(this.projectLocation.getText()).getAbsolutePath(), ProjectUtils.getInformation((Project)this.project).getName()));
        }
        this.updateProjectFolder();
        this.validateDialog();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().equals(this.projectLocation.getDocument()) && this.lastComputedName != null && this.lastComputedName.equals(this.projectName.getText())) {
            this.projectName.setText(this.computeValidProjectName(new File(this.projectLocation.getText()).getAbsolutePath(), ProjectUtils.getInformation((Project)this.project).getName()));
        }
        this.updateProjectFolder();
        this.validateDialog();
    }

    private void updateProjectFolder() {
        File file;
        File file2 = file = new File(this.projectLocation.getText());
        file2 = this.isMove ? new File(file, this.project.getProjectDirectory().getNameExt()) : new File(file, this.projectName.getText());
        this.projectFolder.setText(file2.getAbsolutePath());
    }

    public boolean isPanelValid() {
        return " ".equals(this.errorMessage.getText()) && !this.invalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDialog() {
        if (this.invalid) {
            return;
        }
        String string = this.computeError();
        boolean bl = false;
        String string2 = this.errorMessage.getText();
        string = string != null ? string : " ";
        bl = !string2.equals(string);
        this.errorMessage.setText(string);
        if (bl) {
            ChangeListener[] changeListenerArray;
            Serializable serializable = this;
            synchronized (serializable) {
                changeListenerArray = this.listeners.toArray(new ChangeListener[0]);
            }
            serializable = new ChangeEvent(this);
            for (ChangeListener changeListener : changeListenerArray) {
                changeListener.stateChanged((ChangeEvent)serializable);
            }
        }
    }

    private String computeError() {
        File file = new File(this.projectLocation.getText());
        return DefaultProjectOperationsImplementation.computeError(file, this.projectName.getText(), this.projectFolder.getText(), false);
    }

    public void showProgress() {
        this.projectFolder.setEnabled(false);
        this.projectLocation.setEnabled(false);
        this.projectName.setEnabled(false);
        this.browse.setEnabled(false);
        ((CardLayout)this.progress.getLayout()).show(this.progress, "progress");
    }
}

