/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tasklist.core.FilterTaskNode;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeMemberEvent;

final class FilteredTaskChildren
extends FilterNode.Children {
    private static final Logger LOGGER = TLUtils.getLogger(FilteredTaskChildren.class);
    private Filter filter;
    private TaskListView view;

    public FilteredTaskChildren(TaskListView taskListView, Node node, Filter filter) {
        super(node);
        this.filter = filter;
        this.view = taskListView;
    }

    protected Node[] createNodes(Node node) {
        if (!(node instanceof Node)) {
            return new Node[0];
        }
        Node node2 = node;
        Task task = TaskNode.getTask(node2);
        if (this.filter.accept(task)) {
            Object object = node2.getChildren() == Children.LEAF ? Children.LEAF : new FilteredTaskChildren(this.view, node2, this.filter);
            return new Node[]{new FilterTaskNode(node2, (Children)object, false)};
        }
        if (this.hasMatch(task)) {
            Object object = node2.getChildren() == Children.LEAF ? Children.LEAF : new FilteredTaskChildren(this.view, node2, this.filter);
            return new Node[]{new FilterTaskNode(node2, (Children)object, true)};
        }
        return new Node[0];
    }

    private boolean hasMatch(Task task) {
        if (this.filter.accept(task)) {
            return true;
        }
        Iterator iterator = task.subtasksIterator();
        while (iterator.hasNext()) {
            if (!this.hasMatch((Task)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public void filterChildrenAdded(NodeMemberEvent nodeMemberEvent) {
        super.filterChildrenAdded(nodeMemberEvent);
        if (this.view != null) {
            this.view.updateFilterCount();
        }
    }

    public void filterChildrenRemoved(NodeMemberEvent nodeMemberEvent) {
        super.filterChildrenRemoved(nodeMemberEvent);
        if (this.view != null) {
            this.view.updateFilterCount();
        }
    }

    static {
        LOGGER.setLevel(Level.OFF);
    }
}

