/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.awt.Toolkit;
import javax.swing.SwingUtilities;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class GoToTaskAction
extends NodeAction {
    private static final long serialVersionUID = 1L;

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] nodeArray) {
        final TaskListView taskListView = TaskListView.getCurrent();
        if (taskListView != null) {
            final Task task = TaskNode.getTask(nodeArray[0]);
            assert (task != null);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    taskListView.showTaskInEditor(task, null);
                }
            });
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        Task task = TaskNode.getTask(nodeArray[0]);
        if (task == null) {
            return false;
        }
        return task.getLine() != null;
    }

    public String getName() {
        return NbBundle.getMessage(GoToTaskAction.class, (String)"LBL_Goto");
    }

    protected String iconResource() {
        return "org/netbeans/modules/tasklist/core/showSource.gif";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

