/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskSelector;
import org.openide.text.Annotation;

public class TaskAnnotation
extends Annotation {
    protected Task task = null;
    private boolean highlight = false;
    private TaskSelector view;

    public TaskAnnotation(Task task) {
        this(task, true);
    }

    public TaskAnnotation(Task task, boolean bl) {
        this.task = task;
        this.highlight = bl;
    }

    public TaskAnnotation(Task task, TaskSelector taskSelector) {
        this.task = task;
        this.view = taskSelector;
        this.highlight = true;
    }

    public String getAnnotationType() {
        if (this.highlight) {
            return "Task";
        }
        return "TaskNoHighlight";
    }

    public String getShortDescription() {
        this.showTask();
        if (this.task.getDetails().length() > 0) {
            return this.task.getSummary() + "\n\n" + this.task.getDetails();
        }
        return this.task.getSummary();
    }

    protected void showTask() {
        if (this.view != null) {
            this.view.select(this.task);
        }
    }

    public Task getTask() {
        return this.task;
    }
}

