/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.tasklist.core.ColumnProperty;
import org.netbeans.modules.tasklist.core.FilterTaskNode;
import org.netbeans.modules.tasklist.core.FilteredTaskChildren;
import org.netbeans.modules.tasklist.core.MyTreeTableView;
import org.netbeans.modules.tasklist.core.ObservableList;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskAnnotation;
import org.netbeans.modules.tasklist.core.TaskEditorListener;
import org.netbeans.modules.tasklist.core.TaskList;
import org.netbeans.modules.tasklist.core.TaskListener;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.netbeans.modules.tasklist.core.TaskSelector;
import org.netbeans.modules.tasklist.core.TaskViewListener;
import org.netbeans.modules.tasklist.core.columns.ColumnsConfiguration;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterAction;
import org.netbeans.modules.tasklist.core.filter.FilterRepository;
import org.netbeans.modules.tasklist.core.filter.FilteredTopComponent;
import org.netbeans.modules.tasklist.core.filter.RemoveFilterAction;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class TaskListView
extends TopComponent
implements TaskListener,
ExplorerManager.Provider,
TaskSelector,
FilteredTopComponent {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = TLUtils.getLogger(TaskListView.class);
    private static transient Map views;
    private static int TOOLBAR_HEIGHT_ADJUSTMENT;
    private static int toolbarHeight;
    public static final String DEFAULT_FILTER_NAME;
    public static final String PROP_TASK_SUMMARY = "taskDesc";
    private static Map defColumns;
    protected transient Node rootNode = null;
    protected transient MyTreeTableView treeTable;
    protected transient ColumnProperty[] columns = null;
    private transient boolean initialized = false;
    protected transient String category = null;
    protected transient ObservableList tasklist = null;
    protected transient FilterRepository filters = null;
    protected transient Filter activeFilter = null;
    protected transient TaskAnnotation taskMarker = null;
    private transient Component centerCmp;
    private transient JPanel centerPanel;
    private transient Component northCmp;
    private transient boolean northCmpCreated;
    private transient JLabel miniStatus;
    private transient ExplorerManager manager;
    protected boolean persistent = false;
    private TaskEditorListener annotationManager = TaskEditorListener.getDefault();
    private Task unshowItem = null;
    private List listeningViews = null;
    private boolean lookupAttempted = false;
    private boolean wrapWarned = false;
    private TreeNode nextCandidate;
    private TreeNode prevCandidate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerTaskListView(TaskListView taskListView) {
        Class<TaskListView> clazz = TaskListView.class;
        synchronized (TaskListView.class) {
            if (views == null) {
                views = new HashMap();
            }
            views.put(taskListView.category, new WeakReference<TaskListView>(taskListView));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static TaskListView getTaskListView(String string) {
        assert (string != null);
        if (views == null) {
            return null;
        }
        Reference reference = (Reference)views.get(string);
        if (reference == null) {
            return null;
        }
        return (TaskListView)reference.get();
    }

    public TaskListView() {
        this.init_();
    }

    protected TaskListView(String string, String string2, Image image, boolean bl, ObservableList observableList) {
        this.init_();
        assert (string != null) : "category == null";
        this.category = string;
        this.setName(string2);
        this.persistent = bl;
        this.setIcon(image);
        TaskListView.registerTaskListView(this);
        this.setModel(observableList);
    }

    private void init_() {
        this.manager = new ExplorerManager();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        actionMap.put("jumpNext", new PrevNextAction(false));
        actionMap.put("jumpPrev", new PrevNextAction(true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)actionMap));
    }

    public int getPersistenceType() {
        if (this.persistent) {
            return 1;
        }
        return 2;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void updateFilterCount() {
        JLabel jLabel = this.getMiniStatus();
        if (this.getFilter() == null) {
            jLabel.setText("");
        } else {
            int n = TLUtils.getChildrenCountRecursively(this.rootNode);
            int n2 = TLUtils.getChildrenCountRecursively(this.getExplorerManager().getExploredContext());
            jLabel.setText(NbBundle.getMessage(TaskListView.class, (String)"FilterCount", (Object)new Integer(n2), (Object)new Integer(n)));
        }
    }

    protected void setNorthComponentVisible(boolean bl) {
        if (bl) {
            Component component = this.getNorthComponent();
            if (component != null) {
                this.centerPanel.add(component, "North");
                this.centerPanel.validate();
            }
        } else if (this.northCmp != null && this.northCmp.getParent() != null) {
            this.northCmp.getParent().remove(this.northCmp);
        }
    }

    public boolean isNorthComponentVisible() {
        return this.northCmp != null && this.northCmp.getParent() != null;
    }

    protected Component getNorthComponent() {
        if (!this.northCmpCreated) {
            this.northCmp = this.createNorthComponent();
            this.northCmpCreated = true;
        }
        return this.northCmp;
    }

    protected Component createNorthComponent() {
        return new JLabel("");
    }

    protected JLabel getMiniStatus() {
        if (this.miniStatus == null) {
            this.miniStatus = this.createMiniStatus();
        }
        return this.miniStatus;
    }

    private JLabel createMiniStatus() {
        JLabel jLabel = new JLabel();
        Dimension dimension = jLabel.getPreferredSize();
        dimension.height = TaskListView.getToolbarHeight();
        jLabel.setPreferredSize(dimension);
        return jLabel;
    }

    protected final void setMiniStatus(String string) {
        this.getMiniStatus().setText(string);
    }

    public static int getToolbarHeight() {
        if (toolbarHeight == -1) {
            BufferedImage bufferedImage = new BufferedImage(1, 1, 10);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
            int n = 0;
            String[] stringArray = new String[]{"Label.font", "Button.font", "ToggleButton.font"};
            for (int i = 0; i < stringArray.length; ++i) {
                Font font = uIDefaults.getFont(stringArray[i]);
                FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
                n = Math.max(n, fontMetrics.getHeight());
            }
            toolbarHeight = n + TOOLBAR_HEIGHT_ADJUSTMENT;
        }
        return toolbarHeight;
    }

    public void showTaskInEditor(Task task, TaskAnnotation taskAnnotation) {
        if (taskAnnotation == null) {
            taskAnnotation = this.getAnnotation(task);
        }
        this.annotationManager.showTask(task, taskAnnotation);
    }

    public void hideTaskInEditor() {
        this.annotationManager.hideTask();
    }

    protected SystemAction[] getToolBarActions() {
        return null;
    }

    protected SystemAction[] getGlobalToolBarActions() {
        return null;
    }

    public TableColumnModel getColumnModel() {
        return this.treeTable.getHeaderModel();
    }

    public final ColumnProperty[] getColumns() {
        if (this.columns == null) {
            this.columns = this.createColumns();
        }
        return this.columns;
    }

    protected ColumnsConfiguration getDefaultColumns() {
        ColumnsConfiguration columnsConfiguration = (ColumnsConfiguration)defColumns.get(this.category);
        if (columnsConfiguration != null) {
            return columnsConfiguration;
        }
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("TaskList/" + this.category + "/columns.settings");
        assert (fileObject != null) : "Missing config TaskList/" + this.category + "/columns.settings";
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            columnsConfiguration = (ColumnsConfiguration)instanceCookie.instanceCreate();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)classNotFoundException);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return columnsConfiguration;
    }

    protected void loadFilters() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("TaskList/" + this.category + "/filters.settings");
        assert (fileObject != null) : "Missing config TaskList/" + this.category + "/filters.settings";
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            this.filters = (FilterRepository)instanceCookie.instanceCreate();
            this.filters.setActive(null);
            if (this.filters.size() == 0) {
                Filter filter = this.createFilter();
                filter.setName(DEFAULT_FILTER_NAME);
                this.filters.add(filter);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)classNotFoundException);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    protected void componentOpened() {
        JToolBar jToolBar;
        LOGGER.fine("");
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        FindAction findAction = (FindAction)FindAction.get(FindAction.class);
        FilterAction filterAction = (FilterAction)FilterAction.get(FilterAction.class);
        this.getActionMap().put(findAction.getActionMapKey(), (Action)((Object)filterAction));
        this.setLayout(new BorderLayout());
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BorderLayout());
        this.centerCmp = this.createCenterComponent();
        this.centerPanel.add(this.centerCmp, "Center");
        this.add(this.centerPanel, "Center");
        this.loadColumnsConfiguration();
        Component component = this.getNorthComponent();
        if (component != null) {
            this.add(component, "North");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3, 0, 0));
        SystemAction[] systemActionArray = this.getGlobalToolBarActions();
        if (systemActionArray != null) {
            jToolBar = SystemAction.createToolbarPresenter((SystemAction[])systemActionArray);
            jToolBar.setFloatable(false);
            jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            jToolBar.setOrientation(1);
            jPanel.add(jToolBar);
        }
        if ((systemActionArray = this.getToolBarActions()) != null) {
            jToolBar = SystemAction.createToolbarPresenter((SystemAction[])systemActionArray);
            jToolBar.setFloatable(false);
            jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            jToolBar.setOrientation(1);
            jPanel.add(jToolBar);
        }
        this.add(jPanel, "West");
        this.setModel(this.tasklist);
    }

    protected Component createCenterComponent() {
        this.treeTable = new MyTreeTableView();
        if (this.columns == null) {
            this.columns = this.createColumns();
        }
        this.treeTable.setProperties((Node.Property[])this.columns);
        this.treeTable.setTreePreferredWidth(this.columns[0].getWidth());
        TableColumnModel tableColumnModel = this.treeTable.getHeaderModel();
        LOGGER.fine("number of columns " + tableColumnModel.getColumnCount());
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            ColumnProperty columnProperty = null;
            for (int j = 0; j < this.columns.length; ++j) {
                if (!this.columns[j].getDisplayName().equals(tableColumn.getHeaderValue())) continue;
                columnProperty = this.columns[j];
                break;
            }
            if (columnProperty == null) continue;
            tableColumn.setPreferredWidth(columnProperty.width);
        }
        this.treeTable.getTable().getTableHeader().setReorderingAllowed(false);
        this.treeTable.setRootVisible(false);
        this.treeTable.setVerticalScrollBarPolicy(22);
        this.treeTable.setHorizontalScrollBarPolicy(30);
        return this.treeTable;
    }

    protected void componentClosed() {
        this.hideTaskInEditor();
        this.hideList();
        if (this.unshowItem != null) {
            this.removedTask(null, this.unshowItem, 0);
        }
        this.unregisterListeners();
        this.storeColumnsConfiguration();
    }

    protected void componentActivated() {
        super.componentActivated();
        assert (this.initialized) : "#37438 dangling componentActivated event, no componentOpened() called at " + this;
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
        RemoveFilterAction removeFilterAction = (RemoveFilterAction)SystemAction.get(RemoveFilterAction.class);
        removeFilterAction.enable();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        assert (this.initialized) : "#37438 dangling componentDeactivated event, no componentOpened() called at " + this;
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
        this.storeColumnsConfiguration();
    }

    protected void storeColumnsConfiguration() {
        ColumnsConfiguration columnsConfiguration = this.getDefaultColumns();
        ColumnsConfiguration.loadColumnsFrom(this, columnsConfiguration);
    }

    protected void loadColumnsConfiguration() {
        ColumnsConfiguration columnsConfiguration = this.getDefaultColumns();
        ColumnsConfiguration.configureColumns(this, columnsConfiguration);
    }

    protected abstract Node createRootNode();

    protected void setModel(ObservableList observableList) {
        this.hideList();
        this.tasklist = observableList;
        if (observableList != null) {
            this.getModel().addTaskListener(this);
            this.setRoot();
        }
    }

    private void setRoot() {
        this.rootNode = this.createRootNode();
        this.rootNode.setDisplayName(this.getMainColumn(-1).getDisplayName());
        LOGGER.fine("root created " + this.rootNode);
        Node node = this.getExplorerManager().getRootContext();
        if (this.isFiltered()) {
            FilteredTaskChildren filteredTaskChildren = new FilteredTaskChildren(this, this.rootNode, this.getFilter());
            FilterTaskNode filterTaskNode = new FilterTaskNode(this.rootNode, (Children)filteredTaskChildren, false);
            this.getExplorerManager().setRootContext((Node)filterTaskNode);
        } else {
            this.getExplorerManager().setRootContext(this.rootNode);
        }
        try {
            if (node != null) {
                node.destroy();
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unexpected IOex in " + node);
        }
    }

    protected void hideList() {
        ObservableList observableList = this.getModel();
        if (observableList != null) {
            observableList.removeTaskListener(this);
        }
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public HelpCtx getHelpCtx() {
        return TaskListView.getHelpCtx(this.getExplorerManager().getSelectedNodes(), this.getExplorerManager().getRootContext().getHelpCtx());
    }

    private static HelpCtx getHelpCtx(Node[] nodeArray, HelpCtx helpCtx) {
        HelpCtx helpCtx2 = null;
        for (int i = 0; i < nodeArray.length; ++i) {
            HelpCtx helpCtx3 = nodeArray[i].getHelpCtx();
            if (helpCtx3 == null || helpCtx3.equals((Object)HelpCtx.DEFAULT_HELP)) continue;
            if (helpCtx2 == null || helpCtx2.equals((Object)helpCtx3)) {
                helpCtx2 = helpCtx3;
                continue;
            }
            helpCtx2 = null;
            break;
        }
        if (helpCtx2 != null) {
            return helpCtx2;
        }
        return helpCtx;
    }

    public JTable getTable() {
        return this.treeTable.getTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        int n2 = objectInput.read();
        String string = (String)objectInput.readObject();
        if (n2 == 4) {
            return;
        }
        int n3 = objectInput.read();
        int n4 = objectInput.read();
        int n5 = objectInput.read();
        if (n3 == 255) {
            n3 = -1;
        }
        if (n5 > 0) {
            int n6;
            if (this.columns == null) {
                this.columns = this.createColumns();
            }
            n = this.columns.length;
            boolean[] blArray = new boolean[n];
            for (n6 = 0; n6 < n; ++n6) {
                blArray[n6] = false;
            }
            for (n6 = 0; n6 < n5; ++n6) {
                int n7 = objectInput.read();
                if (n7 < n && this.columns[n7].uid == n7) continue;
                for (int i = 0; i < n && this.columns[i].uid != n7; ++i) {
                }
            }
        }
        if (n2 >= 2) {
            this.category = (String)objectInput.readObject();
            objectInput.readObject();
            n = objectInput.read();
            this.persistent = n != 0;
        } else {
            this.category = "usertasks";
        }
        Class<TaskListView> clazz = TaskListView.class;
        synchronized (TaskListView.class) {
            if (views == null) {
                views = new HashMap();
            }
            views.put(this.category, new WeakReference<TaskListView>(this));
            // ** MonitorExit[var7_8] (shouldn't be in output)
            return;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (!this.persistent) {
            ErrorManager.getDefault().log(1, "Warning: This tasklist window (" + this.getName() + ") should not have been persisted!");
            return;
        }
        objectOutput.write(4);
        objectOutput.writeObject(null);
    }

    protected abstract ColumnProperty[] createColumns();

    protected ColumnProperty getMainColumn(int n) {
        return new ColumnProperty(0, PROP_TASK_SUMMARY, NbBundle.getMessage(TaskListView.class, (String)"Description"), NbBundle.getMessage(TaskListView.class, (String)"Description"), true, n);
    }

    public void select(final Task task) {
        if (!this.isShowing()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Node node = TaskNode.find(TaskListView.this.getExplorerManager().getRootContext(), task);
                Node[] nodeArray = node == null ? new Node[]{} : new Node[]{node};
                try {
                    TaskListView.this.getExplorerManager().setSelectedNodes(nodeArray);
                }
                catch (PropertyVetoException propertyVetoException) {
                    ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
                }
            }
        });
    }

    public void expandAll() {
        if (this.treeTable != null) {
            this.treeTable.expandAll();
        }
    }

    public static TaskListView getCurrent() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        if (topComponent instanceof TaskListView) {
            return (TaskListView)topComponent;
        }
        if (views == null) {
            return null;
        }
        Collection collection = views.values();
        Iterator iterator = collection.iterator();
        TaskListView taskListView = null;
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            TaskListView taskListView2 = (TaskListView)reference.get();
            if (taskListView2 == null) continue;
            if (taskListView2.isShowing()) {
                return taskListView2;
            }
            if (taskListView != null) continue;
            taskListView = taskListView2;
        }
        return taskListView;
    }

    protected final List getListeningViews() {
        return this.listeningViews == null ? Collections.EMPTY_LIST : this.listeningViews;
    }

    void registerListeners() {
        Lookup.Template template;
        Lookup lookup = Lookup.getDefault();
        Iterator iterator = lookup.lookup(template = new Lookup.Template(TaskViewListener.class)).allInstances().iterator();
        if (iterator.hasNext()) {
            this.listeningViews = new ArrayList(4);
        }
        while (iterator.hasNext()) {
            TaskViewListener taskViewListener = (TaskViewListener)iterator.next();
            this.listeningViews.add(taskViewListener);
        }
    }

    private void unregisterListeners() {
        this.listeningViews = null;
    }

    public void showInMode() {
        Mode mode;
        if (!this.isOpened() && (mode = WindowManager.getDefault().findMode("output")) != null) {
            mode.dockInto((TopComponent)this);
        }
        this.open();
        this.requestVisible();
        this.requestActive();
    }

    public void selectedTask(Task task) {
        if (this.listeningViews != null) {
            this.unshowItem = task;
            int n = this.listeningViews.size();
            for (int i = 0; i < n; ++i) {
                TaskViewListener taskViewListener = (TaskViewListener)this.listeningViews.get(i);
                taskViewListener.showTask(task, this.getAnnotation(task));
            }
        }
    }

    public void warpedTask(Task task) {
        if (this.listeningViews != null) {
            this.unshowItem = task;
            int n = this.listeningViews.size();
            for (int i = 0; i < n; ++i) {
                TaskViewListener taskViewListener = (TaskViewListener)this.listeningViews.get(i);
                taskViewListener.showTask(task, null);
            }
        }
    }

    public void addedTask(Task task) {
    }

    public void removedTask(Task task, Task task2, int n) {
        if (task2 == this.unshowItem && this.listeningViews != null) {
            this.unshowItem = null;
            int n2 = this.listeningViews.size();
            for (int i = 0; i < n2; ++i) {
                TaskViewListener taskViewListener = (TaskViewListener)this.listeningViews.get(i);
                taskViewListener.hideTask();
            }
        }
    }

    public void structureChanged(Task task) {
    }

    public TaskList getList() {
        ObservableList observableList = this.getModel();
        assert (observableList instanceof TaskList) : "CCE " + observableList;
        return (TaskList)observableList;
    }

    public ObservableList getModel() {
        return this.tasklist;
    }

    private synchronized Comparator getRowComparator(final Node.Property property, final boolean bl, final boolean bl2, boolean bl3) {
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object == object2) {
                    return -1;
                }
                Node node = (Node)object;
                Node node2 = (Node)object2;
                if (property == null && !bl2) {
                    Node[] nodeArray = node.getParentNode().getChildren().getNodes();
                    for (int i = 0; i < nodeArray.length; ++i) {
                        if (nodeArray[i].equals((Object)node)) {
                            return -1;
                        }
                        if (!nodeArray[i].equals((Object)node2)) continue;
                        return 1;
                    }
                    return 0;
                }
                if (bl2) {
                    int n = node.getDisplayName().compareTo(node2.getDisplayName());
                    return bl ? n : -n;
                }
                Node.Property property3 = TaskListView.this.getNodeProperty(node, property);
                Node.Property property2 = TaskListView.this.getNodeProperty(node2, property);
                if (property3 == null && property2 == null) {
                    return 0;
                }
                try {
                    int n;
                    if (property3 == null) {
                        n = -1;
                    } else if (property2 == null) {
                        n = 1;
                    } else {
                        Object object3 = property3.getValue();
                        Object object4 = property2.getValue();
                        if (object3 == null && object4 == null) {
                            return 0;
                        }
                        if (object3 == null) {
                            n = -1;
                        } else if (object4 == null) {
                            n = 1;
                        } else {
                            if (object3.getClass() != object4.getClass() || !(object3 instanceof Comparable)) {
                                object3 = object3.toString();
                                object4 = object4.toString();
                            }
                            n = ((Comparable)object3).compareTo(object4);
                        }
                    }
                    return bl ? n : -n;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
        };
        return comparator;
    }

    private Node.Property getNodeProperty(Node node, Node.Property property) {
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        int n = propertySetArray.length;
        for (int i = 0; i < n; ++i) {
            Node.Property[] propertyArray = propertySetArray[i].getProperties();
            int n2 = propertyArray.length;
            for (int j = 0; j < n2; ++j) {
                if (!propertyArray[j].equals((Object)property)) continue;
                return propertyArray[j];
            }
        }
        return null;
    }

    public final Filter getFilter() {
        return this.activeFilter;
    }

    public FilterRepository getFilters() {
        if (this.filters == null) {
            this.loadFilters();
        }
        assert (this.filters != null) : "Missing FilterRepository";
        return this.filters;
    }

    public abstract Filter createFilter();

    public final boolean isFiltered() {
        return this.getFilter() != null;
    }

    protected void setFiltered() {
        if (this.getFilter() != null) {
            ((RemoveFilterAction)SystemAction.get(RemoveFilterAction.class)).enable();
        }
        try {
            this.getExplorerManager().setSelectedNodes(new Node[0]);
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify((Throwable)propertyVetoException);
        }
        this.setRoot();
        this.updateFilterCount();
    }

    public void setFilter(Filter filter) {
        if (filter == null || this.getFilters().contains(filter)) {
            this.getFilters().setActive(filter);
        }
        this.activeFilter = filter;
        this.setFiltered();
    }

    public List getSortedChildren(Node node, Node.Property property, boolean bl, boolean bl2, boolean bl3) {
        Node[] nodeArray = node.getChildren().getNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeArray.length);
        for (int i = 0; i < nodeArray.length; ++i) {
            arrayList.add(nodeArray[i]);
        }
        Comparator comparator = this.getRowComparator(property, bl, bl2, bl3);
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    private static void invokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private TreeNode findNextVisitable(TreeNode treeNode, boolean bl) {
        TreeNode treeNode2;
        TreeNode treeNode3 = null;
        if (treeNode.getChildCount() > 0) {
            treeNode3 = treeNode.getChildAt(0);
        } else {
            treeNode2 = treeNode.getParent();
            if (treeNode2 == null) {
                if (treeNode2.getChildCount() > 0) {
                    treeNode3 = treeNode2.getChildAt(0);
                }
            } else {
                int n = treeNode2.getIndex(treeNode);
                assert (n != -1);
                if (++n < treeNode.getParent().getChildCount()) {
                    treeNode3 = treeNode.getParent().getChildAt(n);
                }
            }
        }
        if (treeNode3 == null && bl) {
            treeNode2 = treeNode;
            while (treeNode2.getParent() != null) {
                treeNode2 = treeNode2.getParent();
            }
            if (treeNode2.getChildCount() > 0) {
                treeNode3 = treeNode2.getChildAt(0);
            }
        }
        if (treeNode3 == null) {
            return null;
        }
        if (TaskListView.isVisitable(treeNode3)) {
            return treeNode3;
        }
        return this.findNextVisitable(treeNode3, bl);
    }

    private static boolean isVisitable(TreeNode treeNode) {
        Node node = Visualizer.findNode((Object)treeNode);
        if (node == null) {
            return false;
        }
        Task task = (Task)node.getCookie(Task.class);
        return task != null && task.isVisitable();
    }

    private void selectNode(Node node) {
        if (node != null) {
            TaskAnnotation taskAnnotation;
            Task task = (Task)node.getCookie(Task.class);
            if (task.getLine() != null && (taskAnnotation = this.getAnnotation(task)) != null) {
                this.showTaskInEditor(task, taskAnnotation);
            }
            this.select(task);
        }
    }

    private static boolean isChildOf(TreeNode treeNode, TreeNode treeNode2) {
        if (treeNode == null) {
            return false;
        }
        if (treeNode == treeNode2) {
            return true;
        }
        for (TreeNode treeNode3 = treeNode.getParent(); treeNode3 != null; treeNode3 = treeNode3.getParent()) {
            if (treeNode3 != treeNode2) continue;
            return true;
        }
        return false;
    }

    private Node currentlySelected(boolean bl) {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray != null && nodeArray.length != 0) {
            if (bl) {
                return nodeArray[nodeArray.length - 1];
            }
            return nodeArray[0];
        }
        return null;
    }

    protected final void nextTask() {
        Object object;
        Node node = this.currentlySelected(true);
        Node node2 = null;
        TreeNode treeNode = null;
        if (node == null) {
            object = Visualizer.findVisualizer((Node)this.getExplorerManager().getRootContext());
            if (TaskListView.isChildOf(this.nextCandidate, (TreeNode)object)) {
                treeNode = TaskListView.isVisitable(this.nextCandidate) ? this.nextCandidate : this.findNextVisitable(this.nextCandidate, this.wrapWarned);
            } else {
                Node[] nodeArray = this.getExplorerManager().getRootContext().getChildren().getNodes();
                if (nodeArray != null && nodeArray.length > 0) {
                    treeNode = Visualizer.findVisualizer((Node)nodeArray[0]);
                }
            }
        } else {
            object = Visualizer.findVisualizer((Node)node);
            this.prevCandidate = object;
            treeNode = this.findNextVisitable((TreeNode)object, this.wrapWarned);
        }
        if (treeNode != null) {
            this.nextCandidate = this.findNextVisitable(treeNode, false);
            node2 = Visualizer.findNode((Object)treeNode);
        } else {
            this.nextCandidate = null;
        }
        if (node2 == null && !this.wrapWarned) {
            object = NbBundle.getBundle(TaskListView.class).getString("MSG_AtLastError");
            StatusDisplayer.getDefault().setStatusText((String)object);
            Toolkit.getDefaultToolkit().beep();
            this.wrapWarned = true;
        } else {
            this.wrapWarned = false;
        }
        this.selectNode(node2);
    }

    private TreeNode findPrevVisitable(TreeNode treeNode, boolean bl) {
        TreeNode treeNode2;
        int n = treeNode.getParent().getIndex(treeNode);
        assert (n != -1);
        if (--n >= 0) {
            treeNode2 = treeNode.getParent().getChildAt(n);
        } else {
            treeNode2 = treeNode.getParent();
            if (treeNode2.getParent() == null) {
                treeNode2 = null;
            }
        }
        if (treeNode2 == null && bl) {
            TreeNode treeNode3 = treeNode;
            while (treeNode3.getParent() != null) {
                treeNode3 = treeNode3.getParent();
            }
            treeNode2 = treeNode3;
            while (treeNode2.getChildCount() > 0) {
                treeNode2 = treeNode2.getChildAt(treeNode2.getChildCount() - 1);
            }
        }
        if (treeNode2 == null) {
            return null;
        }
        if (TaskListView.isVisitable(treeNode2)) {
            return treeNode2;
        }
        return this.findPrevVisitable(treeNode2, bl);
    }

    protected final void prevTask() {
        Object object;
        Node node = this.currentlySelected(false);
        Node node2 = null;
        TreeNode treeNode = null;
        if (node == null) {
            object = Visualizer.findVisualizer((Node)this.getExplorerManager().getRootContext());
            if (TaskListView.isChildOf(this.prevCandidate, (TreeNode)object)) {
                treeNode = TaskListView.isVisitable(this.prevCandidate) ? this.prevCandidate : this.findPrevVisitable(this.prevCandidate, this.wrapWarned);
            } else {
                Node[] nodeArray = this.getExplorerManager().getRootContext().getChildren().getNodes();
                if (nodeArray != null && nodeArray.length > 0) {
                    treeNode = Visualizer.findVisualizer((Node)nodeArray[nodeArray.length - 1]);
                }
            }
        } else {
            object = Visualizer.findVisualizer((Node)node);
            this.nextCandidate = object;
            treeNode = this.findPrevVisitable((TreeNode)object, this.wrapWarned);
        }
        if (treeNode != null) {
            this.prevCandidate = this.findNextVisitable(treeNode, false);
            node2 = Visualizer.findNode((Object)treeNode);
        } else {
            this.prevCandidate = null;
        }
        if (node2 == null && !this.wrapWarned) {
            object = NbBundle.getBundle(TaskListView.class).getString("MSG_AtFirstError");
            StatusDisplayer.getDefault().setStatusText((String)object);
            Toolkit.getDefaultToolkit().beep();
            this.wrapWarned = true;
        } else {
            this.wrapWarned = false;
        }
        this.selectNode(node2);
    }

    protected TaskAnnotation getAnnotation(Task task) {
        return new TaskAnnotation(task, this);
    }

    protected void componentHidden() {
        this.hideTaskInEditor();
    }

    protected final boolean isExpanded(Node node) {
        return this.treeTable.isExpanded(node);
    }

    protected final void setExpanded(Node node, boolean bl) {
        if (bl) {
            this.treeTable.expandNode(node);
        } else {
            this.treeTable.collapseNode(node);
        }
    }

    public final Node getEffectiveRoot() {
        return this.getExplorerManager().getRootContext();
    }

    public void scheduleNodeExpansion(final Task task, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Node node = TaskNode.find(TaskListView.this.getEffectiveRoot(), task);
                if (node != null) {
                    TaskListView.this.setExpanded(node, true);
                } else if (n < 50) {
                    TaskListView.this.scheduleNodeExpansion(task, n + 1);
                }
            }
        });
    }

    public void requestActive() {
        super.requestActive();
        if (this.treeTable != null) {
            this.treeTable.getTable().requestFocus();
        }
    }

    public final ColumnProperty[] getVisibleColumns() {
        TableColumnModel tableColumnModel = this.getTable().getColumnModel();
        ColumnProperty[] columnPropertyArray = this.getColumns();
        ArrayList<ColumnProperty> arrayList = new ArrayList<ColumnProperty>();
        arrayList.add(columnPropertyArray[0]);
        block0: for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            String string = tableColumnModel.getColumn(i).getHeaderValue().toString();
            for (int j = 1; j < columnPropertyArray.length; ++j) {
                if (!string.equalsIgnoreCase(columnPropertyArray[j].getDisplayName())) continue;
                arrayList.add(columnPropertyArray[j]);
                continue block0;
            }
        }
        return arrayList.toArray(new ColumnProperty[arrayList.size()]);
    }

    static {
        LOGGER.setLevel(Level.OFF);
        views = null;
        TOOLBAR_HEIGHT_ADJUSTMENT = 4;
        toolbarHeight = -1;
        DEFAULT_FILTER_NAME = NbBundle.getMessage(TaskListView.class, (String)"default-filter-name");
        defColumns = new HashMap();
    }

    private final class PrevNextAction
    extends AbstractAction {
        private boolean prev;

        public PrevNextAction(boolean bl) {
            this.prev = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.prev) {
                TaskListView.this.prevTask();
            } else {
                TaskListView.this.nextTask();
            }
        }
    }
}

