/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tasklist.core.ExpandAllAction;
import org.netbeans.modules.tasklist.core.FilterTaskNode;
import org.netbeans.modules.tasklist.core.SuggestionNodeProperty;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskChildren;
import org.netbeans.modules.tasklist.core.TaskListener;
import org.netbeans.modules.tasklist.core.TaskProperties;
import org.netbeans.modules.tasklist.core.TaskTransfer;
import org.netbeans.modules.tasklist.core.filter.FilterAction;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class TaskNode
extends AbstractNode {
    private static final Logger LOGGER = TLUtils.getLogger(TaskNode.class);
    protected final Task item;
    private Monitor monitor;

    public TaskNode(Task task, Children children) {
        super(children);
        this.item = task;
        this.init();
    }

    public TaskNode(Task task) {
        this(task, Children.LEAF);
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == Task.class) {
            return this.item;
        }
        return super.getCookie(clazz);
    }

    private void init() {
        this.setName(this.item.getSummary());
        this.monitor = new Monitor();
        this.item.addTaskListener(this.monitor);
        this.item.addPropertyChangeListener(this.monitor);
        DisposalListener disposalListener = new DisposalListener();
        this.addNodeListener((NodeListener)disposalListener);
        this.updateDisplayStuff();
        this.getCookieSet().add((Node.Cookie)new InstanceSupport.Instance((Object)this.item));
    }

    public TaskChildren getTaskChildren() {
        return (TaskChildren)this.getChildren();
    }

    public Node cloneNode() {
        TaskNode taskNode = new TaskNode(this.item);
        if (!taskNode.isLeaf()) {
            taskNode.setChildren((Children)((TaskChildren)((Object)this.getTaskChildren().clone())));
        }
        return taskNode;
    }

    protected TaskChildren createChildren() {
        return new TaskChildren(this.item);
    }

    protected final void updateDisplayStuff() {
        this.setDisplayName(this.item.getSummary());
        this.updateIcon();
    }

    protected void updateIcon() {
        this.setIconBase(this.item.getAction() != null ? "org/netbeans/modules/tasklist/core/lightbulb" : "org/netbeans/modules/tasklist/core/task");
    }

    public Image getIcon(int n) {
        if (this.item.getIcon() != null) {
            return this.item.getIcon();
        }
        return super.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        if (this.item.getIcon() != null) {
            return this.item.getIcon();
        }
        return super.getOpenedIcon(n);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TaskNode.class);
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{null, SystemAction.get(FilterAction.class), null, SystemAction.get(ExpandAllAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public void destroy() throws IOException {
        this.item.removePropertyChangeListener(this.monitor);
        this.item.removeTaskListener(this.monitor);
        Enumeration enumeration = this.getChildren().nodes();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            node.destroy();
        }
        super.destroy();
    }

    public boolean canDestroy() {
        return true;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put((Node.Property)new SuggestionNodeProperty(this.item, TaskProperties.PROP_SUMMARY));
        return sheet;
    }

    public boolean canRename() {
        return true;
    }

    public void setName(String string) {
        super.setName(string);
        if (!string.equals(this.item.getSummary())) {
            this.item.setSummary(string);
        }
    }

    protected void createPasteTypes(Transferable transferable, List list) {
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        LOGGER.fine("entering");
        return new ExTransferable.Single(TaskTransfer.TODO_FLAVOR){

            protected Object getData() {
                return TaskNode.this.item.clone();
            }
        };
    }

    public Transferable clipboardCut() throws IOException {
        this.destroy();
        return this.clipboardCopy();
    }

    public static Node find(Node node, Task task) {
        Task task2 = TaskNode.getTask(node);
        if (task2 == task) {
            return node;
        }
        LinkedList<Task> linkedList = new LinkedList<Task>();
        for (Task task3 = task; task3 != null && task3 != task2; task3 = task3.getParent()) {
            linkedList.addFirst(task3);
        }
        Node node2 = node;
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            Task task4 = (Task)listIterator.next();
            Children children = node2.getChildren();
            Node[] nodeArray = children.getNodes();
            for (int i = 0; i < nodeArray.length && TaskNode.getTask(node2 = nodeArray[i]) != task4; ++i) {
            }
        }
        if (TaskNode.getTask(node2) == task) {
            return node2;
        }
        return null;
    }

    public static Task getTask(Node node) {
        if (node == null) {
            return null;
        }
        return (Task)node.getCookie(Task.class);
    }

    public static TaskNode getTaskNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof TaskNode) {
            return (TaskNode)node;
        }
        if (node instanceof FilterTaskNode && (node = ((FilterTaskNode)node).getOriginal()) instanceof TaskNode) {
            return (TaskNode)node;
        }
        return null;
    }

    static {
        LOGGER.setLevel(Level.FINE);
    }

    private class DisposalListener
    extends NodeAdapter {
        public void nodeDestroyed(NodeEvent nodeEvent) {
            if (nodeEvent.getNode() == TaskNode.this) {
                TaskNode.this.item.removeTaskListener(TaskNode.this.monitor);
                TaskNode.this.item.removePropertyChangeListener(TaskNode.this.monitor);
            }
        }
    }

    private class Monitor
    implements TaskListener,
    PropertyChangeListener {
        public void selectedTask(Task task) {
        }

        public void warpedTask(Task task) {
        }

        public void addedTask(Task task) {
            Children children;
            if (task.getParent().getKey() == TaskNode.this.item.getKey() && (children = TaskNode.this.getChildren()) == Children.LEAF) {
                assert (TaskNode.this.item.hasSubtasks());
                TaskNode.this.setChildren((Children)TaskNode.this.createChildren());
            }
        }

        public void removedTask(Task task, Task task2, int n) {
        }

        public void structureChanged(Task task) {
            Children children;
            if (task == null) {
                return;
            }
            if (task.getKey() == TaskNode.this.item.getKey() && (children = TaskNode.this.getChildren()) == Children.LEAF && TaskNode.this.item.hasSubtasks()) {
                TaskNode.this.setChildren((Children)TaskNode.this.createChildren());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TaskNode.this.updateDisplayStuff();
            TaskNode.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }
}

