/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.openide.awt.Actions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class ToggleViewAction
extends BooleanStateAction
implements PropertyChangeListener,
Presenter.Menu {
    private static final long serialVersionUID = 1L;
    private boolean block;
    private String mode = "output";
    private WeakReference activated;

    public JMenuItem getMenuPresenter() {
        return new Actions.MenuItem((SystemAction)this, true);
    }

    public void setBooleanState(final boolean bl) {
        super.setBooleanState(bl);
        if (this.block) {
            return;
        }
        this.block = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToggleViewAction.this.toggleView(bl);
                ToggleViewAction.this.block = false;
            }
        });
    }

    protected abstract TopComponent getView();

    protected boolean isViewOpened() {
        return this.getView().isOpened();
    }

    private void toggleView(boolean bl) {
        if (bl == this.isViewOpened()) {
            return;
        }
        TopComponent topComponent = this.getView();
        WindowManager windowManager = WindowManager.getDefault();
        if (!bl) {
            TopComponent topComponent2;
            Mode mode = windowManager.findMode(topComponent);
            if (mode != null) {
                this.mode = mode.getName();
            }
            topComponent.close();
            if (this.activated != null && (topComponent2 = (TopComponent)this.activated.get()) != null) {
                topComponent2.requestActive();
            }
        } else {
            TopComponent topComponent3 = WindowManager.getDefault().getRegistry().getActivated();
            this.activated = topComponent3 == null ? null : new WeakReference<TopComponent>(topComponent3);
            Mode mode = windowManager.findMode(this.mode);
            if (mode != null) {
                mode.dockInto(topComponent);
            }
            topComponent.open();
            topComponent.requestVisible();
            topComponent.requestActive();
        }
    }

    protected void initialize() {
        super.initialize();
        WindowManager.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.putProperty("booleanState", this.isViewOpened());
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("opened")) {
            super.setBooleanState(this.isViewOpened());
        }
    }
}

