/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.editors;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.util.Date;
import javax.swing.JLabel;
import org.openide.ErrorManager;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public final class LineNumberPropertyEditor
extends PropertyEditorSupport {
    private static final JLabel LABEL = new JLabel();

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        if (rectangle.width <= 3) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        LABEL.setText(this.getAsText());
        LABEL.setSize(rectangle.width - 3, rectangle.height);
        LABEL.setForeground(graphics.getColor());
        LABEL.paint(graphics);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        try {
            if (string.trim().length() == 0) {
                this.setValue(new Integer(0));
            } else {
                this.setValue(new Integer(Integer.parseInt(string)));
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = NbBundle.getMessage(LineNumberPropertyEditor.class, (String)"IllegalLineNumber", (Object[])new Object[]{string});
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, string2, string2, (Throwable)numberFormatException, new Date());
            throw illegalArgumentException;
        }
    }

    public String getAsText() {
        int n;
        Object object = this.getValue();
        String string = object instanceof Line ? String.valueOf(((Line)object).getLineNumber() + 1) : (object instanceof Integer ? ((n = ((Integer)object).intValue()) <= 0 ? "" : String.valueOf(n)) : "");
        return string;
    }

    static {
        LABEL.setHorizontalAlignment(4);
    }
}

