/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.netbeans.modules.tasklist.core.filter.AppliedFilterCondition;
import org.netbeans.modules.tasklist.core.filter.FilterCondition;
import org.netbeans.modules.tasklist.core.filter.SuggestionProperty;
import org.openide.util.NbBundle;

public abstract class Filter {
    private boolean allTrue = false;
    private List appliedConditions = null;
    private String name = null;
    private boolean flattened;
    private PropertyChangeSupport pcs = null;
    private static final String NO_FILTER = NbBundle.getMessage(Filter.class, (String)"no-filter");
    public static final String PROP_NAME = "PropName";
    public static final String PROP_ALLTRUE = "PropAllTrue";
    public static final String PROP_CONDITIONS = "PropConditions";
    public static final String PROP_FLATTENED = "PropFlattened";

    protected PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    protected boolean hasListeners() {
        return this.pcs != null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getPCS().addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getPCS().removePropertyChangeListener(string, propertyChangeListener);
    }

    public Filter(String string) {
        this(string, true, new ArrayList(), false);
    }

    public Filter(String string, boolean bl, List list, boolean bl2) {
        this.name = string;
        this.allTrue = bl;
        this.appliedConditions = list;
        this.flattened = bl2;
    }

    protected Filter(Filter filter) {
        this(filter.name, filter.allTrue, Filter.cloneConditions(filter.appliedConditions), filter.flattened);
    }

    protected Filter() {
        this.name = null;
        this.appliedConditions = null;
    }

    private static List cloneConditions(List list) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((AppliedFilterCondition)iterator.next()).clone());
        }
        return linkedList;
    }

    public abstract Object clone();

    public abstract AppliedFilterCondition[] createConditions(SuggestionProperty var1);

    public abstract SuggestionProperty[] getProperties();

    public void clear() {
        Vector vector = null;
        if (this.hasListeners()) {
            vector = new Vector(this.appliedConditions);
        }
        this.getConditions().clear();
        if (this.hasListeners()) {
            this.fireChange(PROP_CONDITIONS, vector, Collections.EMPTY_LIST);
        }
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public void setFlattened(boolean bl) {
        if (bl != this.flattened) {
            this.flattened = bl;
            this.fireChange(PROP_FLATTENED, !bl, bl);
        }
    }

    public boolean accept(Object object) {
        if (!this.hasConstraints()) {
            return true;
        }
        Iterator iterator = this.appliedConditions.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            AppliedFilterCondition appliedFilterCondition = (AppliedFilterCondition)iterator.next();
            bl = appliedFilterCondition.isTrue(object);
            if (bl && !this.allTrue) {
                return true;
            }
            if (bl || !this.allTrue) continue;
            return false;
        }
        return bl;
    }

    public boolean matchAll() {
        return this.allTrue;
    }

    public boolean hasConstraints() {
        return this.appliedConditions != null && this.appliedConditions.size() > 0;
    }

    public void setMatchAll(boolean bl) {
        if (this.allTrue != bl) {
            this.allTrue = bl;
            this.fireChange(PROP_ALLTRUE, !bl, bl);
        }
    }

    public final List getConditions() {
        return this.appliedConditions;
    }

    public final void setConditions(List list) {
        Vector vector = null;
        if (this.hasListeners()) {
            vector = new Vector(list);
        }
        this.appliedConditions = list;
        if (this.hasListeners()) {
            this.fireChange(PROP_CONDITIONS, vector, this.appliedConditions);
        }
    }

    private void fireChange(String string, Object object, Object object2) {
        if (this.pcs != null) {
            this.getPCS().firePropertyChange(string, object, object2);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.fireChange(PROP_NAME, string2, string);
    }

    public String toString() {
        Iterator iterator = this.appliedConditions.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName() + "[name=" + this.name + ", ");
        stringBuffer.append(this.allTrue ? "ALL of the following conditions" : "ANY of the following conditions");
        stringBuffer.append(", ");
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected static AppliedFilterCondition[] applyConditions(SuggestionProperty suggestionProperty, FilterCondition[] filterConditionArray) {
        if (filterConditionArray == null) {
            return null;
        }
        AppliedFilterCondition[] appliedFilterConditionArray = new AppliedFilterCondition[filterConditionArray.length];
        for (int i = 0; i < filterConditionArray.length; ++i) {
            appliedFilterConditionArray[i] = new AppliedFilterCondition(suggestionProperty, filterConditionArray[i]);
        }
        return appliedFilterConditionArray;
    }

    public static class ListModelElement {
        public Filter filter;

        public ListModelElement(Filter filter) {
            this.filter = filter;
        }

        public String toString() {
            return this.filter != null ? this.filter.getName() : NO_FILTER;
        }

        public int hashCode() {
            return this.filter != null ? this.filter.hashCode() : 0;
        }

        public boolean equals(Object object) {
            if (object instanceof ListModelElement) {
                object = ((ListModelElement)object).filter;
            }
            return this.filter == object;
        }
    }
}

