/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterRepository;
import org.netbeans.modules.tasklist.core.filter.FilteredTopComponent;
import org.netbeans.modules.tasklist.core.filter.FiltersPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class FilterAction
extends CallableSystemAction {
    private static final long serialVersionUID = 1L;

    protected final boolean asynchronous() {
        return false;
    }

    public final void performAction() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        if (!(topComponent instanceof FilteredTopComponent)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final FilteredTopComponent filteredTopComponent = (FilteredTopComponent)topComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterAction.class, (String)"ACSD_Filter"));
        final FiltersPanel filtersPanel = new FiltersPanel(filteredTopComponent);
        jPanel.add((Component)filtersPanel, "Center");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getMessage(FilterAction.class, (String)"TITLE_filter"));
        dialogDescriptor.setModal(this.isModal());
        final JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(FilterAction.class, (String)"OK"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterAction.class, (String)"BTN_OK_Hint"));
        final JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(FilterAction.class, (String)"Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterAction.class, (String)"BTN_Cancel_Hint"));
        final JButton jButton3 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)NbBundle.getMessage(FilterAction.class, (String)"BTN_Preview"));
        jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterAction.class, (String)"BTN_Preview_Hint"));
        filtersPanel.addPropertyChangeListener("value-valid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jButton.setEnabled(filtersPanel.isValueValid());
                jButton3.setEnabled(filtersPanel.isValueValid());
            }
        });
        dialogDescriptor.setOptions((Object[])new JButton[]{jButton, jButton2, jButton3});
        dialogDescriptor.setMessageType(-1);
        dialogDescriptor.setButtonListener(new ActionListener(){
            private FilterRepository repositoryBackup = null;
            private Filter activeFilterBackup = null;

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == jButton) {
                    filtersPanel.updateFilters();
                    filteredTopComponent.setFilter(filteredTopComponent.getFilters().getActive());
                } else if (object == jButton2) {
                    if (this.repositoryBackup != null) {
                        filteredTopComponent.getFilters().assign(this.repositoryBackup);
                        filteredTopComponent.setFilter(this.activeFilterBackup);
                    }
                } else if (object == jButton3) {
                    if (this.repositoryBackup == null) {
                        this.repositoryBackup = (FilterRepository)filteredTopComponent.getFilters().clone();
                        this.activeFilterBackup = filteredTopComponent.getFilter();
                    }
                    filtersPanel.updateFilters();
                    filteredTopComponent.setFilter(filteredTopComponent.getFilters().getActive());
                }
            }
        });
        dialogDescriptor.setClosingOptions(new Object[]{jButton, jButton2});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
    }

    public final void performAction(SystemAction systemAction) {
        this.performAction();
    }

    protected Component createSubpanel() {
        return null;
    }

    protected Filter createFilter(TaskListView taskListView) {
        return taskListView.createFilter();
    }

    public String getName() {
        return NbBundle.getMessage(FilterAction.class, (String)"Filter");
    }

    protected String iconResource() {
        return "org/netbeans/modules/tasklist/core/filter/filter.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean isModal() {
        return false;
    }
}

