/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.netbeans.modules.tasklist.core.filter.AppliedFilterCondition;
import org.netbeans.modules.tasklist.core.filter.ConditionPanel;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterSubpanel;
import org.netbeans.modules.tasklist.core.filter.FilteredTopComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class FilterPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private FilteredTopComponent view;
    private Filter filter;
    private FilterSubpanel subpanel;
    final JPanel buttonsPanel = new JPanel();
    final JPanel conditionsPanel = new JPanel();
    final JScrollPane conditionsScrollPane = new JScrollPane();
    final JButton fewerButton = new JButton();
    final JTextField filterName = new JTextField();
    final JLabel filterNameLabel = new JLabel();
    final JRadioButton matchAllRadio = new JRadioButton();
    final JRadioButton matchAnyRadio = new JRadioButton();
    final ButtonGroup matchGroup = new ButtonGroup();
    final JButton moreButton = new JButton();
    final JPanel namePanel = new JPanel();
    final ButtonGroup subtaskGroup = new ButtonGroup();

    public FilterPanel(FilteredTopComponent filteredTopComponent, Filter filter) {
        this.view = filteredTopComponent;
        this.filter = filter;
        this.initComponents();
        this.initA11y();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.conditionsPanel, "North");
        this.conditionsScrollPane.setViewportView(jPanel);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.charWidth('n') * 80;
        int n2 = fontMetrics.getHeight() * 10;
        this.conditionsScrollPane.setPreferredSize(new Dimension(n, n2));
        Color color = (Color)UIManager.get("Table.background");
        this.conditionsPanel.setBackground(color);
        jPanel.setBackground(color);
        this.moreButton.addActionListener(this);
        this.fewerButton.addActionListener(this);
        this.matchAllRadio.addActionListener(this);
        this.matchAnyRadio.addActionListener(this);
        this.showFilter(filter);
        this.updateSensitivity();
    }

    public void initSubpanel(FilterSubpanel filterSubpanel) {
        assert (this.subpanel == null);
        this.subpanel = filterSubpanel;
    }

    private void showFilter(Filter filter) {
        if (filter != null) {
            if (filter.matchAll()) {
                this.matchAllRadio.setSelected(true);
            } else {
                this.matchAnyRadio.setSelected(true);
            }
            this.conditionsPanel.removeAll();
            List list = filter.getConditions();
            if (list.size() > 0) {
                for (AppliedFilterCondition appliedFilterCondition : list) {
                    this.addCondition(false, appliedFilterCondition);
                }
            } else {
                this.addCondition(false, null);
            }
            this.filterName.setText(filter.getName());
        } else {
            this.setEnabled(false);
            this.namePanel.setEnabled(false);
            this.filterName.setEnabled(false);
            this.filterName.setText(NbBundle.getMessage(FilterPanel.class, (String)"no-filter"));
            this.matchAnyRadio.setEnabled(false);
            this.matchAllRadio.setEnabled(false);
            this.conditionsPanel.setEnabled(false);
            this.moreButton.setEnabled(false);
            this.fewerButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.addFocusListener(this);
        this.namePanel.setLayout(new GridBagLayout());
        this.filterNameLabel.setLabelFor(this.filterName);
        this.filterNameLabel.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("LBL_Filter_Name_Hint"));
        this.filterNameLabel.setAlignmentY(0.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.namePanel.add((Component)this.filterNameLabel, gridBagConstraints);
        this.filterNameLabel.getAccessibleContext().setAccessibleName("<Name>");
        this.filterName.setText("jTextField1");
        this.filterName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("LBL_Filter_Name_Hint"));
        this.filterName.setAlignmentX(0.0f);
        this.filterName.setAlignmentY(0.0f);
        this.filterName.setPreferredSize(new Dimension(Short.MAX_VALUE, 20));
        this.filterName.addFocusListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.namePanel.add((Component)this.filterName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.namePanel, gridBagConstraints);
        this.matchGroup.add(this.matchAllRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.matchAllRadio, gridBagConstraints);
        this.matchGroup.add(this.matchAnyRadio);
        this.matchAnyRadio.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.matchAnyRadio, gridBagConstraints);
        this.conditionsScrollPane.setVerticalScrollBarPolicy(22);
        this.conditionsScrollPane.setAlignmentX(0.0f);
        this.conditionsScrollPane.setAlignmentY(0.0f);
        this.conditionsScrollPane.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.conditionsPanel.setLayout(new GridBagLayout());
        this.conditionsScrollPane.setViewportView(this.conditionsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.conditionsScrollPane, gridBagConstraints);
        this.conditionsScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle(FilterPanel.class).getString("LBL_Conditions"));
        this.conditionsScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(FilterPanel.class).getString("HNT_Conditions"));
        this.buttonsPanel.setLayout(new FlowLayout(0));
        this.buttonsPanel.add(this.moreButton);
        this.buttonsPanel.add(this.fewerButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.buttonsPanel, gridBagConstraints);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this) {
            this.formFocusGained(focusEvent);
        } else if (focusEvent.getSource() == this.filterName) {
            this.filterNameFocusGained(focusEvent);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private void filterNameFocusGained(FocusEvent focusEvent) {
        this.filterName.selectAll();
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.filterName.requestFocus();
    }

    private void initA11y() {
        Mnemonics.setLocalizedText((AbstractButton)this.matchAllRadio, (String)NbBundle.getMessage(FilterPanel.class, (String)"MatchAll"));
        this.matchAllRadio.setToolTipText(NbBundle.getMessage(FilterPanel.class, (String)"HINT_MatchAll"));
        Mnemonics.setLocalizedText((AbstractButton)this.matchAnyRadio, (String)NbBundle.getMessage(FilterPanel.class, (String)"MatchAny"));
        this.matchAnyRadio.setToolTipText(NbBundle.getMessage(FilterPanel.class, (String)"HINT_MatchAny"));
        Mnemonics.setLocalizedText((AbstractButton)this.moreButton, (String)NbBundle.getMessage(FilterPanel.class, (String)"More"));
        this.moreButton.setToolTipText(NbBundle.getMessage(FilterPanel.class, (String)"HINT_More"));
        Mnemonics.setLocalizedText((AbstractButton)this.fewerButton, (String)NbBundle.getMessage(FilterPanel.class, (String)"Fewer"));
        this.fewerButton.setToolTipText(NbBundle.getMessage(FilterPanel.class, (String)"HINT_Fewer"));
        Mnemonics.setLocalizedText((JLabel)this.filterNameLabel, (String)NbBundle.getMessage(FilterPanel.class, (String)"LBL_Filter_Name"));
        this.filterNameLabel.setToolTipText(NbBundle.getMessage(FilterPanel.class, (String)"LBL_Filter_Name_Hint"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterPanel.class, (String)"ACSD_Filter"));
        this.conditionsPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FilterPanel.class, (String)"ACSN_Conditions"));
        this.conditionsPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterPanel.class, (String)"ACSD_Conditions"));
    }

    private ConditionPanel addCondition(boolean bl, AppliedFilterCondition appliedFilterCondition) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        ConditionPanel conditionPanel = new ConditionPanel(this.filter, appliedFilterCondition);
        conditionPanel.addPropertyChangeListener("value-valid", this);
        conditionPanel.setBackground((Color)UIManager.get("Table.background"));
        this.conditionsPanel.add((Component)conditionPanel, gridBagConstraints);
        if (bl) {
            this.invalidate();
            this.getParent().validate();
            this.repaint();
        }
        this.putClientProperty("value-valid", this.isValueValid());
        return conditionPanel;
    }

    public final boolean isValueValid() {
        Component[] componentArray = this.conditionsPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ConditionPanel conditionPanel = (ConditionPanel)componentArray[i];
            if (conditionPanel == null || conditionPanel.isValueValid()) continue;
            return false;
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.putClientProperty("value-valid", this.isValueValid());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.moreButton) {
            ConditionPanel conditionPanel = this.addCondition(true, null);
            JScrollBar jScrollBar = this.conditionsScrollPane.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMaximum());
            conditionPanel.focusPropertyCombo();
        } else if (object == this.fewerButton) {
            this.conditionsPanel.remove(this.conditionsPanel.getComponentCount() - 1);
            this.invalidate();
            this.getParent().validate();
            this.repaint();
        }
        this.updateSensitivity();
    }

    private void updateSensitivity() {
        int n = this.conditionsPanel.getComponentCount();
        this.fewerButton.setEnabled(n > 0);
    }

    public Filter getFilter() {
        if (this.filter != null) {
            Component[] componentArray = this.conditionsPanel.getComponents();
            ArrayList<AppliedFilterCondition> arrayList = new ArrayList<AppliedFilterCondition>(componentArray.length);
            for (int i = 0; i < componentArray.length; ++i) {
                AppliedFilterCondition appliedFilterCondition = ((ConditionPanel)componentArray[i]).getCondition();
                if (appliedFilterCondition == null) continue;
                arrayList.add(appliedFilterCondition);
            }
            this.filter.setName(this.filterName.getText());
            this.filter.setConditions(arrayList);
            this.filter.setMatchAll(this.matchAllRadio.isSelected());
            this.filter.setFlattened(true);
            if (this.subpanel != null) {
                this.subpanel.updateFilter(this.filter);
            }
        }
        return this.filter;
    }

    public JTextField getFilterNameField() {
        return this.filterName;
    }
}

