/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterPanel;
import org.netbeans.modules.tasklist.core.filter.FilterRepository;
import org.netbeans.modules.tasklist.core.filter.FilteredTopComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FiltersPanel
extends JPanel
implements ActionListener {
    public static final String SELECTED_FILTER = "fp-selected-filter";
    private HashMap panels = new HashMap(10);
    private FilteredTopComponent view;
    private FilterRepository filterRepository;
    private FilterModel filterModel;
    final JButton DeleteButton = new JButton();
    final JPanel buttons1Panel = new JPanel();
    final JPanel buttons2Panel = new JPanel();
    final JPanel filterEditorPlaceholder = new JPanel();
    final JScrollPane filterListScrollPane = new JScrollPane();
    final JLabel filtersLabel = new JLabel();
    final JList filtersList = new JList();
    final JButton newButton = new JButton();

    public FiltersPanel(FilteredTopComponent filteredTopComponent) {
        this.view = filteredTopComponent;
        this.filterRepository = filteredTopComponent.getFilters();
        this.filterModel = new FilterModel(this.filterRepository);
        Iterator iterator = this.filterModel.filters.iterator();
        while (iterator.hasNext()) {
            this.panels.put(iterator.next(), null);
        }
        this.myInitComponents();
    }

    public FilterRepository getFilterRepository() {
        return this.filterRepository;
    }

    private void myInitComponents() {
        this.initComponents();
        this.filtersList.setModel(this.filterModel);
        this.filtersList.setSelectionModel(this.filterModel.selection);
        this.filtersList.setSelectionMode(0);
        Object object = null;
        if (this.view instanceof JComponent) {
            object = ((JComponent)((Object)this.view)).getClientProperty(SELECTED_FILTER);
        }
        if (object != null && object instanceof String) {
            Iterator iterator = this.filterModel.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Filter filter = (Filter)iterator.next();
                if (object.equals(filter.getName())) {
                    this.filtersList.setSelectedIndex(n);
                    break;
                }
                ++n;
            }
        }
        if (this.filterModel.getSelectedIndex() == -1 && this.filterModel.getSize() > 0) {
            this.filtersList.setSelectedIndex(0);
        }
        this.filtersList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    FiltersPanel.this.showFilter(FiltersPanel.this.filterModel.getSelectedFilter());
                    FiltersPanel.this.DeleteButton.setEnabled(FiltersPanel.this.filterModel.getSelectedIndex() != -1);
                }
            }
        });
        this.showFilter(this.filterModel.getSelectedFilter());
        this.DeleteButton.setEnabled(this.filterModel.getSelectedIndex() != -1);
        Mnemonics.setLocalizedText((JLabel)this.filtersLabel, (String)NbBundle.getMessage(FiltersPanel.class, (String)"LBL_Filters"));
    }

    private void showFilter(final Filter filter) {
        FilterPanel filterPanel = (FilterPanel)this.panels.get(filter);
        if (filterPanel == null) {
            filterPanel = new FilterPanel(this.view, filter);
            this.panels.put(filter, filterPanel);
            filterPanel.getFilterNameField().getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.update(documentEvent);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.update(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.update(documentEvent);
                }

                private void update(DocumentEvent documentEvent) {
                    try {
                        FiltersPanel.this.filterModel.setFilterName(FiltersPanel.this.filterModel.getIndexOf(filter), documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()));
                    }
                    catch (BadLocationException badLocationException) {
                        System.err.println("EXXXX");
                    }
                }
            });
        }
        if (this.filterEditorPlaceholder.getComponentCount() > 0) {
            this.filterEditorPlaceholder.remove(0);
        }
        this.filterEditorPlaceholder.add((Component)filterPanel, "Center");
        filterPanel.setVisible(true);
        filterPanel.requestFocus();
        if (this.filterModel.getSelectedFilter() != filter) {
            this.filtersList.setSelectedIndex(this.filterModel.getIndexOf(filter));
        }
        this.filterEditorPlaceholder.validate();
        this.filterEditorPlaceholder.repaint();
    }

    public boolean isValueValid() {
        for (FilterPanel filterPanel : this.panels.values()) {
            if (filterPanel.isValueValid()) continue;
            return false;
        }
        return true;
    }

    public void updateFilters() {
        this.filterRepository.clear();
        Iterator iterator = this.filterModel.iterator();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            if (this.panels.get(filter) != null) {
                filter = ((FilterPanel)this.panels.get(filter)).getFilter();
            }
            this.filterRepository.add(filter);
        }
        if (this.filterModel.getSelectedFilter() != null) {
            this.filterRepository.setActive(this.filterModel.getSelectedFilter());
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(800, 500));
        this.setRequestFocusEnabled(false);
        this.filterEditorPlaceholder.setLayout(new BorderLayout());
        this.filterEditorPlaceholder.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.filterEditorPlaceholder.setAlignmentX(0.0f);
        this.filterEditorPlaceholder.setMinimumSize(new Dimension(0, 0));
        this.filterEditorPlaceholder.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filterEditorPlaceholder, gridBagConstraints);
        this.buttons1Panel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("BTN_New_Filter"));
        this.newButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("BTN_New_Filter_Hint"));
        this.newButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.buttons1Panel.add((Component)this.newButton, gridBagConstraints);
        this.newButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FiltersPanel.class, (String)"ACSN_NewFilter"));
        this.newButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FiltersPanel.class, (String)"ACSD_NewFilter"));
        Mnemonics.setLocalizedText((AbstractButton)this.DeleteButton, (String)ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("BTN_Delete_Filter"));
        this.DeleteButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/tasklist/core/filter/Bundle").getString("BTN_Delete_Filter_Hint"));
        this.DeleteButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.buttons1Panel.add((Component)this.DeleteButton, gridBagConstraints);
        this.DeleteButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FiltersPanel.class, (String)"ACSN_DeleteFilter"));
        this.DeleteButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FiltersPanel.class, (String)"ACSD_DeleteFilter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.buttons1Panel, gridBagConstraints);
        this.buttons2Panel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.buttons2Panel, gridBagConstraints);
        this.filterListScrollPane.setVerticalScrollBarPolicy(22);
        this.filterListScrollPane.setAlignmentX(0.0f);
        this.filterListScrollPane.setAlignmentY(0.0f);
        this.filterListScrollPane.setMinimumSize(new Dimension(0, 0));
        this.filterListScrollPane.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.filterListScrollPane.setAutoscrolls(true);
        this.filtersList.setSelectionMode(0);
        this.filtersList.setAlignmentX(0.0f);
        this.filtersList.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.filterListScrollPane.setViewportView(this.filtersList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filterListScrollPane, gridBagConstraints);
        this.filterListScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle(FiltersPanel.class).getString("ACSN_Filters"));
        this.filterListScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(FiltersPanel.class).getString("ACSD_Filters"));
        this.filtersLabel.setLabelFor(this.filtersList);
        Mnemonics.setLocalizedText((JLabel)this.filtersLabel, (String)NbBundle.getBundle(FiltersPanel.class).getString("LBL_Filters"));
        this.filtersLabel.setToolTipText(NbBundle.getBundle(FiltersPanel.class).getString("HNT_Filters"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.filtersLabel, gridBagConstraints);
        this.filtersLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(FiltersPanel.class).getString("ACSN_Filters"));
        this.filtersLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(FiltersPanel.class).getString("ACSD_Filters"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.newButton) {
            this.newButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.DeleteButton) {
            this.DeleteButtonActionPerformed(actionEvent);
        }
    }

    private void previewButtonActionPerformed(ActionEvent actionEvent) {
    }

    private void DeleteButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.filterModel.getSelectedIndex();
        if (n != -1) {
            Filter filter = this.filterModel.get(n);
            this.filterModel.remove(n);
            this.panels.remove(filter);
        }
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        Filter filter = this.view.createFilter();
        this.filterModel.add(filter);
        this.panels.put(filter, null);
        this.showFilter(filter);
    }

    private static class FilterModel
    extends AbstractListModel {
        public DefaultListSelectionModel selection = new DefaultListSelectionModel();
        public Vector filters;

        public FilterModel(FilterRepository filterRepository) {
            this.filters = new Vector(filterRepository.size() * 2);
            Iterator iterator = filterRepository.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Filter filter = (Filter)iterator.next();
                if (filter == filterRepository.getActive()) {
                    this.selection.setSelectionInterval(n, n);
                }
                this.filters.add(filter.clone());
                ++n;
            }
        }

        public Iterator iterator() {
            return this.filters.iterator();
        }

        public Object getElementAt(int n) {
            return ((Filter)this.filters.get(n)).getName();
        }

        public int getSize() {
            return this.filters.size();
        }

        public Filter getSelectedFilter() {
            if (this.getSelectedIndex() > -1) {
                return (Filter)this.filters.get(this.getSelectedIndex());
            }
            return null;
        }

        public int getSelectedIndex() {
            int n;
            int n2 = this.selection.getMinSelectionIndex();
            if (n2 == (n = this.selection.getMaxSelectionIndex()) && n2 >= 0 && n2 < this.filters.size()) {
                return n2;
            }
            return -1;
        }

        public void remove(int n) {
            int n2 = this.getSelectedIndex();
            if (n2 != -1) {
                this.filters.remove(n);
                this.fireIntervalRemoved(this, n, n);
                if (n < n2) {
                    this.selection.setSelectionInterval(n2 - 1, n2 - 1);
                }
                if (n == n2) {
                    this.selection.setSelectionInterval(100, 0);
                }
            }
        }

        public Filter get(int n) {
            return (Filter)this.filters.get(n);
        }

        public boolean add(Filter filter) {
            if (this.filters.add(filter)) {
                this.fireIntervalAdded(this, this.filters.size() - 1, this.filters.size() - 1);
                return true;
            }
            return false;
        }

        public int getIndexOf(Filter filter) {
            return this.filters.indexOf(filter);
        }

        public void setFilterName(int n, String string) {
            if (this.get(n) != null) {
                this.get(n).setName(string);
                this.fireContentsChanged(this, n, n);
            }
        }
    }
}

