/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.io.IOException;
import org.netbeans.modules.tasklist.core.filter.FilterCondition;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class OneOfFilterCondition
extends FilterCondition {
    private String[] options = null;
    private int id;

    public OneOfFilterCondition(String[] stringArray, int n) {
        this.options = stringArray;
        this.id = n;
    }

    public OneOfFilterCondition(OneOfFilterCondition oneOfFilterCondition) {
        super(oneOfFilterCondition);
        this.options = oneOfFilterCondition.options;
        this.id = oneOfFilterCondition.id;
    }

    protected OneOfFilterCondition(String[] stringArray) {
        this.options = stringArray;
        this.id = -1;
    }

    public boolean sameType(FilterCondition filterCondition) {
        return super.sameType(filterCondition) && this.id == ((OneOfFilterCondition)filterCondition).id;
    }

    protected String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)this.options[this.id]);
    }

    protected int getId() {
        return this.id;
    }

    protected static abstract class Convertor
    extends FilterCondition.Convertor {
        private static final String ATTR_ID = "id";
        private String[] nameKeys;

        public Convertor(String string, String[] stringArray) {
            super(string);
            this.nameKeys = stringArray;
        }

        protected OneOfFilterCondition createCondition() {
            throw new UnsupportedOperationException();
        }

        protected void readCondition(Element element, OneOfFilterCondition oneOfFilterCondition) throws IOException, ClassNotFoundException {
            super.readCondition(element, oneOfFilterCondition);
            oneOfFilterCondition.id = Convertor.findIndex(element.getAttribute(ATTR_ID), this.nameKeys);
        }

        protected Object readElement(Element element) throws IOException, ClassNotFoundException {
            OneOfFilterCondition oneOfFilterCondition = this.createCondition();
            this.readCondition(element, oneOfFilterCondition);
            return oneOfFilterCondition;
        }

        protected void writeCondition(Document document, Element element, OneOfFilterCondition oneOfFilterCondition) throws IOException, DOMException {
            super.writeCondition(document, element, oneOfFilterCondition);
            element.setAttribute(ATTR_ID, this.nameKeys[oneOfFilterCondition.id]);
        }

        protected void writeElement(Document document, Element element, Object object) throws IOException, DOMException {
            this.writeCondition(document, element, (OneOfFilterCondition)object);
        }

        protected static int findIndex(String string, String[] stringArray) throws IOException {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return i;
            }
            throw new IOException("The value " + string + " not found in the array " + stringArray);
        }
    }
}

