/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.table;

import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.tasklist.core.table.SortableTable;

public class ColumnsConfig
implements Serializable {
    public static final long serialVersionUID = 2L;
    public int[] columns;
    public int[] columnWidths;
    public int sortedColumn = -1;
    public boolean ascending;

    public static ColumnsConfig getColumnsConfig(JTable jTable) {
        ColumnsConfig columnsConfig = new ColumnsConfig();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        assert (tableColumnModel != null) : "ctm == null";
        columnsConfig.columns = new int[tableColumnModel.getColumnCount()];
        columnsConfig.columnWidths = new int[tableColumnModel.getColumnCount()];
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            columnsConfig.columns[i] = tableColumn.getModelIndex();
            columnsConfig.columnWidths[i] = tableColumn.getWidth();
        }
        if (jTable instanceof SortableTable) {
            columnsConfig.sortedColumn = ((SortableTable)((Object)jTable)).getSortingModel().getSortedColumn();
            columnsConfig.ascending = !((SortableTable)((Object)jTable)).getSortingModel().isSortOrderDescending();
        }
        return columnsConfig;
    }

    public static void setColumnsConfig(JTable jTable, ColumnsConfig columnsConfig) {
        int n;
        assert (columnsConfig != null) : "config == null";
        jTable.createDefaultColumnsFromModel();
        ColumnsConfig columnsConfig2 = columnsConfig;
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        assert (tableColumnModel != null) : "tcm == null";
        block0: for (n = 0; n < columnsConfig2.columns.length; ++n) {
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                if (columnsConfig2.columns[n] != tableColumn.getModelIndex()) continue;
                arrayList.add(tableColumn);
                tableColumnModel.removeColumn(tableColumn);
                tableColumn.setPreferredWidth(columnsConfig2.columnWidths[n]);
                tableColumn.setWidth(columnsConfig2.columnWidths[n]);
                continue block0;
            }
        }
        while (tableColumnModel.getColumnCount() > 0) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            tableColumnModel.addColumn((TableColumn)arrayList.get(n));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ColumnsConfig[");
        stringBuffer.append("sortedColumn=").append(this.sortedColumn);
        stringBuffer.append(", ascending=").append(this.sortedColumn);
        stringBuffer.append(", columns=[");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columns[i]);
            stringBuffer.append("->");
            stringBuffer.append(this.columnWidths[i]);
        }
        stringBuffer.append("]");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

