/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.table;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class SortingModel {
    public static Comparator DEFAULT_COMPARATOR = new DefaultComparator();
    private EventListenerList listenerList = new EventListenerList();
    private List<Comparator> comparators = new ArrayList<Comparator>();
    private int sortedColumn = -1;
    private boolean descending = true;

    protected void fireChange() {
        Object[] objectArray = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public Comparator getColumnComparator(int n) {
        if (n >= this.comparators.size()) {
            return null;
        }
        return this.comparators.get(n);
    }

    public void setColumnComparator(int n, Comparator comparator) {
        while (n >= this.comparators.size()) {
            this.comparators.add(null);
        }
        this.comparators.set(n, comparator);
    }

    public boolean isSortOrderDescending() {
        return this.descending;
    }

    public void setSortOrderDescending(boolean bl) {
        this.descending = bl;
        this.fireChange();
    }

    public void setSortedColumn(int n) {
        this.sortedColumn = n;
        this.fireChange();
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultComparator
    implements Comparator<Comparable<Object>> {
        @Override
        public int compare(Comparable<Object> comparable, Comparable<Object> comparable2) {
            if (comparable == null && comparable2 == null) {
                return 0;
            }
            if (comparable == null) {
                return -1;
            }
            if (comparable2 == null) {
                return 1;
            }
            return comparable.compareTo(comparable2);
        }
    }
}

