/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.translators;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.tasklist.core.ColumnProperty;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.netbeans.modules.tasklist.core.export.ExportImportFormat;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.util.IconManager;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class HTMLSupport
implements ExportImportFormat {
    private ColumnProperty[] columns;
    private String[] headers;
    private Filter filter;
    private TaskListView view;
    private Writer writer;
    private boolean sortAscending = true;
    private boolean sortedByName = false;
    private boolean noSorting = true;
    private Node.Property sortedByProperty = null;
    private IconManager iconMap = null;

    public String getName() {
        return NbBundle.getMessage(HTMLSupport.class, (String)"HTML");
    }

    public WizardDescriptor getWizard() {
        return null;
    }

    public boolean doExportImport(File file, boolean bl, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "utf8");
        this.view = TaskListView.getCurrent();
        if (this.view == null) {
            return false;
        }
        this.filter = this.view.getFilter();
        this.writer = outputStreamWriter;
        if (bl && file != null) {
            IconManager iconManager = new IconManager(file);
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(HTMLSupport.class, (String)"ExportIcons"), 0);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (NotifyDescriptor.YES_OPTION == object) {
                this.iconMap = iconManager;
            }
        }
        this.exportHTML();
        ((Writer)outputStreamWriter).flush();
        this.iconMap = null;
        return true;
    }

    protected void writeCSS(Writer writer) throws IOException {
        writer.write("    body { background-color:white; color:black }\n    td { text-align:left; vertical-align:text-top; background-color:#eeeeee }\n    th { text-align:center; background-color:#222288; color:white }\n    td.sum { text-align:left }\n    td.sumdone { text-align:left; background-color:#cccccc }\n    td.done { background-color:#cccccc }\n    td.subhead { text-align:center; background-color:#ccccff }\n    td.datehead { text-align:center; background-color:#ccccff }\n    td.space { background-color:white }\n    td.date { text-align:left }\n    td.dateholiday { text-align:left; color:red }\n");
    }

    private void exportHTML() throws IOException {
        Serializable serializable;
        int n;
        TableColumnModel tableColumnModel = this.view.getColumnModel();
        this.writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" \"http://www.w3.org/TR/REC-html40/loose.dtd\">\n<HTML><HEAD>\n  <META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n  <TITLE>" + NbBundle.getMessage(HTMLSupport.class, (String)"TaskListHeader") + "</TITLE>\n" + "  <style type=\"text/css\">\n");
        this.writeCSS(this.writer);
        this.writer.write("  </style>\n</HEAD><BODY>\n<H1>" + NbBundle.getMessage(HTMLSupport.class, (String)"TaskListHeader") + "</H1>\n" + "<TABLE WIDTH=\"100%\" BORDER=0 CELLPADDING=3 CELLSPACING=3>\n");
        int n2 = tableColumnModel.getColumnCount();
        this.writer.write("<TR>\n");
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            serializable = tableColumnModel.getColumn(n);
            n3 += ((TableColumn)serializable).getWidth();
        }
        this.headers = new String[n2];
        for (n = 0; n < n2; ++n) {
            serializable = tableColumnModel.getColumn(n);
            int n4 = ((TableColumn)serializable).getWidth() * 100 / n3;
            if (n == 0) {
                this.writer.write("   <TH WIDTH=\"" + n4 + "%\">");
            } else {
                this.writer.write("   <TH WIDTH=\"" + n4 + "%\">");
            }
            this.headers[n] = ((TableColumn)serializable).getHeaderValue().toString();
            this.writer.write(TLUtils.toHTML(this.headers[n]));
            this.writer.write("</TH>\n");
        }
        this.writer.write("</TR>\n");
        this.sortedByProperty = null;
        this.sortAscending = true;
        this.sortedByName = false;
        this.noSorting = true;
        this.columns = this.view.getColumns();
        for (n = 0; n < this.columns.length; ++n) {
            serializable = (Boolean)this.columns[n].getValue("SortingColumnTTV");
            if (serializable == null || !((Boolean)serializable).booleanValue()) continue;
            if (n == 0) {
                this.sortedByName = true;
            } else {
                this.sortedByProperty = this.columns[n];
            }
            Boolean bl = (Boolean)this.columns[n].getValue("DescendingOrderTTV");
            this.sortAscending = bl == null || bl == false;
        }
        Node node = this.view.getExplorerManager().getRootContext();
        this.exportOneNode(node, -1);
        this.writer.write("</TR>\n</TABLE>\n<P>" + NbBundle.getMessage(HTMLSupport.class, (String)"PageCreatedBy", (Object)"<A HREF=\"http://www.netbeans.org\">NetBeans</A> <A HREF=\"http://tasklist.netbeans.org\">tasklist</A></P>") + DateFormat.getDateTimeInstance(1, 1).format(new Date()) + "<P>\n</BODY></HTML>\n");
    }

    private void exportOneNode(Node node, int n) throws IOException {
        Task task = TaskNode.getTask(node);
        if (task != null && this.filter != null && n != -1 && !this.filter.accept(task)) {
            return;
        }
        this.writer.write("<TR>\n");
        if (n >= 0) {
            this.writeOneTask(node, n);
        }
        List list = this.view.getSortedChildren(node, this.sortedByProperty, this.sortAscending, this.sortedByName, this.noSorting);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            this.exportOneNode(node2, n + 1);
        }
    }

    private void writeOneTask(Node node, int n) throws IOException {
        Boolean bl = null;
        block0: for (int i = 0; i < this.headers.length; ++i) {
            int n2;
            for (n2 = 0; n2 < this.columns.length; ++n2) {
                if (!this.headers[i].equalsIgnoreCase(this.columns[n2].getDisplayName())) continue;
                bl = (Boolean)this.columns[n2].getValue("InvisibleInTreeTableView");
                break;
            }
            if (n2 >= this.columns.length || bl != null && bl.booleanValue()) {
                n2 = 0;
            }
            Node.PropertySet[] propertySetArray = node.getPropertySets();
            for (int j = 0; j < propertySetArray.length; ++j) {
                int n3;
                Node.Property[] propertyArray = propertySetArray[j].getProperties();
                for (n3 = 0; n3 < propertyArray.length; ++n3) {
                    String string = propertyArray[n3].getName();
                    if (this.columns[n2].getName().equals(string)) break;
                }
                if (n3 == propertyArray.length) continue block0;
                this.writeOneField(this.writer, j == 0, node, propertyArray[n3], n);
            }
        }
        this.writer.write("</TR>\n");
    }

    protected void writeOneField(Writer writer, boolean bl, Node node, Node.Property property, int n) throws IOException {
        boolean bl2;
        boolean bl3 = bl2 = n > 0;
        if (property.getName().equals("taskDesc")) {
            writer.write("<TD>\n");
            if (bl2) {
                writer.write("<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" WIDTH=\"100%\">\n");
                writer.write("<TR>\n");
                writer.write("<TD WIDTH=\"" + 20 * n + "\"></TD>\n");
                writer.write("<TD CLASS=\"sum\">\n");
            }
            this.exportIcon(writer, bl, node);
            try {
                writer.write(TLUtils.toHTML(property.getValue().toString()));
            }
            catch (IllegalAccessException illegalAccessException) {
                writer.write("ERROR");
                ErrorManager.getDefault().notify((Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                writer.write("ERROR");
                ErrorManager.getDefault().notify((Throwable)invocationTargetException);
            }
            if (bl2) {
                writer.write("</TD>\n");
                writer.write("</TR>\n");
                writer.write("</TABLE>\n");
            }
            writer.write("</TD>\n");
        } else {
            writer.write("<TD>\n");
            try {
                String string;
                Object object = property.getValue();
                String string2 = string = object == null ? "" : object.toString();
                if (string == null) {
                    string = "";
                }
                writer.write(TLUtils.toHTML(string));
            }
            catch (IllegalAccessException illegalAccessException) {
                writer.write("ERROR");
                ErrorManager.getDefault().notify((Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                writer.write("ERROR");
                ErrorManager.getDefault().notify((Throwable)invocationTargetException);
            }
            writer.write("</TD>\n");
        }
    }

    protected boolean exportIcon(Writer writer, boolean bl, Node node) throws IOException {
        Image image;
        String string;
        if (bl && this.iconMap != null && (string = this.iconMap.getIcon(image = node.getIcon(1))) != null) {
            writer.write("<IMG SRC=\"" + string + "\">&nbsp;\n");
            return true;
        }
        return false;
    }
}

