/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import org.netbeans.modules.project.libraries.WritableLibraryProvider;
import org.netbeans.modules.project.libraries.ui.LibrariesCustomizer;
import org.netbeans.modules.project.libraries.ui.ProxyLibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

class LibrariesModel
extends AbstractListModel
implements PropertyChangeListener,
LookupListener {
    private List<LibraryImplementation> actualLibraries;
    private List<LibraryImplementation> addedLibraries = new ArrayList<LibraryImplementation>();
    private List<LibraryImplementation> removedLibraries = new ArrayList<LibraryImplementation>();
    private List<ProxyLibraryImplementation> changedLibraries = new ArrayList<ProxyLibraryImplementation>();
    private Collection<? extends LibraryProvider> currentStorages = Collections.emptySet();
    private Map<LibraryImplementation, LibraryProvider> storageByLib = new HashMap<LibraryImplementation, LibraryProvider>();
    private Lookup.Result<LibraryProvider> lresult;
    private WritableLibraryProvider writableProvider;

    public LibrariesModel() {
        this.getLibraries();
    }

    public Object getElementAt(int n) {
        if (n < 0 || n >= this.actualLibraries.size()) {
            return null;
        }
        return this.actualLibraries.get(n);
    }

    public int getSize() {
        return this.actualLibraries.size();
    }

    public void addLibrary(LibraryImplementation libraryImplementation) {
        LibraryImplementation libraryImplementation2;
        int n;
        this.addedLibraries.add(libraryImplementation);
        LibrariesComparator librariesComparator = new LibrariesComparator();
        for (n = 0; n < this.actualLibraries.size() && librariesComparator.compare(libraryImplementation, libraryImplementation2 = this.actualLibraries.get(n)) >= 0; ++n) {
        }
        this.actualLibraries.add(n, libraryImplementation);
        this.fireIntervalAdded(this, n, n);
    }

    public void removeLibrary(LibraryImplementation libraryImplementation) {
        if (this.addedLibraries.contains(libraryImplementation)) {
            this.addedLibraries.remove(libraryImplementation);
        } else {
            this.removedLibraries.add(((ProxyLibraryImplementation)libraryImplementation).getOriginal());
        }
        int n = this.actualLibraries.indexOf(libraryImplementation);
        this.actualLibraries.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public void modifyLibrary(ProxyLibraryImplementation proxyLibraryImplementation) {
        if (!this.addedLibraries.contains(proxyLibraryImplementation) && !this.changedLibraries.contains(proxyLibraryImplementation)) {
            this.changedLibraries.add(proxyLibraryImplementation);
        }
        int n = this.actualLibraries.indexOf(proxyLibraryImplementation);
        this.fireContentsChanged(this, n, n);
    }

    public boolean isLibraryEditable(LibraryImplementation libraryImplementation) {
        if (this.addedLibraries.contains(libraryImplementation)) {
            return true;
        }
        LibraryProvider libraryProvider = this.storageByLib.get(((ProxyLibraryImplementation)libraryImplementation).getOriginal());
        return libraryProvider == this.writableProvider;
    }

    public void apply() throws IOException {
        LibraryProvider libraryProvider;
        for (LibraryImplementation libraryImplementation : this.removedLibraries) {
            libraryProvider = this.storageByLib.get(libraryImplementation);
            if (libraryProvider == this.writableProvider) {
                this.writableProvider.removeLibrary(libraryImplementation);
                continue;
            }
            ErrorManager.getDefault().log("Can not find storage for library: " + libraryImplementation.getName());
        }
        if (this.writableProvider != null) {
            for (LibraryImplementation libraryImplementation : this.addedLibraries) {
                this.writableProvider.addLibrary(libraryImplementation);
            }
        } else {
            ErrorManager.getDefault().log("Cannot add libraries, no WritableLibraryProvider.");
        }
        for (ProxyLibraryImplementation proxyLibraryImplementation : this.changedLibraries) {
            libraryProvider = this.storageByLib.get(proxyLibraryImplementation.getOriginal());
            if (libraryProvider == this.writableProvider) {
                this.writableProvider.updateLibrary(proxyLibraryImplementation.getOriginal(), proxyLibraryImplementation);
                continue;
            }
            ErrorManager.getDefault().log("Can not find storage for library: " + proxyLibraryImplementation.getOriginal().getName());
        }
        this.cleanUp();
    }

    public void cancel() {
        this.cleanUp();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.storagesChanged();
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.storagesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storagesChanged() {
        int n;
        LibrariesModel librariesModel = this;
        synchronized (librariesModel) {
            n = this.actualLibraries == null ? 0 : this.actualLibraries.size();
            this.getLibraries();
        }
        this.fireContentsChanged(this, 0, Math.max(n, this.actualLibraries.size()));
    }

    private LibraryImplementation findModified(LibraryImplementation libraryImplementation) {
        for (ProxyLibraryImplementation proxyLibraryImplementation : this.changedLibraries) {
            if (!proxyLibraryImplementation.getOriginal().equals(libraryImplementation)) continue;
            return proxyLibraryImplementation;
        }
        return null;
    }

    private synchronized void cleanUp() {
        this.addedLibraries.clear();
        this.removedLibraries.clear();
        this.changedLibraries.clear();
        for (LibraryProvider libraryProvider : this.currentStorages) {
            libraryProvider.removePropertyChangeListener(this);
        }
        this.currentStorages = Collections.emptySet();
    }

    private synchronized void getLibraries() {
        ArrayList<LibraryImplementation> arrayList = new ArrayList<LibraryImplementation>();
        if (this.lresult == null) {
            this.lresult = Lookup.getDefault().lookupResult(LibraryProvider.class);
            this.lresult.addLookupListener((LookupListener)this);
        }
        Collection collection = this.lresult.allInstances();
        HashSet hashSet = new HashSet(collection);
        hashSet.removeAll(this.currentStorages);
        HashSet<? extends LibraryProvider> hashSet2 = new HashSet<LibraryProvider>(this.currentStorages);
        hashSet2.removeAll(collection);
        this.currentStorages = collection;
        this.storageByLib.clear();
        for (LibraryProvider libraryProvider : collection) {
            if (this.writableProvider == null && libraryProvider instanceof WritableLibraryProvider) {
                this.writableProvider = (WritableLibraryProvider)libraryProvider;
            }
            for (LibraryImplementation libraryImplementation : libraryProvider.getLibraries()) {
                LibraryImplementation libraryImplementation2 = null;
                if (this.removedLibraries.contains(libraryImplementation)) {
                    this.storageByLib.put(libraryImplementation, libraryProvider);
                    continue;
                }
                libraryImplementation2 = this.findModified(libraryImplementation);
                if (libraryImplementation2 != null) {
                    arrayList.add(libraryImplementation2);
                    this.storageByLib.put(libraryImplementation, libraryProvider);
                    continue;
                }
                arrayList.add(new ProxyLibraryImplementation(libraryImplementation, this));
                this.storageByLib.put(libraryImplementation, libraryProvider);
            }
        }
        arrayList.addAll(this.addedLibraries);
        Collections.sort(arrayList, new LibrariesComparator());
        for (LibraryProvider libraryProvider : hashSet2) {
            libraryProvider.removePropertyChangeListener(this);
        }
        for (LibraryProvider libraryProvider : hashSet) {
            libraryProvider.addPropertyChangeListener(this);
        }
        this.actualLibraries = arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibrariesComparator
    implements Comparator<LibraryImplementation> {
        private LibrariesComparator() {
        }

        @Override
        public int compare(LibraryImplementation libraryImplementation, LibraryImplementation libraryImplementation2) {
            String string = LibrariesCustomizer.getLocalizedString(libraryImplementation.getLocalizingBundle(), libraryImplementation.getName());
            String string2 = LibrariesCustomizer.getLocalizedString(libraryImplementation2.getLocalizingBundle(), libraryImplementation2.getName());
            return string.compareToIgnoreCase(string2);
        }
    }
}

