/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.timers;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceWatcher {
    private List<Reference<Object>> references = new ArrayList<Reference<Object>>();
    private ReferenceQueue<Object> queue = new ReferenceQueue();
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private transient List<WeakReference<ChangeListener>> changeListenerList;

    public InstanceWatcher() {
        new FinalizingToken();
    }

    public synchronized void add(Object object) {
        if (!this.contains(object)) {
            this.references.add(new WeakReference<Object>(object, this.queue));
        }
    }

    private synchronized boolean contains(Object object) {
        for (Reference<Object> reference : this.references) {
            if (reference.get() != object) continue;
            return true;
        }
        return false;
    }

    public synchronized int size() {
        this.removeNulls();
        return this.references.size();
    }

    public Collection<?> getInstances() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.references.size());
        for (Reference<Object> reference : this.references) {
            Object object = reference.get();
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList<WeakReference<ChangeListener>>();
        }
        this.changeListenerList.add(new WeakReference<ChangeListener>(changeListener));
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        if (this.changeListenerList != null) {
            for (WeakReference<ChangeListener> weakReference : this.changeListenerList) {
                if (!changeListener.equals(weakReference.get())) continue;
                this.changeListenerList.remove(weakReference);
            }
        }
    }

    private static <T> void cleanAndCopy(List<? extends Reference<T>> list, List<? super T> list2) {
        for (int i = list.size() - 1; i >= 0; --i) {
            T t = list.get(i).get();
            if (t == null) {
                list.remove(i);
                continue;
            }
            if (list2 == null) continue;
            list2.add(0, t);
        }
    }

    private synchronized void removeNulls() {
        InstanceWatcher.cleanAndCopy(this.references, null);
    }

    private boolean cleanQueue() {
        boolean bl = false;
        while (this.queue.poll() != null) {
            bl = true;
        }
        return bl;
    }

    private void refresh() {
        if (this.cleanQueue()) {
            this.removeNulls();
            this.fireChangeListenerStateChanged();
        }
        new FinalizingToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListenerStateChanged() {
        LinkedList linkedList = new LinkedList();
        Object object = this;
        synchronized (object) {
            if (this.changeListenerList == null) {
                return;
            }
            InstanceWatcher.cleanAndCopy(this.changeListenerList, linkedList);
        }
        object = new ChangeEvent(this);
        for (ChangeListener changeListener : linkedList) {
            changeListener.stateChanged((ChangeEvent)object);
        }
    }

    private class FinalizingToken
    implements Runnable {
        private FinalizingToken() {
        }

        public void finalize() {
            executor.submit(this);
        }

        public void run() {
            InstanceWatcher.this.refresh();
        }
    }
}

