/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.timers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.timers.InstanceWatcher;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimesCollectorPeer {
    private List<Reference<FileObject>> files = new ArrayList<Reference<FileObject>>();
    private Map<FileObject, Map<String, Description>> fo2Key2Desc = new WeakHashMap<FileObject, Map<String, Description>>();
    private static final TimesCollectorPeer INSTANCE = new TimesCollectorPeer();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static TimesCollectorPeer getDefault() {
        return INSTANCE;
    }

    private TimesCollectorPeer() {
    }

    public void reportTime(FileObject fileObject, String string, String string2, long l) {
        Map<String, Description> map = this.getKey2Desc(fileObject);
        Description description = new Description(string2, l);
        map.put(string, description);
        this.pcs.firePropertyChange("PROP", fileObject, string);
    }

    public void reportReference(FileObject fileObject, String string, String string2, Object object) {
        Map<String, Description> map = this.getKey2Desc(fileObject);
        Description description = map.get(string);
        assert (description == null || description instanceof ObjectCountDescripton) : "Illegal state";
        ObjectCountDescripton objectCountDescripton = description == null ? new ObjectCountDescripton(this, fileObject, string, string2) : (ObjectCountDescripton)description;
        objectCountDescripton.add(object);
        map.put(string, objectCountDescripton);
        this.pcs.firePropertyChange("PROP", fileObject, string);
    }

    private synchronized Map<String, Description> getKey2Desc(final FileObject fileObject) {
        Map<String, Description> map = this.fo2Key2Desc.get(fileObject);
        if (map == null) {
            this.files.add(new CleanableWeakReference<FileObject>(fileObject));
            map = new LinkedHashMap<String, Description>();
            this.fo2Key2Desc.put(fileObject, map);
            this.pcs.firePropertyChange("fos", null, fileObject);
            if (fileObject != null) {
                fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDeleted(FileEvent fileEvent) {
                        for (Reference reference : TimesCollectorPeer.this.files) {
                            if (reference.get() != fileObject) continue;
                            TimesCollectorPeer.this.files.remove(reference);
                            break;
                        }
                        TimesCollectorPeer.this.fo2Key2Desc.remove(fileObject);
                        TimesCollectorPeer.this.pcs.firePropertyChange("fos", null, null);
                    }
                });
            }
        }
        return map;
    }

    public Description getDescription(FileObject fileObject, String string) {
        return this.getKey2Desc(fileObject).get(string);
    }

    public Collection<String> getKeysForFile(FileObject fileObject) {
        return this.getKey2Desc(fileObject).keySet();
    }

    public Collection<FileObject> getFiles() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (Reference<FileObject> reference : this.files) {
            FileObject fileObject = reference.get();
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void select(FileObject fileObject) {
        this.getKey2Desc(fileObject);
        this.pcs.firePropertyChange("selected", null, fileObject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CleanableWeakReference<T>
    extends WeakReference<T>
    implements Runnable {
        public CleanableWeakReference(T t) {
            super(t, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            TimesCollectorPeer.this.files.remove(this);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    TimesCollectorPeer.this.pcs.firePropertyChange("fos", null, null);
                }
            });
        }
    }

    public static class Description {
        private String message;
        private long time;

        public Description(String string, long l) {
            this.message = string;
            this.time = l;
        }

        public String getMessage() {
            return this.message;
        }

        public long getTime() {
            return this.time;
        }
    }

    public static class ObjectCountDescripton
    extends Description
    implements ChangeListener {
        private TimesCollectorPeer tcp;
        private Reference<FileObject> fo;
        private String key;
        private InstanceWatcher iw = new InstanceWatcher();

        public ObjectCountDescripton(TimesCollectorPeer timesCollectorPeer, FileObject fileObject, String string, String string2) {
            super(string2, 0L);
            this.tcp = timesCollectorPeer;
            this.fo = new WeakReference<FileObject>(fileObject);
            this.key = string;
            this.iw.addChangeListener(this);
        }

        public long getTime() {
            return this.iw.size();
        }

        public Collection getInstances() {
            return this.iw.getInstances();
        }

        private void add(Object object) {
            this.iw.add(object);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            FileObject fileObject = this.fo.get();
            if (fileObject != null) {
                this.tcp.pcs.firePropertyChange("PROP", fileObject, this.key);
            }
        }
    }
}

