/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtilities {
    private static boolean[] EMPTY_BOOLEAN_ARRAY;
    private static char[] EMPTY_CHAR_ARRAY;
    private static int[] EMPTY_INT_ARRAY;

    private ArrayUtilities() {
    }

    public static boolean[] booleanArray(boolean[] blArray) {
        return ArrayUtilities.booleanArray(blArray, blArray != null ? blArray.length << 1 : 1);
    }

    public static boolean[] booleanArray(boolean[] blArray, int n) {
        return ArrayUtilities.booleanArray(blArray, n, blArray != null ? Math.min(n, blArray.length) : 0, true);
    }

    public static boolean[] booleanArray(boolean[] blArray, int n, int n2, boolean bl) {
        boolean[] blArray2 = new boolean[n];
        if (n2 > 0) {
            if (bl) {
                System.arraycopy(blArray, 0, blArray2, 0, n2);
            } else {
                System.arraycopy(blArray, blArray.length - n2, blArray2, n - n2, n2);
            }
        }
        return blArray2;
    }

    public static char[] charArray(char[] cArray) {
        return ArrayUtilities.charArray(cArray, cArray != null ? cArray.length << 1 : 1);
    }

    public static char[] charArray(char[] cArray, int n) {
        return ArrayUtilities.charArray(cArray, n, cArray != null ? Math.min(n, cArray.length) : 0, true);
    }

    public static char[] charArray(char[] cArray, int n, int n2, boolean bl) {
        char[] cArray2 = new char[n];
        if (n2 > 0) {
            if (bl) {
                System.arraycopy(cArray, 0, cArray2, 0, n2);
            } else {
                System.arraycopy(cArray, cArray.length - n2, cArray2, n - n2, n2);
            }
        }
        return cArray2;
    }

    public static char[] charArray(char[] cArray, int n, int n2, int n3) {
        char[] cArray2 = new char[n];
        if (n2 > 0) {
            System.arraycopy(cArray, 0, cArray2, 0, n2);
        }
        if ((n3 = cArray.length - (n2 += n3)) > 0) {
            System.arraycopy(cArray, n2, cArray2, n - n3, n3);
        }
        return cArray2;
    }

    public static int[] intArray(int[] nArray) {
        return ArrayUtilities.intArray(nArray, nArray != null ? nArray.length << 1 : 1);
    }

    public static int[] intArray(int[] nArray, int n) {
        return ArrayUtilities.intArray(nArray, n, nArray != null ? Math.min(n, nArray.length) : 0, true);
    }

    public static int[] intArray(int[] nArray, int n, int n2, boolean bl) {
        int[] nArray2 = new int[n];
        if (n2 > 0) {
            if (bl) {
                System.arraycopy(nArray, 0, nArray2, 0, n2);
            } else {
                System.arraycopy(nArray, nArray.length - n2, nArray2, n - n2, n2);
            }
        }
        return nArray2;
    }

    public static int[] intArray(int[] nArray, int n, int n2, int n3) {
        int[] nArray2 = new int[n];
        if (n2 > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n2);
        }
        if ((n3 = nArray.length - (n2 += n3)) > 0) {
            System.arraycopy(nArray, n2, nArray2, n - n3, n3);
        }
        return nArray2;
    }

    public static boolean[] emptyBooleanArray() {
        if (EMPTY_BOOLEAN_ARRAY == null) {
            EMPTY_BOOLEAN_ARRAY = new boolean[0];
        }
        return EMPTY_BOOLEAN_ARRAY;
    }

    public static char[] emptyCharArray() {
        if (EMPTY_CHAR_ARRAY == null) {
            EMPTY_CHAR_ARRAY = new char[0];
        }
        return EMPTY_CHAR_ARRAY;
    }

    public static int[] emptyIntArray() {
        if (EMPTY_INT_ARRAY == null) {
            EMPTY_INT_ARRAY = new int[0];
        }
        return EMPTY_INT_ARRAY;
    }

    public static int digitCount(int n) {
        return String.valueOf(n).length();
    }

    public static void appendIndex(StringBuilder stringBuilder, int n, int n2) {
        String string = String.valueOf(n);
        ArrayUtilities.appendSpaces(stringBuilder, n2 - string.length());
        stringBuilder.append(string);
    }

    public static void appendIndex(StringBuffer stringBuffer, int n, int n2) {
        String string = String.valueOf(n);
        ArrayUtilities.appendSpaces(stringBuffer, n2 - string.length());
        stringBuffer.append(string);
    }

    public static void appendSpaces(StringBuilder stringBuilder, int n) {
        while (--n >= 0) {
            stringBuilder.append(' ');
        }
    }

    public static void appendSpaces(StringBuffer stringBuffer, int n) {
        while (--n >= 0) {
            stringBuffer.append(' ');
        }
    }

    public static void appendBracketedIndex(StringBuilder stringBuilder, int n, int n2) {
        stringBuilder.append('[');
        ArrayUtilities.appendIndex(stringBuilder, n, n2);
        stringBuilder.append("]: ");
    }

    public static void appendBracketedIndex(StringBuffer stringBuffer, int n, int n2) {
        stringBuffer.append('[');
        ArrayUtilities.appendIndex(stringBuffer, n, n2);
        stringBuffer.append("]: ");
    }

    public static <E> List<E> unmodifiableList(E[] EArray) {
        return new UnmodifiableList<E>(EArray);
    }

    public static String toString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = ArrayUtilities.digitCount(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            ArrayUtilities.appendBracketedIndex(stringBuilder, i, n);
            stringBuilder.append(objectArray[i]);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static String toString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = ArrayUtilities.digitCount(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            ArrayUtilities.appendBracketedIndex(stringBuilder, i, n);
            stringBuilder.append(nArray[i]);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnmodifiableList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private E[] array;

        UnmodifiableList(E[] EArray) {
            this.array = EArray;
        }

        @Override
        public E get(int n) {
            if (n >= 0 && n < this.array.length) {
                return this.array[n];
            }
            throw new IndexOutOfBoundsException("index = " + n + ", size = " + this.array.length);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.array.clone();
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            if (objectArray.length < this.array.length) {
                Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.array.length);
                objectArray = objectArray2;
            }
            System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
            if (objectArray.length > this.array.length) {
                objectArray[this.array.length] = null;
            }
            return objectArray;
        }
    }
}

