/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityListenerList<T extends EventListener>
implements Serializable {
    static final long serialVersionUID = 0L;
    private static final EventListener[] EMPTY_LISTENER_ARRAY = new EventListener[0];
    private static final EventListener[][] EMPTY_LISTENER_ARRAY_ARRAY = new EventListener[0][];
    private transient T[][] listenersArray = this.emptyTArrayArray();

    public synchronized void add(T t, int n) {
        if (t == null) {
            return;
        }
        if (n >= this.listenersArray.length) {
            EventListener[][] eventListenerArray = this.allocateTArrayArray(n + 1);
            System.arraycopy(this.listenersArray, 0, eventListenerArray, 0, this.listenersArray.length);
            for (int i = this.listenersArray.length; i < n; ++i) {
                eventListenerArray[i] = this.emptyTArray();
            }
            EventListener[] eventListenerArray2 = this.allocateTArray(1);
            eventListenerArray2[0] = t;
            eventListenerArray[n] = eventListenerArray2;
            this.listenersArray = eventListenerArray;
        } else {
            EventListener[][] eventListenerArray = (EventListener[][])this.listenersArray.clone();
            T[] TArray = this.listenersArray[n];
            EventListener[] eventListenerArray3 = this.allocateTArray(TArray.length + 1);
            System.arraycopy(TArray, 0, eventListenerArray3, 1, TArray.length);
            eventListenerArray3[0] = t;
            eventListenerArray[n] = eventListenerArray3;
            this.listenersArray = eventListenerArray;
        }
    }

    public synchronized void remove(T t, int n) {
        if (t == null) {
            return;
        }
        if (n < this.listenersArray.length) {
            int n2;
            T[] TArray = this.listenersArray[n];
            for (n2 = 0; n2 < TArray.length && TArray[n2] != t; ++n2) {
            }
            if (n2 < TArray.length) {
                boolean bl;
                EventListener[] eventListenerArray;
                if (TArray.length == 1) {
                    eventListenerArray = this.emptyTArray();
                    bl = n == this.listenersArray.length - 1;
                } else {
                    eventListenerArray = this.allocateTArray(TArray.length - 1);
                    System.arraycopy(TArray, 0, eventListenerArray, 0, n2);
                    System.arraycopy(TArray, n2 + 1, eventListenerArray, n2, eventListenerArray.length - n2);
                    bl = false;
                }
                if (bl) {
                    EventListener[][] eventListenerArray2 = this.allocateTArrayArray(this.listenersArray.length - 1);
                    System.arraycopy(this.listenersArray, 0, eventListenerArray2, 0, eventListenerArray2.length);
                    this.listenersArray = eventListenerArray2;
                } else {
                    EventListener[][] eventListenerArray3 = (EventListener[][])this.listenersArray.clone();
                    eventListenerArray3[n] = eventListenerArray;
                    this.listenersArray = eventListenerArray3;
                }
            }
        }
    }

    public T[][] getListenersArray() {
        return this.listenersArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(n);
        for (n = this.listenersArray.length - 1; n >= 0; --n) {
            T[] TArray = this.listenersArray[n];
            for (int i = 0; i < TArray.length; ++i) {
                T t = TArray[i];
                if (!(t instanceof Serializable)) continue;
                objectOutputStream.writeObject(t);
            }
            objectOutputStream.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        Object object = this.listenersArray = n != -1 ? this.allocateTArrayArray(n + 1) : this.emptyTArrayArray();
        for (n = objectInputStream.readInt(); n >= 0; --n) {
            EventListener[] eventListenerArray;
            Object object2;
            ArrayList<EventListener[]> arrayList = new ArrayList<EventListener[]>();
            while (null != (object2 = objectInputStream.readObject())) {
                eventListenerArray = (EventListener[])object2;
                arrayList.add(eventListenerArray);
            }
            eventListenerArray = arrayList.toArray(new EventListener[arrayList.size()]);
            this.listenersArray[n] = eventListenerArray;
        }
    }

    private T[] emptyTArray() {
        return EMPTY_LISTENER_ARRAY;
    }

    private T[][] emptyTArrayArray() {
        return EMPTY_LISTENER_ARRAY_ARRAY;
    }

    private T[] allocateTArray(int n) {
        return new EventListener[n];
    }

    private T[][] allocateTArrayArray(int n) {
        return new EventListener[n][];
    }
}

