/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util.swing;

import java.util.Comparator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionRegion {
    private static Comparator<PositionRegion> comparator;
    private Position startPosition;
    private Position endPosition;

    public static final Comparator<PositionRegion> getComparator() {
        if (comparator == null) {
            comparator = new Comparator<PositionRegion>(){

                @Override
                public int compare(PositionRegion positionRegion, PositionRegion positionRegion2) {
                    return positionRegion.getStartOffset() - positionRegion2.getStartOffset();
                }
            };
        }
        return comparator;
    }

    public static Position createFixedPosition(final int n) {
        if (n < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        return new Position(){

            public int getOffset() {
                return n;
            }
        };
    }

    public static boolean isRegionsSorted(List<PositionRegion> list) {
        for (int i = list.size() - 2; i >= 0; --i) {
            if (PositionRegion.getComparator().compare(list.get(i), list.get(i + 1)) <= 0) continue;
            return false;
        }
        return true;
    }

    public PositionRegion(Position position, Position position2) {
        PositionRegion.assertPositionsValid(position, position2);
        this.startPosition = position;
        this.endPosition = position2;
    }

    public PositionRegion(Document document, int n, int n2) throws BadLocationException {
        this(document.createPosition(n), document.createPosition(n2));
    }

    public final int getStartOffset() {
        return this.startPosition.getOffset();
    }

    public final Position getStartPosition() {
        return this.startPosition;
    }

    public final int getEndOffset() {
        return this.endPosition.getOffset();
    }

    public final Position getEndPosition() {
        return this.endPosition;
    }

    public final int getLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    void resetImpl(Position position, Position position2) {
        PositionRegion.assertPositionsValid(position, position2);
        this.startPosition = position;
        this.endPosition = position2;
    }

    void setStartPositionImpl(Position position) {
        PositionRegion.assertPositionsValid(position, this.endPosition);
        this.startPosition = position;
    }

    void setEndPositionImpl(Position position) {
        PositionRegion.assertPositionsValid(this.startPosition, position);
        this.endPosition = position;
    }

    private static void assertPositionsValid(Position position, Position position2) {
        assert (position.getOffset() <= position2.getOffset()) : "startPosition=" + position.getOffset() + " > endPosition=" + position2;
    }
}

