/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.netbeans.upgrade.AutoUpgradePanel;
import org.netbeans.upgrade.Copy;
import org.netbeans.upgrade.IncludeExclude;
import org.netbeans.upgrade.systemoptions.Importer;
import org.netbeans.util.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AutoUpgrade {
    private static final List VERSION_TO_CHECK = Arrays.asList(".netbeans/5.5", ".netbeans/5.0");

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = new String[1];
        File file = AutoUpgrade.checkPrevious(stringArray2);
        if (file != null) {
            if (!AutoUpgrade.showUpgradeDialog(file)) {
                throw new UserCancelException();
            }
            AutoUpgrade.doUpgrade(file, stringArray2[0]);
            AutoUpgrade.upgradeBuildProperties(file, stringArray2);
            Importer.doImport();
        }
    }

    private static void upgradeBuildProperties(File file, String[] stringArray) throws IOException {
        try {
            float f = Float.parseFloat(stringArray[0]);
            if ((double)f >= 5.0) {
                File file2 = new File(System.getProperty("netbeans.user", ""));
                String[] stringArray2 = new String[]{"^nbplatform[.](?!default[.]netbeans[.]dest[.]dir).+[.].+=.+$"};
                Copy.appendSelectedLines(new File(file, "build.properties"), file2, stringArray2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    private static File checkPrevious(String[] stringArray) {
        String string = System.getProperty("user.home");
        File file = null;
        if (string != null) {
            File file2 = new File(string);
            boolean bl = file2.isDirectory();
            Iterator iterator = VERSION_TO_CHECK.iterator();
            while (iterator.hasNext() && file == null) {
                String string2 = (String)iterator.next();
                file = new File(file2.getAbsolutePath(), string2);
                if (file.isDirectory()) {
                    stringArray[0] = file.getName();
                    break;
                }
                file = null;
            }
            return file;
        }
        return null;
    }

    private static boolean showUpgradeDialog(File file) {
        Util.setDefaultLookAndFeel();
        JOptionPane jOptionPane = new JOptionPane(new AutoUpgradePanel(file.getAbsolutePath()), 3, 0);
        JDialog jDialog = jOptionPane.createDialog(null, NbBundle.getMessage(AutoUpgrade.class, (String)"MSG_Confirmation_Title"));
        jDialog.setModal(true);
        jDialog.setVisible(true);
        return new Integer(0).equals(jOptionPane.getValue());
    }

    static void doUpgrade(File file, String string) throws IOException, PropertyVetoException {
        Set set;
        Object object;
        File file2 = new File(System.getProperty("netbeans.user", ""));
        try {
            object = new InputStreamReader(AutoUpgrade.class.getResourceAsStream("copy" + string), "utf-8");
            set = IncludeExclude.create((Reader)object);
            ((Reader)object).close();
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("Cannot import from version: " + string);
            iOException2.initCause(iOException);
            throw iOException2;
        }
        ErrorManager.getDefault().log(256, "Import: Old version: " + string + ". Importing from " + file + " to " + file2);
        object = new File(file, "config");
        LocalFileSystem localFileSystem = new LocalFileSystem();
        localFileSystem.setRootDirectory((File)object);
        XMLFileSystem xMLFileSystem = null;
        try {
            URL uRL = AutoUpgrade.class.getResource("layer" + string + ".xml");
            xMLFileSystem = new XMLFileSystem(uRL);
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException("Cannot import from version: " + string);
            iOException.initCause(sAXException);
            throw iOException;
        }
        MultiFileSystem multiFileSystem = AutoUpgrade.createLayeredSystem(localFileSystem, xMLFileSystem);
        localFileSystem = Repository.getDefault().getDefaultFileSystem();
        Copy.copyDeep(multiFileSystem.getRoot(), localFileSystem.getRoot(), set);
    }

    static MultiFileSystem createLayeredSystem(LocalFileSystem localFileSystem, XMLFileSystem xMLFileSystem) {
        MultiFileSystem multiFileSystem = new MultiFileSystem(new FileSystem[]{localFileSystem, xMLFileSystem}){
            {
                this.setPropagateMasks(true);
            }
        };
        return multiFileSystem;
    }

    private static List<FileObject> getFiles(FileObject fileObject, int n, String string, String string2) {
        if (n == 0) {
            FileObject fileObject2 = fileObject.getFileObject(string, string2);
            if (fileObject2 == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(fileObject2);
        }
        Enumeration enumeration = fileObject.getChildren(false);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        while (enumeration.hasMoreElements()) {
            FileObject fileObject3 = (FileObject)enumeration.nextElement();
            if (!fileObject3.isFolder()) continue;
            arrayList.addAll(AutoUpgrade.getFiles(fileObject3, n - 1, string, string2));
        }
        return arrayList;
    }

    private static void copy(FileObject fileObject, FileObject fileObject2) throws IOException {
        Enumeration enumeration = fileObject.getData(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject3;
            FileObject fileObject4 = (FileObject)enumeration.nextElement();
            if (fileObject4.isFolder()) {
                fileObject3 = fileObject2.createFolder(fileObject4.getName());
                AutoUpgrade.copy(fileObject4, fileObject3);
                continue;
            }
            try {
                fileObject3 = FileUtil.copyFile((FileObject)fileObject4, (FileObject)fileObject2, (String)fileObject4.getName(), (String)fileObject4.getExt());
                FileUtil.copyAttributes((FileObject)fileObject4, (FileObject)fileObject3);
            }
            catch (IOException iOException) {
                if (fileObject4.getNameExt().endsWith("_hidden")) continue;
                throw iOException;
            }
        }
    }
}

