/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.awt.Image;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;
import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.suggestions.SuggestionChildren;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionNode;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;

public class SuggestionImpl
extends Task
implements Node.Cookie {
    private Object seed = null;
    private SuggestionType stype = null;

    protected SuggestionImpl() {
    }

    public SuggestionImpl(FileObject fileObject, String string, SuggestionType suggestionType, SuggestionPerformer suggestionPerformer, Object object) {
        super(string, null);
        this.setFileObject(fileObject);
        this.seed = object;
        this.stype = suggestionType;
        this.setAction(suggestionPerformer);
        if (suggestionType != null) {
            this.setType(suggestionType.getName());
        }
    }

    public String getFileBaseName() {
        DataObject dataObject;
        Line line = this.getLine();
        if (line != null && (dataObject = (DataObject)line.getLookup().lookup(DataObject.class)) != null) {
            return dataObject.getPrimaryFile().getNameExt();
        }
        return "";
    }

    public int getLineNumber() {
        Line line = this.getLine();
        if (line == null) {
            return 0;
        }
        return line.getLineNumber() + 1;
    }

    public Location getLocation() {
        DataObject dataObject;
        Line line = this.getLine();
        if (line != null && (dataObject = (DataObject)line.getLookup().lookup(DataObject.class)) != null) {
            return new Location(dataObject.getPrimaryFile().getPath(), line.getLineNumber());
        }
        return null;
    }

    public String toString() {
        return "SuggestionImpl#" + System.identityHashCode((Object)this) + "[\"" + this.getSummary() + "\", " + this.getFileBaseName() + ":" + this.getLineNumber() + "]";
    }

    public Node[] createNode() {
        if (this.hasSubtasks()) {
            return new Node[]{new SuggestionNode(this, (Children)new SuggestionChildren(this))};
        }
        return new Node[]{new SuggestionNode(this)};
    }

    protected Object clone() {
        SuggestionImpl suggestionImpl = new SuggestionImpl();
        suggestionImpl.copyFrom(this);
        return suggestionImpl;
    }

    protected void copyFrom(SuggestionImpl suggestionImpl) {
        super.copyFrom((Task)suggestionImpl);
        this.seed = suggestionImpl.seed;
        this.stype = suggestionImpl.stype;
    }

    public String getCategory() {
        if (this.stype != null) {
            return this.stype.getLocalizedName();
        }
        return "";
    }

    public int getPriorityNumber() {
        return this.getPriority().intValue();
    }

    protected void setType(String string) {
        super.setType(string);
    }

    public SuggestionType getSType() {
        return this.stype;
    }

    void setSType(SuggestionType suggestionType) {
        this.stype = suggestionType;
        this.setType(suggestionType.getName());
    }

    public Image getIcon() {
        if (super.getIcon() != null) {
            return super.getIcon();
        }
        if (this.stype != null && this.stype.getIconImage() != null) {
            return this.stype.getIconImage();
        }
        return null;
    }

    public Object getSeed() {
        return this.seed;
    }

    public SuggestionPriority getPriority() {
        if (this.seed == SuggestionList.CATEGORY_NODE_SEED) {
            return null;
        }
        return super.getPriority();
    }

    public void setIcon(Image image) {
        super.setIcon(image);
    }

    public static class Location
    implements Comparable {
        public String filename;
        public int line;

        public Location(String string, int n) {
            this.filename = string;
            this.line = n;
        }

        public int compareTo(Object object) {
            Location location = (Location)object;
            int n = this.filename.compareTo(location.filename);
            if (n != 0) {
                return n;
            }
            return this.line < location.line ? -1 : (this.line == location.line ? 0 : 1);
        }

        public String toString() {
            return this.filename + ":" + (this.line + 1);
        }
    }
}

