/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SuggestionTypeProcessor
implements InstanceCookie,
XMLDataObject.Processor {
    static final String DTD_PUBLIC_ID = "-//NetBeans//DTD suggestion type 1.0//EN";
    static final String DTD_SYSTEM_ID = "http://www.netbeans.org/dtds/suggestion-type-1_0.dtd";
    static final String TAG_TYPE = "type";
    static final String ATTR_TYPE_NAME = "name";
    static final String ATTR_TYPE_LOCALIZING_BUNDLE = "localizing_bundle";
    static final String ATTR_TYPE_DESCRIPTION_KEY = "description_key";
    static final String ATTR_TYPE_LONGDESCRIPTION_KEY = "long_description_key";
    static final String ATTR_TYPE_ICON = "icon";
    static final String TAG_TYPE_ACTIONS = "actions";
    static final String TAG_TYPE_ACTION = "action";
    static final String ATTR_ACTION_CLASS = "class";
    private XMLDataObject xmlDataObject;
    private SuggestionType suggestionType;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public void attachTo(XMLDataObject xMLDataObject) {
        this.xmlDataObject = xMLDataObject;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.suggestionType != null) {
            return this.suggestionType;
        }
        this.parse();
        return this.suggestionType;
    }

    public Class instanceClass() {
        return SuggestionType.class;
    }

    public String instanceName() {
        return this.instanceClass().getName();
    }

    private synchronized SuggestionType parse() {
        if (this.suggestionType == null) {
            try {
                XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false);
                TypeHandler typeHandler = new TypeHandler();
                xMLReader.setContentHandler(typeHandler);
                xMLReader.setErrorHandler(typeHandler);
                xMLReader.setEntityResolver(typeHandler);
                xMLReader.parse(new InputSource(this.xmlDataObject.getPrimaryFile().getInputStream()));
                this.suggestionType = typeHandler.getSuggestionType();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return this.suggestionType;
    }

    private static class TypeHandler
    extends DefaultHandler {
        private SuggestionType type = null;
        String id = null;
        List actions = null;
        String localizer = null;
        String key = null;
        String longkey = null;
        URL icon = null;

        private TypeHandler() {
        }

        SuggestionType getSuggestionType() {
            return this.type;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (SuggestionTypeProcessor.TAG_TYPE.equals(string3)) {
                this.id = attributes.getValue(SuggestionTypeProcessor.ATTR_TYPE_NAME);
                this.actions = null;
                this.localizer = attributes.getValue(SuggestionTypeProcessor.ATTR_TYPE_LOCALIZING_BUNDLE);
                this.key = attributes.getValue(SuggestionTypeProcessor.ATTR_TYPE_DESCRIPTION_KEY);
                this.longkey = attributes.getValue(SuggestionTypeProcessor.ATTR_TYPE_LONGDESCRIPTION_KEY);
                this.icon = null;
                String string4 = attributes.getValue(SuggestionTypeProcessor.ATTR_TYPE_ICON);
                if (string4 != null) {
                    try {
                        this.icon = new URL(string4);
                    }
                    catch (MalformedURLException malformedURLException) {
                        SAXException sAXException = new SAXException(malformedURLException);
                        ErrorManager.getDefault().copyAnnotation((Throwable)sAXException, (Throwable)malformedURLException);
                        throw sAXException;
                    }
                }
            } else if (!SuggestionTypeProcessor.TAG_TYPE_ACTIONS.equals(string3)) {
                if (SuggestionTypeProcessor.TAG_TYPE_ACTION.equals(string3)) {
                    String string5 = attributes.getValue(SuggestionTypeProcessor.ATTR_ACTION_CLASS);
                    if (string5 == null) {
                        return;
                    }
                    try {
                        SystemAction systemAction;
                        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SuggestionTypeProcessor.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                        Class<?> clazz = Class.forName(string5, true, classLoader);
                        if (clazz != null && (systemAction = SystemAction.get(clazz)) != null) {
                            if (this.actions == null) {
                                this.actions = new ArrayList();
                            }
                            this.actions.add(systemAction);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ErrorManager.getDefault().annotate((Throwable)classNotFoundException, "TL: cannot load " + string5 + " action, ignoring...");
                        ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
                    }
                } else {
                    throw new SAXException("malformed SuggestionType xml file");
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!SuggestionTypeProcessor.TAG_TYPE_ACTION.equals(string3) && !SuggestionTypeProcessor.TAG_TYPE_ACTIONS.equals(string3) && SuggestionTypeProcessor.TAG_TYPE.equals(string3) && this.id != null) {
                this.type = new SuggestionType(this.id, this.localizer, this.key, this.longkey, this.icon, this.actions);
            }
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (SuggestionTypeProcessor.DTD_PUBLIC_ID.equals(string)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return new InputSource(string2);
        }
    }
}

