/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.inc.RemovedTokenList;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenChange<T extends TokenId> {
    private final TokenChangeInfo<T> info;

    TokenChange(TokenChangeInfo<T> tokenChangeInfo) {
        this.info = tokenChangeInfo;
    }

    public int embeddedChangeCount() {
        return this.info.embeddedChanges().length;
    }

    public TokenChange<? extends TokenId> embeddedChange(int n) {
        return this.info.embeddedChanges()[n];
    }

    public <T extends TokenId> TokenChange<T> embeddedChange(Language<T> language) {
        TokenChange<TokenId>[] tokenChangeArray = this.info.embeddedChanges();
        for (int i = tokenChangeArray.length - 1; i >= 0; --i) {
            TokenChange<TokenId> tokenChange = tokenChangeArray[i];
            if (tokenChange.language() != language) continue;
            TokenChange<TokenId> tokenChange2 = tokenChange;
            return tokenChange2;
        }
        return null;
    }

    public Language<T> language() {
        return LexerUtilsConstants.mostEmbeddedLanguage(this.languagePath());
    }

    public LanguagePath languagePath() {
        return this.info.currentTokenList().languagePath();
    }

    public int index() {
        return this.info.index();
    }

    public int offset() {
        return this.info.offset();
    }

    public int removedTokenCount() {
        RemovedTokenList<T> removedTokenList = this.info.removedTokenList();
        return removedTokenList != null ? removedTokenList.tokenCount() : 0;
    }

    public TokenSequence<T> removedTokenSequence() {
        return new TokenSequence<T>(this.info.removedTokenList());
    }

    public int addedTokenCount() {
        return this.info.addedTokenCount();
    }

    public TokenSequence<T> currentTokenSequence() {
        TokenSequence<T> tokenSequence = new TokenSequence<T>(this.info.currentTokenList());
        tokenSequence.moveIndex(this.index());
        return tokenSequence;
    }

    public boolean isBoundsChange() {
        return this.info.isBoundsChange();
    }

    TokenChangeInfo<T> info() {
        return this.info;
    }
}

