/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.LanguageManager;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.token.DefaultToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.TokenFactory;
import org.netbeans.spi.lexer.TokenValidator;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LanguageOperation<T extends TokenId>
implements PropertyChangeListener {
    private static final int MAX_START_SKIP_LENGTH_CACHED = 10;
    private static final int MAX_END_SKIP_LENGTH_CACHED = 10;
    private static final TokenValidator<TokenId> NULL_VALIDATOR = new TokenValidator<TokenId>(){

        @Override
        public Token<TokenId> validateToken(Token<TokenId> token, TokenFactory<TokenId> tokenFactory, CharSequence charSequence, int n, int n2, CharSequence charSequence2, int n3, CharSequence charSequence3) {
            return null;
        }
    };
    private LanguageHierarchy<T> languageHierarchy;
    private Language<T> language;
    private LanguageEmbedding<T>[][] cachedEmbeddings;
    private LanguageEmbedding<T>[][] cachedJoinSectionsEmbeddings;
    private TokenValidator<T>[] tokenValidators;
    private Set<LanguagePath> languagePaths;
    private Set<Language<? extends TokenId>> exploredLanguages;
    private FlyItem<T>[] flyItems;

    public static <T extends TokenId> void findLanguagePaths(Set<LanguagePath> set, Set<LanguagePath> set2, Set<Language<? extends TokenId>> set3, LanguagePath languagePath, Language<T> language) {
        if (!set.contains(languagePath)) {
            set2.add(languagePath);
        }
        if (!set3.contains(language)) {
            set3.add(language);
            Set<T> set4 = language.tokenIds();
            for (TokenId tokenId : set4) {
                DefaultToken<TokenId> defaultToken = new DefaultToken<TokenId>(tokenId);
                LanguageEmbedding<TokenId> languageEmbedding = LexerUtilsConstants.findEmbedding(defaultToken, languagePath, null);
                if (languageEmbedding == null) continue;
                LanguagePath languagePath2 = LanguagePath.get(languagePath, languageEmbedding.language());
                LanguageOperation.findLanguagePaths(set, set2, set3, languagePath2, languageEmbedding.language());
            }
        }
    }

    public LanguageOperation(LanguageHierarchy<T> languageHierarchy) {
        this.languageHierarchy = languageHierarchy;
        LanguageManager.getInstance().addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)LanguageManager.getInstance()));
    }

    public LanguageHierarchy<T> languageHierarchy() {
        return this.languageHierarchy;
    }

    public synchronized Language<T> language() {
        if (this.language == null) {
            try {
                Class.forName(Language.class.getName(), true, LanguageOperation.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.language = LexerApiPackageAccessor.get().createLanguage(this.languageHierarchy);
        }
        return this.language;
    }

    public synchronized TokenValidator<T> tokenValidator(T t) {
        TokenValidator<T> tokenValidator;
        if (this.tokenValidators == null) {
            this.tokenValidators = this.allocateTokenValidatorArray(this.language.maxOrdinal() + 1);
        }
        if ((tokenValidator = this.tokenValidators[t.ordinal()]) == null) {
            tokenValidator = LexerSpiPackageAccessor.get().createTokenValidator(this.languageHierarchy(), t);
            if (tokenValidator == null) {
                tokenValidator = this.nullValidator();
            }
            this.tokenValidators[t.ordinal()] = tokenValidator;
        }
        return tokenValidator == this.nullValidator() ? null : tokenValidator;
    }

    public synchronized TextToken<T> getFlyweightToken(T t, String string) {
        TextToken textToken;
        FlyItem[] flyItemArray;
        if (this.flyItems == null) {
            flyItemArray = new FlyItem[this.language.maxOrdinal() + 1];
            this.flyItems = flyItemArray;
        }
        if ((flyItemArray = this.flyItems[t.ordinal()]) == null) {
            textToken = new TextToken<T>(t, string);
            textToken.makeFlyweight();
            this.flyItems[t.ordinal()] = new FlyItem(textToken);
        } else {
            textToken = flyItemArray.token();
            if (textToken.text() != string) {
                textToken = flyItemArray.token2();
                if (textToken == null || textToken.text() != string) {
                    textToken = flyItemArray.token();
                    if (!CharSequenceUtilities.textEquals((CharSequence)textToken.text(), (CharSequence)string)) {
                        textToken = flyItemArray.token2();
                        if (textToken == null || !CharSequenceUtilities.textEquals((CharSequence)textToken.text(), (CharSequence)string)) {
                            textToken = new TextToken<T>(t, string);
                            textToken.makeFlyweight();
                        }
                        flyItemArray.pushToken(textToken);
                    }
                } else {
                    flyItemArray.pushToken(textToken);
                }
            }
        }
        assert (textToken != null);
        return textToken;
    }

    public synchronized LanguageEmbedding<T> getEmbedding(int n, int n2, boolean bl) {
        Object object;
        LanguageEmbedding<T>[] languageEmbeddingArray;
        LanguageEmbedding<T>[][] languageEmbeddingArray2;
        LanguageEmbedding<T>[][] languageEmbeddingArray3 = languageEmbeddingArray2 = bl ? this.cachedJoinSectionsEmbeddings : this.cachedEmbeddings;
        if (languageEmbeddingArray2 == null || n >= languageEmbeddingArray2.length) {
            if (n > 10) {
                return this.createEmbedding(n, n2, bl);
            }
            languageEmbeddingArray = new LanguageEmbedding[n + 1][];
            if (languageEmbeddingArray2 != null) {
                System.arraycopy(languageEmbeddingArray2, 0, languageEmbeddingArray, 0, languageEmbeddingArray2.length);
            }
            languageEmbeddingArray2 = languageEmbeddingArray;
            if (bl) {
                this.cachedJoinSectionsEmbeddings = languageEmbeddingArray2;
            } else {
                this.cachedEmbeddings = languageEmbeddingArray2;
            }
        }
        if ((languageEmbeddingArray = languageEmbeddingArray2[n]) == null || n2 >= languageEmbeddingArray.length) {
            if (n2 > 10) {
                return this.createEmbedding(n, n2, bl);
            }
            object = new LanguageEmbedding[n2 + 1];
            if (languageEmbeddingArray != null) {
                System.arraycopy(languageEmbeddingArray, 0, object, 0, languageEmbeddingArray.length);
            }
            languageEmbeddingArray = object;
            languageEmbeddingArray2[n] = languageEmbeddingArray;
        }
        if ((object = languageEmbeddingArray[n2]) == null) {
            languageEmbeddingArray[n2] = object = this.createEmbedding(n, n2, bl);
        }
        return object;
    }

    private LanguageEmbedding<T> createEmbedding(int n, int n2, boolean bl) {
        return LexerSpiPackageAccessor.get().createLanguageEmbedding(this.language(), n, n2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LanguagePath> languagePaths() {
        Set<LanguagePath> set;
        Object object = this;
        synchronized (object) {
            set = this.languagePaths;
        }
        if (set == null) {
            set = new HashSet<LanguagePath>();
            object = Collections.emptySet();
            HashSet<Language<? extends TokenId>> hashSet = new HashSet<Language<? extends TokenId>>();
            LanguageOperation.findLanguagePaths((Set<LanguagePath>)object, set, hashSet, LanguagePath.get(this.language()), this.language());
            LanguageOperation languageOperation = this;
            synchronized (languageOperation) {
                this.languagePaths = set;
                this.exploredLanguages = hashSet;
            }
        }
        return set;
    }

    public Set<Language<? extends TokenId>> exploredLanguages() {
        this.languagePaths();
        return this.exploredLanguages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        LanguageOperation languageOperation = this;
        synchronized (languageOperation) {
            this.languagePaths = null;
            this.exploredLanguages = null;
        }
    }

    private final TokenValidator<T> nullValidator() {
        return NULL_VALIDATOR;
    }

    private final TokenValidator<T>[] allocateTokenValidatorArray(int n) {
        return new TokenValidator[n];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlyItem<T extends TokenId> {
        private TextToken<T> token;
        private TextToken<T> token2;

        public FlyItem(TextToken<T> textToken) {
            this.token = textToken;
        }

        public TextToken<T> token() {
            return this.token;
        }

        public TextToken<T> token2() {
            return this.token2;
        }

        public void pushToken(TextToken<T> textToken) {
            this.token2 = this.token;
            this.token = textToken;
        }
    }
}

