/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.List;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.lib.lexer.CharPreprocessorError;
import org.netbeans.lib.lexer.CharPreprocessorOperation;
import org.netbeans.lib.lexer.CharProvider;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.PreprocessedTextStorage;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.ComplexToken;
import org.netbeans.lib.lexer.token.PreprocessedTextToken;
import org.netbeans.spi.lexer.CharPreprocessor;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LexerInputOperation<T extends TokenId>
implements CharProvider {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    private int readIndex;
    private int lookaheadIndex;
    private CharPreprocessorOperation preprocessorOperation;
    private int tokenLength;
    private final TokenList<T> tokenList;
    private final boolean mutableInput;
    private final Lexer<T> lexer;
    private int tokenStartIndex;
    private boolean lexerFinished;
    private int flySequenceLength;
    private List<CharPreprocessorError> preprocessErrorList;
    protected int preprocessingLevelCount;
    private CharProvider.ExtraPreprocessedChars extraPreprocessedChars;

    public LexerInputOperation(TokenList<T> tokenList, int n, Object object) {
        this.tokenList = tokenList;
        boolean bl = this.mutableInput = tokenList.modCount() != -1;
        while (--n >= 0 && LexerUtilsConstants.token(tokenList, n).isFlyweight()) {
            ++this.flySequenceLength;
        }
        LanguagePath languagePath = tokenList.languagePath();
        LanguageOperation languageOperation = LexerUtilsConstants.mostEmbeddedLanguageOperation(languagePath);
        TokenFactory tokenFactory = LexerSpiPackageAccessor.get().createTokenFactory(this);
        CharPreprocessor charPreprocessor = LexerSpiPackageAccessor.get().createCharPreprocessor(languageOperation.languageHierarchy());
        if (charPreprocessor != null) {
            ++this.preprocessingLevelCount;
            this.preprocessorOperation = new CharPreprocessorOperation(this.preprocessorOperation != null ? this.preprocessorOperation : this, charPreprocessor, this);
        }
        LexerInput lexerInput = LexerSpiPackageAccessor.get().createLexerInput(this.preprocessorOperation != null ? this.preprocessorOperation : this);
        LexerRestartInfo lexerRestartInfo = LexerSpiPackageAccessor.get().createLexerRestartInfo(lexerInput, tokenFactory, object, tokenList.languagePath(), this.inputAttributes());
        this.lexer = LexerSpiPackageAccessor.get().createLexer(languageOperation.languageHierarchy(), lexerRestartInfo);
    }

    public abstract int read(int var1);

    @Override
    public abstract char readExisting(int var1);

    public abstract void approveToken(AbstractToken<T> var1);

    public Set<T> skipTokenIds() {
        return this.tokenList.skipTokenIds();
    }

    @Override
    public final int read() {
        int n;
        if ((n = this.read(this.readIndex++)) == -1) {
            this.lookaheadIndex = this.readIndex--;
        }
        return n;
    }

    @Override
    public int deepRawLength(int n) {
        return n;
    }

    @Override
    public int deepRawLengthShift(int n) {
        return n;
    }

    @Override
    public final int readIndex() {
        return this.readIndex;
    }

    @Override
    public final void backup(int n) {
        if (this.lookaheadIndex < this.readIndex) {
            this.lookaheadIndex = this.readIndex;
        }
        this.readIndex -= n;
    }

    public final int lookahead() {
        return this.lookaheadIndex > this.readIndex ? (this.preprocessorOperation != null ? this.preprocessorOperation.deepRawLength(this.lookaheadIndex - this.readIndex) : this.lookaheadIndex - this.readIndex) : 0;
    }

    @Override
    public final int tokenLength() {
        return this.tokenLength;
    }

    @Override
    public void tokenRecognized(int n) {
        if (n > this.readIndex()) {
            throw new IndexOutOfBoundsException("tokenLength=" + n + " >" + this.readIndex());
        }
        this.tokenLength = n;
    }

    @Override
    public void tokenApproved() {
        this.tokenStartIndex += this.tokenLength;
        this.readIndex -= this.tokenLength;
        this.lookaheadIndex -= this.tokenLength;
    }

    protected final TokenList<T> tokenList() {
        return this.tokenList;
    }

    protected final int tokenStartIndex() {
        return this.tokenStartIndex;
    }

    public final void setTokenStartIndex(int n) {
        this.tokenStartIndex = n;
    }

    protected final CharPreprocessorOperation preprocessor() {
        return this.preprocessorOperation;
    }

    public final boolean isMutableInput() {
        return this.mutableInput;
    }

    public final boolean isStoreLookaheadAndState() {
        return this.isMutableInput() || testing;
    }

    public AbstractToken<T> nextToken() {
        AbstractToken abstractToken;
        assert (!this.lexerFinished);
        do {
            if ((abstractToken = (AbstractToken)this.lexer().nextToken()) == null) {
                LexerUtilsConstants.checkLexerInputFinished(this.preprocessorOperation != null ? this.preprocessorOperation : this, this);
                this.lexerFinished = true;
                return null;
            }
            this.approveToken(abstractToken);
        } while (abstractToken == TokenFactory.SKIP_TOKEN);
        return abstractToken;
    }

    public final boolean tokenRecognized(int n, boolean bl) {
        if (this.preprocessorOperation != null) {
            this.preprocessorOperation.tokenRecognized(n);
        } else {
            this.tokenRecognized(n);
        }
        if (!bl && n != this.tokenLength || this.preprocessErrorList != null && this.preprocessErrorList.get(0).index() < this.tokenLength) {
            if (this.extraPreprocessedChars == null && this.preprocessingLevelCount > 1) {
                this.extraPreprocessedChars = new CharProvider.ExtraPreprocessedChars();
            }
            return true;
        }
        return false;
    }

    public void notifyPreprocessorError(CharPreprocessorError charPreprocessorError) {
        if (this.preprocessErrorList == null) {
            this.preprocessErrorList = new GapList();
        }
        this.preprocessErrorList.add(charPreprocessorError);
    }

    public final void initPreprocessedToken(AbstractToken<T> abstractToken) {
        CharPreprocessorError charPreprocessorError = null;
        if (this.preprocessErrorList != null && this.preprocessErrorList.size() > 0) {
            for (int i = this.preprocessErrorList.size() - 1; i >= 0; --i) {
                charPreprocessorError = this.preprocessErrorList.get(i);
                if (charPreprocessorError.index() < this.tokenLength) {
                    this.preprocessErrorList.remove(i);
                    continue;
                }
                charPreprocessorError.updateIndex(-this.tokenLength);
                charPreprocessorError = null;
            }
        }
        PreprocessedTextStorage preprocessedTextStorage = this.preprocessorOperation.createPreprocessedTextStorage(abstractToken.text(), this.extraPreprocessedChars);
        if (abstractToken.getClass() == ComplexToken.class) {
            ((ComplexToken)abstractToken).initPrep(preprocessedTextStorage, charPreprocessorError);
        } else {
            ((PreprocessedTextToken)abstractToken).initPrep(preprocessedTextStorage, charPreprocessorError);
        }
    }

    @Override
    public void collectExtraPreprocessedChars(CharProvider.ExtraPreprocessedChars extraPreprocessedChars, int n, int n2, int n3) {
    }

    public final LanguageOperation<T> languageOperation() {
        return LexerUtilsConstants.mostEmbeddedLanguageOperation(this.tokenList.languagePath());
    }

    public final Object lexerState() {
        return this.lexer.state();
    }

    public final boolean isFlyTokenAllowed() {
        return this.flySequenceLength < 5;
    }

    protected final void flyTokenAdded() {
        ++this.flySequenceLength;
    }

    protected final void preventFlyToken() {
        this.flySequenceLength = 5;
    }

    protected final void clearFlySequence() {
        this.flySequenceLength = 0;
    }

    protected final boolean isSkipToken(AbstractToken<T> abstractToken) {
        return abstractToken == TokenFactory.SKIP_TOKEN;
    }

    public final Lexer lexer() {
        return this.lexer;
    }

    public final InputAttributes inputAttributes() {
        return this.tokenList.inputAttributes();
    }

    public final void release() {
        this.lexer.release();
    }
}

