/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubSequenceTokenList<T extends TokenId>
implements TokenList<T> {
    private TokenList<T> tokenList;
    private AbstractToken<T> lastToken;
    private int lastTokenIndex;
    private int lastTokenOffset;
    private final int limitStartOffset;
    private final int limitEndOffset;
    private int limitStartIndex;
    private int limitEndIndex;

    public SubSequenceTokenList(TokenList<T> tokenList, int n, int n2) {
        this.tokenList = tokenList;
        this.limitStartOffset = n;
        this.limitEndOffset = n2;
        if (n > 0) {
            int n3 = this.move(n);
            if (n3 != Integer.MAX_VALUE) {
                if (n3 >= this.lastToken.length()) {
                    ++this.lastTokenIndex;
                    Object object = tokenList.tokenOrEmbeddingContainer(this.lastTokenIndex);
                    if (object != null && (this.lastTokenOffset = tokenList.tokenOffset(this.lastTokenIndex)) < n2) {
                        this.lastToken = LexerUtilsConstants.token(object);
                        this.limitStartIndex = this.lastTokenIndex;
                        this.limitEndIndex = Integer.MAX_VALUE;
                    }
                } else if (n2 == Integer.MAX_VALUE || this.lastTokenOffset < n2) {
                    this.limitStartIndex = this.lastTokenIndex;
                    this.limitEndIndex = Integer.MAX_VALUE;
                }
            }
        } else {
            Object object = tokenList.tokenOrEmbeddingContainer(0);
            if (object != null && (this.lastTokenOffset = tokenList.tokenOffset(0)) < n2) {
                this.lastToken = LexerUtilsConstants.token(object);
                this.limitEndIndex = Integer.MAX_VALUE;
            }
        }
    }

    public TokenList<T> delegate() {
        return this.tokenList;
    }

    public int limitStartOffset() {
        return this.limitStartOffset;
    }

    public int limitEndOffset() {
        return this.limitEndOffset;
    }

    @Override
    public Object tokenOrEmbeddingContainer(int n) {
        if (this.limitStartIndex == -1) {
            return null;
        }
        n += this.limitStartIndex;
        if (this.limitEndIndex == Integer.MAX_VALUE) {
            int n2;
            switch (n - this.lastTokenIndex) {
                case -1: {
                    if (n < this.limitStartIndex) {
                        return null;
                    }
                    Object object = this.tokenList.tokenOrEmbeddingContainer(n);
                    AbstractToken abstractToken = LexerUtilsConstants.token(object);
                    this.lastTokenIndex = n;
                    this.lastTokenOffset = this.tokenList.isContinuous() || this.lastToken.isFlyweight() ? (this.lastTokenOffset -= abstractToken.length()) : this.tokenList.tokenOffset(n);
                    this.lastToken = abstractToken;
                    return object;
                }
                case 0: {
                    return this.lastToken;
                }
                case 1: {
                    Object object = this.tokenList.tokenOrEmbeddingContainer(n);
                    if (object != null) {
                        AbstractToken abstractToken = LexerUtilsConstants.token(object);
                        int n3 = this.tokenList.isContinuous() || abstractToken.isFlyweight() ? this.lastTokenOffset + this.lastToken.length() : this.tokenList.tokenOffset(n);
                        if (n3 < this.limitEndOffset) {
                            this.lastToken = abstractToken;
                            this.lastTokenIndex = n;
                            this.lastTokenOffset = n3;
                            return object;
                        }
                    }
                    this.limitEndIndex = n;
                    return null;
                }
            }
            Object object = this.tokenList.tokenOrEmbeddingContainer(n);
            if (object != null && (n2 = this.tokenList.tokenOffset(n)) < this.limitEndOffset) {
                this.lastToken = LexerUtilsConstants.token(object);
                this.lastTokenIndex = n;
                this.lastTokenOffset = n2;
                return object;
            }
            this.tokenCount();
            return null;
        }
        return n < this.limitEndIndex ? this.tokenList.tokenOrEmbeddingContainer(n) : null;
    }

    @Override
    public int tokenOffset(int n) {
        if ((n += this.limitStartIndex) == this.lastTokenIndex) {
            return this.lastTokenOffset;
        }
        return this.tokenList.tokenOffset(n);
    }

    @Override
    public int tokenCount() {
        if (this.limitEndIndex == Integer.MAX_VALUE) {
            int n = this.move(this.limitEndOffset - 1);
            assert (n != Integer.MAX_VALUE);
            this.limitEndIndex = this.lastTokenIndex + 1;
        }
        return this.limitEndIndex - this.limitStartIndex;
    }

    @Override
    public int tokenCountCurrent() {
        if (this.limitEndIndex != Integer.MAX_VALUE) {
            return this.tokenCount();
        }
        int n = this.tokenList.tokenCountCurrent();
        if (this.tokenOffset(n - 1 - this.limitStartIndex) >= this.limitEndOffset) {
            return this.tokenCount();
        }
        return n - this.limitStartIndex;
    }

    @Override
    public AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        return this.tokenList.replaceFlyToken(n + this.limitStartIndex, abstractToken, n2);
    }

    @Override
    public int modCount() {
        return this.tokenList.modCount();
    }

    @Override
    public LanguagePath languagePath() {
        return this.tokenList.languagePath();
    }

    @Override
    public int childTokenOffset(int n) {
        throw new IllegalStateException("Unexpected call.");
    }

    @Override
    public char childTokenCharAt(int n, int n2) {
        throw new IllegalStateException("Unexpected call.");
    }

    @Override
    public void wrapToken(int n, EmbeddingContainer<T> embeddingContainer) {
        this.tokenList.wrapToken(this.limitStartIndex + n, embeddingContainer);
    }

    @Override
    public TokenList<? extends TokenId> root() {
        return this.tokenList.root();
    }

    @Override
    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return this.tokenList.tokenHierarchyOperation();
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.tokenList.inputAttributes();
    }

    @Override
    public int lookahead(int n) {
        return this.tokenList.lookahead(n);
    }

    @Override
    public Object state(int n) {
        return this.tokenList.state(n);
    }

    @Override
    public boolean isContinuous() {
        return this.tokenList.isContinuous();
    }

    @Override
    public Set<T> skipTokenIds() {
        return this.tokenList.skipTokenIds();
    }

    private AbstractToken<T> token(int n) {
        return LexerUtilsConstants.token(this.tokenList, n);
    }

    private int move(int n) {
        int n2 = this.tokenList.tokenCountCurrent();
        if (n2 == 0) {
            if (this.tokenList.tokenOrEmbeddingContainer(0) == null) {
                return Integer.MAX_VALUE;
            }
            n2 = this.tokenList.tokenCountCurrent();
        }
        this.lastTokenOffset = this.tokenList.tokenOffset(n2 - 1);
        if (n > this.lastTokenOffset) {
            Object object;
            this.lastToken = this.token(n2 - 1);
            int n3 = this.lastToken.length();
            while (n >= this.lastTokenOffset + n3 && (object = this.tokenList.tokenOrEmbeddingContainer(n2)) != null) {
                this.lastToken = LexerUtilsConstants.token(object);
                this.lastTokenOffset = this.lastToken.isFlyweight() ? (this.lastTokenOffset += n3) : this.tokenList.tokenOffset(n2);
                n3 = this.lastToken.length();
                ++n2;
            }
            this.lastTokenIndex = n2 - 1;
            return n - this.lastTokenOffset;
        }
        int n4 = 0;
        int n5 = n2 - 1;
        while (n4 <= n5) {
            int n6 = (n4 + n5) / 2;
            int n7 = this.tokenList.tokenOffset(n6);
            if (n7 < n) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > n) {
                n5 = n6 - 1;
                continue;
            }
            this.lastToken = this.token(n6);
            this.lastTokenIndex = n6;
            this.lastTokenOffset = n7;
            return 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        this.lastToken = this.token(n5);
        this.lastTokenOffset = this.tokenList.tokenOffset(n5);
        this.lastTokenIndex = n5;
        return n - this.lastTokenOffset;
    }
}

