/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextLexerInputOperation<T extends TokenId>
extends LexerInputOperation<T> {
    private final CharSequence inputText;
    private final int inputTextStartOffset;
    private int readEndIndex;

    public TextLexerInputOperation(TokenList<T> tokenList, CharSequence charSequence) {
        this(tokenList, 0, null, charSequence, 0, 0, charSequence.length());
    }

    public TextLexerInputOperation(TokenList<T> tokenList, int n, Object object, CharSequence charSequence, int n2, int n3, int n4) {
        super(tokenList, n, object);
        this.inputText = charSequence;
        this.inputTextStartOffset = n2;
        assert (0 <= (n3 -= n2) && n3 <= (n4 -= n2) && n4 <= charSequence.length());
        this.setTokenStartIndex(n3);
        this.readEndIndex = n4;
    }

    @Override
    public int read(int n) {
        if ((n += this.tokenStartIndex()) < this.readEndIndex) {
            return this.inputText.charAt(n);
        }
        return -1;
    }

    @Override
    public char readExisting(int n) {
        return this.inputText.charAt(this.tokenStartIndex() + n);
    }

    @Override
    public void approveToken(AbstractToken<T> abstractToken) {
        int n = this.tokenLength();
        if (this.isSkipToken(abstractToken)) {
            this.preventFlyToken();
        } else if (abstractToken.isFlyweight()) {
            assert (this.isFlyTokenAllowed());
            this.flyTokenAdded();
        } else {
            abstractToken.setTokenList(this.tokenList());
            abstractToken.setRawOffset(this.inputTextStartOffset + this.tokenStartIndex());
            this.clearFlySequence();
        }
        this.tokenApproved();
    }

    protected final int readEndIndex() {
        return this.readEndIndex;
    }
}

