/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.batch.CopyTextTokenList;
import org.netbeans.lib.lexer.batch.TextTokenList;
import org.netbeans.lib.lexer.inc.IncTokenList;
import org.netbeans.lib.lexer.inc.SnapshotTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.inc.TokenListUpdater;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenHierarchyOperation<I, T extends TokenId> {
    private TokenHierarchy<I> tokenHierarchy;
    private MutableTextInput<I> mutableTextInput;
    private TokenList<T> tokenList;
    private boolean active = true;
    private TokenHierarchyOperation<I, T> liveTokenHierarchyOperation;
    private List<SnapshotRef> snapshotRefs;
    private EventListenerList listenerList;
    private boolean snapshotReleased;
    private Set<LanguagePath> languagePaths;
    private Set<Language<? extends TokenId>> exploredLanguages;

    public TokenHierarchyOperation(Reader reader, Language<T> language, Set<T> set, InputAttributes inputAttributes) {
        this.tokenList = new CopyTextTokenList<T>(this, reader, language, set, inputAttributes);
        this.init();
    }

    public TokenHierarchyOperation(CharSequence charSequence, boolean bl, Language<T> language, Set<T> set, InputAttributes inputAttributes) {
        this.tokenList = bl ? new CopyTextTokenList<T>(this, charSequence, language, set, inputAttributes) : new TextTokenList<T>(this, charSequence, language, set, inputAttributes);
        this.init();
    }

    public TokenHierarchyOperation(MutableTextInput<I> mutableTextInput, Language<T> language) {
        this.mutableTextInput = mutableTextInput;
        this.tokenList = new IncTokenList(this, mutableTextInput);
        this.init();
    }

    public TokenHierarchyOperation(TokenHierarchyOperation<I, T> tokenHierarchyOperation) {
        this.liveTokenHierarchyOperation = tokenHierarchyOperation;
        this.tokenList = new SnapshotTokenList(this);
        this.init();
    }

    private void init() {
        assert (this.tokenHierarchy == null);
        this.tokenHierarchy = LexerApiPackageAccessor.get().createTokenHierarchy(this);
        this.listenerList = new EventListenerList();
        if (this.isMutable()) {
            this.snapshotRefs = new ArrayList<SnapshotRef>(1);
        }
    }

    public TokenHierarchy<I> tokenHierarchy() {
        return this.tokenHierarchy;
    }

    public TokenList<T> tokenList() {
        return this.tokenList;
    }

    public TokenList<T> checkedTokenList() {
        this.checkSnapshotNotReleased();
        return this.tokenList();
    }

    public boolean isMutable() {
        return this.mutableTextInput != null;
    }

    public MutableTextInput mutableTextInput() {
        return this.mutableTextInput;
    }

    public I mutableInputSource() {
        return this.isMutable() ? (I)LexerSpiPackageAccessor.get().inputSource(this.mutableTextInput) : null;
    }

    public void setActive(boolean bl) {
        assert (this.isMutable());
        if (this.active != bl) {
            this.active = bl;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() {
        if (this.isSnapshot()) {
            return;
        }
        if (this.active) {
            IncTokenList incTokenList = (IncTokenList)this.tokenList;
            incTokenList.incrementModCount();
            TokenListChange tokenListChange = new TokenListChange(incTokenList);
            CharSequence charSequence = LexerSpiPackageAccessor.get().text(this.mutableTextInput);
            int n = incTokenList.existingTokensEndOffset();
            TokenHierarchyEventInfo tokenHierarchyEventInfo = new TokenHierarchyEventInfo(this, TokenHierarchyEventType.REBUILD, 0, 0, charSequence, 0);
            tokenListChange.setIndex(0);
            tokenListChange.setOffset(0);
            tokenListChange.setAddedEndOffset(0);
            incTokenList.replaceTokens(tokenHierarchyEventInfo, tokenListChange, incTokenList.tokenCountCurrent());
            incTokenList.restartLexing();
            incTokenList.incrementModCount();
            List<SnapshotRef> list = this.snapshotRefs;
            synchronized (list) {
                for (int i = this.snapshotRefs.size() - 1; i >= 0; --i) {
                    TokenHierarchyOperation tokenHierarchyOperation = (TokenHierarchyOperation)this.snapshotRefs.get(i).get();
                    if (tokenHierarchyOperation == null) continue;
                    ((SnapshotTokenList)tokenHierarchyOperation.tokenList()).update(tokenHierarchyEventInfo, tokenListChange);
                }
            }
            tokenHierarchyEventInfo.setTokenChangeInfo(tokenListChange.tokenChangeInfo());
            tokenHierarchyEventInfo.setAffectedStartOffset(0);
            tokenHierarchyEventInfo.setAffectedEndOffset(charSequence.length());
            this.fireTokenHierarchyChanged(LexerApiPackageAccessor.get().createTokenChangeEvent(tokenHierarchyEventInfo));
        }
    }

    public void fireTokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length;
        for (int i = 1; i < n; i += 2) {
            ((TokenHierarchyListener)objectArray[i]).tokenHierarchyChanged(tokenHierarchyEvent);
        }
    }

    public void addTokenHierarchyListener(TokenHierarchyListener tokenHierarchyListener) {
        this.listenerList.add(TokenHierarchyListener.class, tokenHierarchyListener);
    }

    public void removeTokenHierarchyListener(TokenHierarchyListener tokenHierarchyListener) {
        this.listenerList.remove(TokenHierarchyListener.class, tokenHierarchyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void textModified(int n, int n2, CharSequence charSequence, int n3) {
        TokenHierarchyEventInfo tokenHierarchyEventInfo = new TokenHierarchyEventInfo(this, TokenHierarchyEventType.MODIFICATION, n, n2, charSequence, n3);
        if (this.active) {
            IncTokenList incTokenList = (IncTokenList)this.tokenList;
            incTokenList.incrementModCount();
            TokenListChange tokenListChange = new TokenListChange(incTokenList);
            TokenListUpdater.update(incTokenList, tokenHierarchyEventInfo, tokenListChange);
            if (!incTokenList.isFullyLexed()) {
                incTokenList.refreshLexerInputOperation();
            }
            List<SnapshotRef> list = this.snapshotRefs;
            synchronized (list) {
                for (int i = this.snapshotRefs.size() - 1; i >= 0; --i) {
                    TokenHierarchyOperation tokenHierarchyOperation = (TokenHierarchyOperation)this.snapshotRefs.get(i).get();
                    if (tokenHierarchyOperation == null) continue;
                    ((SnapshotTokenList)tokenHierarchyOperation.tokenList()).update(tokenHierarchyEventInfo, tokenListChange);
                }
            }
            tokenHierarchyEventInfo.setTokenChangeInfo(tokenListChange.tokenChangeInfo());
            if (tokenListChange.isBoundsChange()) {
                tokenHierarchyEventInfo.setAffectedStartOffset(tokenHierarchyEventInfo.modificationOffset());
                tokenHierarchyEventInfo.setAffectedEndOffset(tokenHierarchyEventInfo.modificationOffset() + Math.max(0, tokenHierarchyEventInfo.insertedLength() - tokenHierarchyEventInfo.removedLength()));
                this.addNestedChanges(tokenHierarchyEventInfo, tokenListChange);
            } else {
                tokenHierarchyEventInfo.setAffectedStartOffset(tokenListChange.offset());
                tokenHierarchyEventInfo.setAffectedEndOffset(tokenListChange.addedEndOffset());
            }
            this.fireTokenHierarchyChanged(LexerApiPackageAccessor.get().createTokenChangeEvent(tokenHierarchyEventInfo));
        }
    }

    private <TX extends TokenId> void addNestedChanges(TokenHierarchyEventInfo tokenHierarchyEventInfo, TokenListChange<TX> tokenListChange) {
        EmbeddedTokenList<TokenId> embeddedTokenList = EmbeddingContainer.getEmbeddingIfExists(tokenListChange.tokenChangeInfo().removedTokenList().tokenOrEmbeddingContainer(0));
        if (embeddedTokenList != null) {
            EmbeddingContainer embeddingContainer = new EmbeddingContainer((AbstractToken)tokenListChange.addedTokensOrBranches().get(0));
            embeddingContainer.setFirstEmbedding(embeddedTokenList);
            tokenListChange.tokenList().wrapToken(tokenListChange.index(), embeddingContainer);
            do {
                embeddedTokenList.setEmbeddingContainer(embeddingContainer);
                TokenListChange<TokenId> tokenListChange2 = new TokenListChange<TokenId>(embeddedTokenList);
                EmbeddedTokenList<TokenId> embeddedTokenList2 = embeddedTokenList;
                TokenListUpdater.update(embeddedTokenList2, tokenHierarchyEventInfo, tokenListChange2);
                tokenListChange.tokenChangeInfo().addEmbeddedChange(tokenListChange2.tokenChangeInfo());
                if (tokenListChange2.isBoundsChange()) {
                    this.addNestedChanges(tokenHierarchyEventInfo, tokenListChange2);
                    continue;
                }
                tokenHierarchyEventInfo.setMinAffectedStartOffset(tokenListChange2.offset());
                tokenHierarchyEventInfo.setMaxAffectedEndOffset(tokenListChange2.addedEndOffset());
            } while ((embeddedTokenList = embeddedTokenList.nextEmbedding()) != null);
        }
    }

    private Language<T> language() {
        Language<? extends TokenId> language;
        TokenList<T> tokenList = this.tokenList();
        if (tokenList != null) {
            language = this.tokenList.languagePath().topLanguage();
        } else {
            assert (this.mutableTextInput != null);
            language = LexerSpiPackageAccessor.get().language(this.mutableTextInput);
        }
        Language<? extends TokenId> language2 = language;
        return language2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LanguagePath> languagePaths() {
        Set<LanguagePath> set;
        Object object = this;
        synchronized (object) {
            set = this.languagePaths;
        }
        if (set == null) {
            object = LexerUtilsConstants.languageOperation(this.language());
            Set set2 = (Set)((HashSet)((LanguageOperation)object).languagePaths()).clone();
            Set set3 = (Set)((HashSet)((LanguageOperation)object).exploredLanguages()).clone();
            TokenHierarchyOperation tokenHierarchyOperation = this;
            synchronized (tokenHierarchyOperation) {
                this.languagePaths = set;
                this.exploredLanguages = set3;
            }
        }
        return set;
    }

    public void addLanguagePath(LanguagePath languagePath, Language language) {
        Set<LanguagePath> set = this.languagePaths();
        if (!set.contains(languagePath)) {
            HashSet<LanguagePath> hashSet = new HashSet<LanguagePath>();
            LanguageOperation.findLanguagePaths(set, hashSet, this.exploredLanguages, languagePath, null);
            set.addAll(hashSet);
        }
    }

    public boolean isSnapshot() {
        return this.liveTokenHierarchyOperation != null;
    }

    public TokenHierarchy<I> snapshotOf() {
        return this.isSnapshot() ? this.liveTokenHierarchyOperation.tokenHierarchy() : null;
    }

    private void checkIsSnapshot() {
        if (!this.isSnapshot()) {
            throw new IllegalStateException("Not a snapshot");
        }
    }

    private void checkSnapshotNotReleased() {
        if (this.snapshotReleased) {
            throw new IllegalStateException("Snapshot already released");
        }
    }

    public TokenHierarchy<I> createSnapshot() {
        if (this.isMutable()) {
            TokenHierarchyOperation<I, T> tokenHierarchyOperation = new TokenHierarchyOperation<I, T>(this);
            this.snapshotRefs.add(new SnapshotRef(tokenHierarchyOperation));
            return tokenHierarchyOperation.tokenHierarchy();
        }
        return null;
    }

    public void snapshotRelease() {
        this.checkIsSnapshot();
        this.checkSnapshotNotReleased();
        this.snapshotReleased = true;
        if (this.liveTokenHierarchyOperation != null) {
            this.liveTokenHierarchyOperation.removeSnapshot(this);
        }
    }

    public boolean isSnapshotReleased() {
        return this.snapshotReleased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSnapshot(SnapshotRef snapshotRef) {
        List<SnapshotRef> list = this.snapshotRefs;
        synchronized (list) {
            this.snapshotRefs.remove(snapshotRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSnapshot(TokenHierarchyOperation<I, T> tokenHierarchyOperation) {
        List<SnapshotRef> list = this.snapshotRefs;
        synchronized (list) {
            for (int i = this.snapshotRefs.size() - 1; i >= 0; --i) {
                Reference reference = this.snapshotRefs.get(i);
                if (reference.get() != tokenHierarchyOperation) continue;
                this.snapshotRefs.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int snapshotCount() {
        List<SnapshotRef> list = this.snapshotRefs;
        synchronized (list) {
            return this.snapshotRefs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canModifyToken(int n, AbstractToken abstractToken) {
        List<SnapshotRef> list = this.snapshotRefs;
        synchronized (list) {
            for (int i = this.snapshotCount() - 1; i >= 0; --i) {
                TokenHierarchyOperation tokenHierarchyOperation = (TokenHierarchyOperation)this.snapshotRefs.get(i).get();
                if (tokenHierarchyOperation == null || !((SnapshotTokenList)tokenHierarchyOperation.tokenList()).canModifyToken(n, abstractToken)) continue;
                return false;
            }
        }
        return true;
    }

    public TokenHierarchyOperation<I, T> liveTokenHierarchyOperation() {
        return this.liveTokenHierarchyOperation;
    }

    public <TT extends TokenId> int tokenOffset(AbstractToken<TT> abstractToken, TokenList<TT> tokenList, int n) {
        if (this.tokenList.getClass() == SnapshotTokenList.class) {
            if (tokenList != null) {
                SnapshotTokenList snapshotTokenList = (SnapshotTokenList)this.tokenList;
                return snapshotTokenList.tokenOffset(abstractToken, tokenList, n);
            }
            return n;
        }
        return tokenList != null ? tokenList.childTokenOffset(n) : n;
    }

    public int tokenShiftStartOffset() {
        return this.isSnapshot() ? ((SnapshotTokenList)this.tokenList).tokenShiftStartOffset() : -1;
    }

    public int tokenShiftEndOffset() {
        return this.isSnapshot() ? ((SnapshotTokenList)this.tokenList).tokenShiftEndOffset() : -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SnapshotRef
    extends WeakReference<TokenHierarchyOperation<I, T>>
    implements Runnable {
        SnapshotRef(TokenHierarchyOperation<I, T> tokenHierarchyOperation2) {
            super(tokenHierarchyOperation2, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            if (TokenHierarchyOperation.this.liveTokenHierarchyOperation != null) {
                TokenHierarchyOperation.this.liveTokenHierarchyOperation.removeSnapshot(this);
            }
        }
    }
}

