/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.lexer.LanguageManager;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.MutableTextInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentInput<D extends Document>
extends MutableTextInput<D>
implements DocumentListener {
    private static final String PROP_MIME_TYPE = "mimeType";
    private D doc;
    private LanguageHierarchy languageHierarchy;
    private CharSequence text;

    public static <D extends Document> DocumentInput<D> get(D d) {
        DocumentInput<D> documentInput = (DocumentInput<D>)d.getProperty(MutableTextInput.class);
        if (documentInput == null) {
            documentInput = new DocumentInput<D>(d);
            d.putProperty(MutableTextInput.class, documentInput);
        }
        return documentInput;
    }

    public DocumentInput(D d) {
        this.doc = d;
        this.text = DocumentUtilities.getText(d);
        DocumentUtilities.addDocumentListener(d, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.LEXER);
    }

    @Override
    public Language<? extends TokenId> language() {
        String string;
        Language<? extends TokenId> language = (Language<? extends TokenId>)this.doc.getProperty(Language.class);
        if (language == null && (string = (String)this.doc.getProperty(PROP_MIME_TYPE)) != null) {
            language = LanguageManager.getInstance().findLanguage(string);
        }
        return language;
    }

    @Override
    public CharSequence text() {
        return this.text;
    }

    @Override
    public InputAttributes inputAttributes() {
        return (InputAttributes)this.doc.getProperty(InputAttributes.class);
    }

    @Override
    public D inputSource() {
        return this.doc;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.modified(true, documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.modified(false, documentEvent);
    }

    private void modified(boolean bl, DocumentEvent documentEvent) {
        int n = documentEvent.getOffset();
        int n2 = documentEvent.getLength();
        if (bl) {
            this.tokenHierarchyControl().textModified(n, 0, null, n2);
        } else {
            this.tokenHierarchyControl().textModified(n, n2, DocumentUtilities.getModificationText((DocumentEvent)documentEvent), 0);
        }
    }
}

