/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.List;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.FlyOffsetGapList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TextLexerInputOperation;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.MutableTextInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IncTokenList<T extends TokenId>
extends FlyOffsetGapList<Object>
implements MutableTokenList<T> {
    private final TokenHierarchyOperation<?, T> tokenHierarchyOperation;
    private final MutableTextInput<?> mutableTextInput;
    private final LanguagePath languagePath;
    private final InputAttributes inputAttributes;
    private CharSequence text;
    private LexerInputOperation<T> lexerInputOperation;
    private int rootModCount;
    private LAState laState;

    public IncTokenList(TokenHierarchyOperation<?, T> tokenHierarchyOperation, MutableTextInput<?> mutableTextInput) {
        this.tokenHierarchyOperation = tokenHierarchyOperation;
        this.mutableTextInput = mutableTextInput;
        this.languagePath = LanguagePath.get(LexerSpiPackageAccessor.get().language(mutableTextInput));
        this.inputAttributes = LexerSpiPackageAccessor.get().inputAttributes(mutableTextInput);
        this.text = LexerSpiPackageAccessor.get().text(mutableTextInput);
        this.laState = LAState.empty();
        this.initLexing();
    }

    private void initLexing() {
        this.lexerInputOperation = new TextLexerInputOperation(this, this.text);
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    @Override
    public synchronized int tokenCount() {
        if (this.lexerInputOperation != null) {
            this.tokenOrEmbeddingContainerImpl(Integer.MAX_VALUE);
        }
        return this.size();
    }

    @Override
    public char childTokenCharAt(int n, int n2) {
        return this.text.charAt(this.childTokenOffset(n) + n2);
    }

    @Override
    public int childTokenOffset(int n) {
        return n < this.offsetGapStart() ? n : n - this.offsetGapLength();
    }

    @Override
    public int tokenOffset(int n) {
        return this.elementOffset(n);
    }

    public int existingTokensEndOffset() {
        return this.elementOrEndOffset(this.tokenCountCurrent());
    }

    @Override
    public int modCount() {
        return this.rootModCount;
    }

    public void incrementModCount() {
        ++this.rootModCount;
    }

    @Override
    public synchronized Object tokenOrEmbeddingContainer(int n) {
        return this.tokenOrEmbeddingContainerImpl(n);
    }

    private Object tokenOrEmbeddingContainerImpl(int n) {
        while (this.lexerInputOperation != null && n >= this.size()) {
            AbstractToken<T> abstractToken = this.lexerInputOperation.nextToken();
            if (abstractToken != null) {
                this.updateElementOffsetAdd(abstractToken);
                this.add(abstractToken);
                this.laState = this.laState.add(this.lexerInputOperation.lookahead(), this.lexerInputOperation.lexerState());
                continue;
            }
            this.lexerInputOperation.release();
            this.lexerInputOperation = null;
            this.trimToSize();
            this.laState.trimToSize();
        }
        return n < this.size() ? this.get(n) : null;
    }

    @Override
    public synchronized AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        TextToken textToken = ((TextToken)abstractToken).createCopy(this, this.offset2Raw(n2));
        this.set(n, textToken);
        return textToken;
    }

    @Override
    public synchronized void wrapToken(int n, EmbeddingContainer embeddingContainer) {
        this.set(n, embeddingContainer);
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.inputAttributes;
    }

    protected int elementRawOffset(Object object) {
        return LexerUtilsConstants.token(object).rawOffset();
    }

    protected void setElementRawOffset(Object object, int n) {
        LexerUtilsConstants.token(object).setRawOffset(n);
    }

    protected boolean isElementFlyweight(Object object) {
        return object.getClass() != EmbeddingContainer.class && ((AbstractToken)object).isFlyweight();
    }

    protected int elementLength(Object object) {
        return LexerUtilsConstants.token(object).length();
    }

    private AbstractToken<T> existingToken(int n) {
        return LexerUtilsConstants.token(this.tokenOrEmbeddingContainer(n));
    }

    @Override
    public Object tokenOrEmbeddingContainerUnsync(int n) {
        return this.get(n);
    }

    @Override
    public int lookahead(int n) {
        return this.laState.lookahead(n);
    }

    @Override
    public Object state(int n) {
        return this.laState.state(n);
    }

    @Override
    public int tokenCountCurrent() {
        return this.size();
    }

    @Override
    public TokenList<? extends TokenId> root() {
        return this;
    }

    @Override
    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return this.tokenHierarchyOperation;
    }

    @Override
    public LexerInputOperation<T> createLexerInputOperation(int n, int n2, Object object) {
        return new TextLexerInputOperation(this, n, object, this.text, 0, n2, this.text.length());
    }

    @Override
    public boolean isFullyLexed() {
        return this.lexerInputOperation == null;
    }

    @Override
    public void replaceTokens(TokenHierarchyEventInfo tokenHierarchyEventInfo, TokenListChange<T> tokenListChange, int n) {
        AbstractToken abstractToken;
        List<Object> list;
        int n2;
        int n3 = tokenListChange.index();
        Object[] objectArray = new Object[n];
        this.copyElements(n3, n3 + n, objectArray, 0);
        int n4 = tokenListChange.offset();
        for (n2 = 0; n2 < n; ++n2) {
            list = objectArray[n2];
            abstractToken = LexerUtilsConstants.token(list);
            if (!abstractToken.isFlyweight()) {
                this.updateElementOffsetRemove(abstractToken);
                abstractToken.setTokenList(null);
            }
            n4 += abstractToken.length();
        }
        this.remove(n3, n);
        this.laState.remove(n3, n);
        tokenListChange.setRemovedTokens(objectArray);
        tokenListChange.setRemovedEndOffset(n4);
        n2 = tokenHierarchyEventInfo.insertedLength() - tokenHierarchyEventInfo.removedLength();
        if (this.offsetGapStart() != tokenListChange.offset()) {
            this.moveOffsetGap(tokenListChange.offset(), Math.min(n3, tokenListChange.offsetGapIndex()));
        }
        this.updateOffsetGapLength(-n2);
        list = tokenListChange.addedTokensOrBranches();
        if (list != null) {
            abstractToken = list.iterator();
            while (abstractToken.hasNext()) {
                Object e = abstractToken.next();
                AbstractToken abstractToken2 = (AbstractToken)e;
                this.updateElementOffsetAdd(abstractToken2);
            }
            this.addAll(n3, list);
            this.laState = this.laState.addAll(n3, tokenListChange.laState());
            tokenListChange.syncAddedTokenCount();
            if (n == 1 && list.size() == 1 && (abstractToken = LexerUtilsConstants.token(objectArray[0]).id()) == tokenListChange.addedToken(0).id()) {
                tokenListChange.markBoundsChange();
            }
        }
    }

    private void releaseLexerInputOperation() {
        if (this.lexerInputOperation != null) {
            this.lexerInputOperation.release();
        }
    }

    public void refreshLexerInputOperation() {
        this.releaseLexerInputOperation();
        int n = this.tokenCountCurrent() - 1;
        this.lexerInputOperation = this.createLexerInputOperation(n + 1, this.existingTokensEndOffset(), n >= 0 ? this.state(n) : null);
    }

    public void restartLexing() {
        this.releaseLexerInputOperation();
        this.initLexing();
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    public String toString() {
        return LexerUtilsConstants.appendTokenList(null, this, -1).toString();
    }
}

