/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;

public abstract class TabDisplayerUI
extends ComponentUI {
    protected SingleSelectionModel selectionModel = null;
    protected final TabDisplayer displayer;

    protected TabDisplayerUI(TabDisplayer tabDisplayer) {
        this.displayer = tabDisplayer;
    }

    public void installUI(JComponent jComponent) {
        assert (jComponent == this.displayer);
        this.selectionModel = this.displayer.getSelectionModel();
        if (this.selectionModel == null) {
            this.selectionModel = this.createSelectionModel();
        }
        this.installSelectionModel();
    }

    public void uninstallUI(JComponent jComponent) {
        assert (jComponent == this.displayer);
    }

    public abstract Polygon getExactTabIndication(int var1);

    public abstract Polygon getInsertTabIndication(int var1);

    public abstract int tabForCoordinate(Point var1);

    public abstract Rectangle getTabRect(int var1, Rectangle var2);

    public Image createImageOfTab(int n) {
        return null;
    }

    protected abstract SingleSelectionModel createSelectionModel();

    protected final boolean shouldPerformAction(String string, int n, MouseEvent mouseEvent) {
        TabActionEvent tabActionEvent = new TabActionEvent((Object)this.displayer, string, n, mouseEvent);
        this.displayer.postActionEvent(tabActionEvent);
        return !tabActionEvent.isConsumed();
    }

    public void makeTabVisible(int n) {
    }

    private void installSelectionModel() {
        this.displayer.setSelectionModel(this.selectionModel);
    }

    public abstract int dropIndexOfPoint(Point var1);

    public abstract void registerShortcuts(JComponent var1);

    public abstract void unregisterShortcuts(JComponent var1);

    protected abstract void requestAttention(int var1);

    protected abstract void cancelRequestAttention(int var1);

    public abstract Icon getButtonIcon(int var1, int var2);

    public void postTabAction(TabActionEvent tabActionEvent) {
        if (this.shouldPerformAction(tabActionEvent.getActionCommand(), tabActionEvent.getTabIndex(), tabActionEvent.getMouseEvent())) {
            // empty if block
        }
    }
}

