/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.event.ArrayDiff;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.netbeans.swing.tabcontrol.event.VeryComplexListDataEvent;

final class DefaultTabSelectionModel
implements SingleSelectionModel,
ComplexListDataListener {
    TabDataModel dataModel;
    int sel = -1;
    private transient ArrayList<ChangeListener> changeListenerList;
    ChangeEvent ce = new ChangeEvent(this);

    public DefaultTabSelectionModel(TabDataModel tabDataModel) {
        this.dataModel = tabDataModel;
        this.attach();
    }

    public void attach() {
        this.dataModel.addComplexListDataListener(this);
    }

    public void detach() {
        this.dataModel.removeComplexListDataListener(this);
    }

    public void clearSelection() {
        this.sel = -1;
        this.fireStateChanged();
    }

    public int getSelectedIndex() {
        return this.sel;
    }

    public boolean isSelected() {
        return this.sel != -1;
    }

    public void setSelectedIndex(int n) {
        if (n != this.sel) {
            int n2 = this.sel;
            if (n < -1 || n >= this.dataModel.size()) {
                throw new IllegalArgumentException("Selected index set to " + n + " but model size is only " + this.dataModel.size());
            }
            this.sel = n;
            this.fireStateChanged();
        }
    }

    private void adjustSelectionForEvent(ListDataEvent listDataEvent) {
        if (listDataEvent.getType() == 0 || this.sel == -1) {
            return;
        }
        int n = listDataEvent.getIndex0();
        int n2 = listDataEvent.getIndex1() + 1;
        if (listDataEvent.getType() == 2) {
            if (this.sel < n) {
                return;
            }
            if (this.sel >= n) {
                if (this.sel > n2) {
                    this.sel -= n2 - n;
                } else {
                    this.sel = n;
                    if (this.sel >= this.dataModel.size()) {
                        this.sel = this.dataModel.size() - 1;
                    }
                }
                this.fireStateChanged();
            }
        } else {
            if (this.sel < n) {
                return;
            }
            if (this.sel >= n) {
                this.sel = n2 - 1 == n ? ++this.sel : (this.sel < n2 ? n2 + (this.sel - n) - 1 : (this.sel += n2 - n - 1));
                this.fireStateChanged();
            }
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.adjustSelectionForEvent(listDataEvent);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.adjustSelectionForEvent(listDataEvent);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.adjustSelectionForEvent(listDataEvent);
    }

    public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
        if (this.sel < 0) {
            return;
        }
        int[] nArray = complexListDataEvent.getIndices();
        Arrays.sort(nArray);
        int n = 0;
        for (int i = 0; i < nArray.length && this.sel >= nArray[i]; ++i) {
            ++n;
        }
        if (n > 0) {
            this.sel += n;
            this.fireStateChanged();
        }
    }

    public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
        if (this.sel < 0) {
            return;
        }
        int[] nArray = complexListDataEvent.getIndices();
        Arrays.sort(nArray);
        int n = -1;
        for (int i = 0; i < nArray.length && this.sel > nArray[i]; ++i) {
            --n;
        }
        if (this.sel == this.dataModel.size()) {
            --this.sel;
            this.fireStateChanged();
            return;
        }
        if (this.dataModel.size() == 0) {
            this.sel = -1;
            this.fireStateChanged();
        } else if (n != 0) {
            this.sel = Math.max(-1, Math.min(this.sel + n, -1));
            this.fireStateChanged();
        }
    }

    public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
        if (this.sel < 0) {
            return;
        }
        if (complexListDataEvent instanceof VeryComplexListDataEvent) {
            ArrayDiff arrayDiff = ((VeryComplexListDataEvent)complexListDataEvent).getDiff();
            boolean bl = false;
            if (arrayDiff == null) {
                return;
            }
            Set<Integer> set = arrayDiff.getDeletedIndices();
            Set<Integer> set2 = arrayDiff.getAddedIndices();
            Integer n = new Integer(this.getSelectedIndex());
            if (this.dataModel.size() == 0) {
                this.sel = -1;
                this.fireStateChanged();
                return;
            }
            Iterator<Integer> iterator = set.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Integer n3 = iterator.next();
                if (n3.compareTo(n) > 0) continue;
                ++n2;
            }
            for (Integer n3 : set2) {
                if (n3.compareTo(n) < 0) continue;
                --n2;
            }
            this.sel -= n2;
            if (this.sel < 0) {
                int n4 = this.sel = this.dataModel.size() > 0 ? 0 : -1;
            }
            if (this.sel >= this.dataModel.size()) {
                this.sel = this.dataModel.size() - 1;
            }
            if (n2 != 0) {
                this.fireStateChanged();
            }
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList();
        }
        this.changeListenerList.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListenerList != null) {
            this.changeListenerList.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged() {
        ArrayList<ChangeListener> arrayList;
        DefaultTabSelectionModel defaultTabSelectionModel = this;
        synchronized (defaultTabSelectionModel) {
            if (this.changeListenerList == null) {
                return;
            }
            arrayList = new ArrayList<ChangeListener>(this.changeListenerList);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(this.ce);
        }
    }
}

