/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

final class GtkEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final TabPainter leftClip = new GtkLeftClipPainter();
    private static final TabPainter rightClip = new GtkRightClipPainter();
    private static final TabPainter normal = new GtkPainter();
    private static JTabbedPane dummyTab;
    static final Color ATTENTION_COLOR;
    private static final Insets INSETS;

    public GtkEditorTabCellRenderer() {
        super(leftClip, normal, rightClip, new Dimension(28, 32));
    }

    public Color getSelectedForeground() {
        return UIManager.getColor("textText");
    }

    public Color getForeground() {
        return this.getSelectedForeground();
    }

    public int getPixelsToAddToSelection() {
        return 4;
    }

    protected int getCaptionYAdjustment() {
        return 0;
    }

    public Dimension getPadding() {
        Dimension dimension = super.getPadding();
        dimension.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 28 : 14;
        return dimension;
    }

    private static void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (dummyTab == null) {
            dummyTab = new JTabbedPane();
        }
        Region region = Region.TABBED_PANE_TAB;
        SynthLookAndFeel synthLookAndFeel = (SynthLookAndFeel)UIManager.getLookAndFeel();
        SynthStyleFactory synthStyleFactory = synthLookAndFeel.getStyleFactory();
        SynthStyle synthStyle = synthStyleFactory.getStyle(dummyTab, region);
        SynthContext synthContext = new SynthContext(dummyTab, region, synthStyle, n2);
        SynthPainter synthPainter = synthStyle.getPainter(synthContext);
        synthPainter.paintTabbedPaneTabBackground(synthContext, graphics, n3, n4, n5, n6, n);
    }

    static {
        ATTENTION_COLOR = new Color(255, 238, 120);
        INSETS = new Insets(0, 2, 0, 10);
    }

    private static class GtkLeftClipPainter
    implements TabPainter {
        private GtkLeftClipPainter() {
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Polygon getInteriorPolygon(Component component) {
            GtkEditorTabCellRenderer gtkEditorTabCellRenderer = (GtkEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = -3;
            int n2 = 1;
            int n3 = component.getWidth() + 3;
            int n4 = gtkEditorTabCellRenderer.isSelected() ? component.getHeight() + 2 : component.getHeight() - 1;
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3, n2);
            polygon.addPoint(n + n3, n2 + n4);
            polygon.addPoint(n, n2 + n4);
            return polygon;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        public void paintInterior(Graphics graphics, Component component) {
            GtkEditorTabCellRenderer gtkEditorTabCellRenderer = (GtkEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            if (gtkEditorTabCellRenderer.isSelected()) {
                GtkEditorTabCellRenderer.paintTabBackground(graphics, 0, 512, polygon.getBounds().x, polygon.getBounds().y, polygon.getBounds().width, polygon.getBounds().height);
            } else {
                GtkEditorTabCellRenderer.paintTabBackground(graphics, 0, 0, polygon.getBounds().x, polygon.getBounds().y + 2, polygon.getBounds().width, polygon.getBounds().height - 2);
            }
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }
    }

    private static class GtkPainter
    implements TabPainter {
        private GtkPainter() {
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Polygon getInteriorPolygon(Component component) {
            GtkEditorTabCellRenderer gtkEditorTabCellRenderer = (GtkEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = gtkEditorTabCellRenderer.isLeftmost() ? 1 : 0;
            int n2 = 1;
            int n3 = gtkEditorTabCellRenderer.isLeftmost() ? component.getWidth() - 1 : component.getWidth();
            int n4 = gtkEditorTabCellRenderer.isSelected() ? component.getHeight() + 2 : component.getHeight() - 1;
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3, n2);
            polygon.addPoint(n + n3, n2 + n4);
            polygon.addPoint(n, n2 + n4);
            return polygon;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            GtkEditorTabCellRenderer gtkEditorTabCellRenderer = (GtkEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
        }

        public void paintInterior(Graphics graphics, Component component) {
            GtkEditorTabCellRenderer gtkEditorTabCellRenderer = (GtkEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            if (gtkEditorTabCellRenderer.isSelected()) {
                GtkEditorTabCellRenderer.paintTabBackground(graphics, 0, 512, polygon.getBounds().x, polygon.getBounds().y, polygon.getBounds().width, polygon.getBounds().height);
            } else {
                GtkEditorTabCellRenderer.paintTabBackground(graphics, 0, 0, polygon.getBounds().x, polygon.getBounds().y + 2, polygon.getBounds().width, polygon.getBounds().height - 2);
            }
            if (!this.supportsCloseButton((JComponent)component)) {
                return;
            }
            this.paintCloseButton(graphics, (JComponent)component);
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            boolean bl;
            boolean bl2 = ((GtkEditorTabCellRenderer)jComponent).isClipRight();
            boolean bl3 = ((GtkEditorTabCellRenderer)jComponent).isClipLeft();
            boolean bl4 = bl = !((GtkEditorTabCellRenderer)jComponent).isShowCloseButton();
            if (bl3 || bl2 || bl) {
                rectangle.x = -100;
                rectangle.y = -100;
                rectangle.width = 0;
                rectangle.height = 0;
            } else {
                String string = this.findIconPath((GtkEditorTabCellRenderer)jComponent);
                Icon icon = TabControlButtonFactory.getIcon(string);
                int n = icon.getIconWidth();
                int n2 = icon.getIconHeight();
                rectangle.x = rectangle2.x + rectangle2.width - n - 2;
                rectangle.y = rectangle2.y + Math.max(0, rectangle2.height / 2 - n2 / 2);
                rectangle.width = n;
                rectangle.height = n2;
            }
        }

        private void paintCloseButton(Graphics graphics, JComponent jComponent) {
            if (((AbstractTabCellRenderer)jComponent).isShowCloseButton()) {
                Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
                Rectangle rectangle2 = new Rectangle();
                this.getCloseButtonRectangle(jComponent, rectangle2, rectangle);
                String string = this.findIconPath((GtkEditorTabCellRenderer)jComponent);
                Icon icon = TabControlButtonFactory.getIcon(string);
                icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
            }
        }

        private String findIconPath(GtkEditorTabCellRenderer gtkEditorTabCellRenderer) {
            if (gtkEditorTabCellRenderer.inCloseButton() && gtkEditorTabCellRenderer.isPressed()) {
                return "org/netbeans/swing/tabcontrol/resources/gtk_close_pressed.png";
            }
            if (gtkEditorTabCellRenderer.inCloseButton()) {
                return "org/netbeans/swing/tabcontrol/resources/gtk_close_rollover.png";
            }
            return "org/netbeans/swing/tabcontrol/resources/gtk_close_enabled.png";
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return ((AbstractTabCellRenderer)jComponent).isShowCloseButton();
        }
    }

    private static class GtkRightClipPainter
    implements TabPainter {
        private GtkRightClipPainter() {
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Polygon getInteriorPolygon(Component component) {
            GtkEditorTabCellRenderer gtkEditorTabCellRenderer = (GtkEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = 0;
            int n2 = 1;
            int n3 = component.getWidth() + 10;
            int n4 = gtkEditorTabCellRenderer.isSelected() ? component.getHeight() + 2 : component.getHeight() - 1;
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3, n2);
            polygon.addPoint(n + n3, n2 + n4);
            polygon.addPoint(n, n2 + n4);
            return polygon;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        public void paintInterior(Graphics graphics, Component component) {
            GtkEditorTabCellRenderer gtkEditorTabCellRenderer = (GtkEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(component);
            if (gtkEditorTabCellRenderer.isSelected()) {
                GtkEditorTabCellRenderer.paintTabBackground(graphics, 0, 512, polygon.getBounds().x, polygon.getBounds().y, polygon.getBounds().width, polygon.getBounds().height);
            } else {
                GtkEditorTabCellRenderer.paintTabBackground(graphics, 0, 0, polygon.getBounds().x, polygon.getBounds().y + 2, polygon.getBounds().width, polygon.getBounds().height - 2);
            }
        }

        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }

        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }
    }
}

