/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabListPopupAction;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbed;
import org.netbeans.swing.tabcontrol.plaf.TabControlButton;

class TabControlButtonFactory {
    private static IconLoader iconCache;

    private TabControlButtonFactory() {
    }

    public static Icon getIcon(String string) {
        if (null == iconCache) {
            iconCache = new IconLoader();
        }
        return iconCache.obtainIcon(string);
    }

    public static TabControlButton createCloseButton(TabDisplayer tabDisplayer) {
        return new CloseButton(tabDisplayer);
    }

    public static TabControlButton createSlidePinButton(TabDisplayer tabDisplayer) {
        return new SlidePinButton(tabDisplayer);
    }

    public static TabControlButton createMaximizeRestoreButton(TabDisplayer tabDisplayer) {
        return new MaximizeRestoreButton(tabDisplayer);
    }

    public static TabControlButton createScrollLeftButton(TabDisplayer tabDisplayer, Action action) {
        TimerButton timerButton = new TimerButton(9, tabDisplayer, action);
        timerButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Scroll_Documents_Left"));
        return timerButton;
    }

    public static TabControlButton createScrollRightButton(TabDisplayer tabDisplayer, Action action) {
        TimerButton timerButton = new TimerButton(10, tabDisplayer, action);
        timerButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Scroll_Documents_Right"));
        return timerButton;
    }

    public static TabControlButton createDropDownButton(TabDisplayer tabDisplayer) {
        return new DropDownButton(tabDisplayer);
    }

    private static Component getActiveTab(TabDisplayer tabDisplayer) {
        Component component = null;
        int n = tabDisplayer.getSelectionModel().getSelectedIndex();
        if (n >= 0) {
            TabData tabData = tabDisplayer.getModel().getTab(n);
            component = tabData.getComponent();
        }
        return component;
    }

    private static Image loadImage(String string) {
        try {
            URL uRL = TabControlButtonFactory.class.getResource("/" + string);
            return ImageIO.read(uRL);
        }
        catch (Exception exception) {
            Logger.getLogger(TabControlButtonFactory.class.getName()).log(Level.WARNING, "Cannot load image", exception);
            return null;
        }
    }

    private static class CloseButton
    extends TabControlButton {
        public CloseButton(TabDisplayer tabDisplayer) {
            super(1, tabDisplayer);
            this.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Close_Window"));
        }

        protected String getTabActionCommand(ActionEvent actionEvent) {
            return "close";
        }
    }

    private static class DropDownButton
    extends TabControlButton {
        private boolean forcePressedIcon = false;

        public DropDownButton(TabDisplayer tabDisplayer) {
            super(8, tabDisplayer);
            this.setAction(new TabListPopupAction(tabDisplayer));
            this.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Show_Opened_Documents_List"));
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (this.isEnabled()) {
                if (mouseEvent.getID() == 501) {
                    this.forcePressedIcon = true;
                    this.repaint();
                    this.getAction().actionPerformed(new ActionEvent(this, 1001, "pressed"));
                    return;
                }
            }
            if (!this.isEnabled()) return;
            if (mouseEvent.getID() != 502) return;
            this.forcePressedIcon = false;
            this.repaint();
        }

        protected String getTabActionCommand(ActionEvent actionEvent) {
            return null;
        }

        void performAction(ActionEvent actionEvent) {
        }

        public Icon getRolloverIcon() {
            if (this.forcePressedIcon) {
                return this.getPressedIcon();
            }
            return super.getRolloverIcon();
        }

        public Icon getIcon() {
            if (this.forcePressedIcon) {
                return this.getPressedIcon();
            }
            return super.getIcon();
        }
    }

    private static final class IconLoader {
        private Map<String, Icon> paths2Icons;

        private IconLoader() {
        }

        public Icon obtainIcon(String string) {
            Icon icon;
            if (this.paths2Icons == null) {
                this.paths2Icons = new HashMap<String, Icon>(6);
            }
            if ((icon = this.paths2Icons.get(string)) == null) {
                Image image = TabControlButtonFactory.loadImage(string);
                if (image == null) {
                    throw new IllegalArgumentException("Icon with resource path: " + string + " can't be loaded, probably wrong path.");
                }
                icon = new ImageIcon(image);
                this.paths2Icons.put(string, icon);
            }
            return icon;
        }
    }

    private static class MaximizeRestoreButton
    extends TabControlButton {
        public MaximizeRestoreButton(TabDisplayer tabDisplayer) {
            super(tabDisplayer);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }

        protected String getTabActionCommand(ActionEvent actionEvent) {
            return "maximize";
        }

        protected int getButtonId() {
            WinsysInfoForTabbed winsysInfoForTabbed;
            int n = 3;
            Component component = TabControlButtonFactory.getActiveTab(this.getTabDisplayer());
            if (null != component && null != (winsysInfoForTabbed = this.getTabDisplayer().getWinsysInfo()) && winsysInfoForTabbed.inMaximizedMode(component)) {
                n = 4;
            }
            return n;
        }

        public String getToolTipText() {
            if (this.getButtonId() == 3) {
                return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Maximize_Window");
            }
            return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Restore_Window");
        }
    }

    private static class SlidePinButton
    extends TabControlButton {
        public SlidePinButton(TabDisplayer tabDisplayer) {
            super(tabDisplayer);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }

        protected String getTabActionCommand(ActionEvent actionEvent) {
            if (this.getButtonId() == 2) {
                return "disableAutoHide";
            }
            return "enableAutoHide";
        }

        protected int getButtonId() {
            WinsysInfoForTabbed winsysInfoForTabbed;
            int n = 2;
            Component component = TabControlButtonFactory.getActiveTab(this.getTabDisplayer());
            if (null != component && null != (winsysInfoForTabbed = this.getTabDisplayer().getWinsysInfo())) {
                Object object = winsysInfoForTabbed.getOrientation(component);
                if (TabDisplayer.ORIENTATION_EAST.equals(object)) {
                    n = 6;
                } else if (TabDisplayer.ORIENTATION_WEST.equals(object)) {
                    n = 5;
                } else if (TabDisplayer.ORIENTATION_SOUTH.equals(object)) {
                    n = 7;
                }
            }
            return n;
        }

        public String getToolTipText() {
            if (this.getButtonId() == 2) {
                return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Pin");
            }
            return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Minimize_Window");
        }
    }

    private static class TimerButton
    extends TabControlButton
    implements ActionListener {
        Timer timer = null;
        int count = 0;

        public TimerButton(int n, TabDisplayer tabDisplayer, Action action) {
            super(n, tabDisplayer);
            this.setAction(action);
        }

        private Timer getTimer() {
            if (this.timer == null) {
                this.timer = new Timer(400, this);
                this.timer.setRepeats(true);
            }
            return this.timer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ++this.count;
            if (this.count > 2) {
                if (this.count > 5) {
                    this.timer.setDelay(75);
                } else {
                    this.timer.setDelay(200);
                }
            }
            this.performAction();
        }

        private void performAction() {
            if (!this.isEnabled()) {
                this.stopTimer();
                return;
            }
            this.getAction().actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }

        private void startTimer() {
            Timer timer = this.getTimer();
            if (timer.isRunning()) {
                return;
            }
            this.repaint();
            timer.setDelay(400);
            timer.start();
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.repaint();
            this.count = 0;
        }

        /*
         * Unable to fully structure code
         */
        protected void processMouseEvent(MouseEvent var1_1) {
            if (!this.isEnabled()) ** GOTO lbl-1000
            if (var1_1.getID() == 501) {
                this.startTimer();
            } else if (var1_1.getID() == 502) {
                this.stopTimer();
            }
            super.processMouseEvent(var1_1);
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            if (focusEvent.getID() == 1005) {
                this.stopTimer();
            }
        }

        protected String getTabActionCommand(ActionEvent actionEvent) {
            return null;
        }
    }
}

