/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.modules.editor.lib2.AcceptorFactory;
import org.openide.util.NbBundle;

public final class DocUtils {
    private static final Logger LOG = Logger.getLogger(DocUtils.class.getName());

    public static int getRowStart(Document document, int n, int n2) throws BadLocationException {
        DocUtils.checkOffsetValid(document, n);
        if (n2 != 0) {
            Element element = document.getDefaultRootElement();
            int n3 = element.getElementIndex(n);
            if ((n3 += n2) < 0 || n3 >= element.getElementCount()) {
                return -1;
            }
            return element.getElement(n3).getStartOffset();
        }
        return document.getDefaultRootElement().getElement(document.getDefaultRootElement().getElementIndex(n)).getStartOffset();
    }

    public static int getRowEnd(Document document, int n) throws BadLocationException {
        DocUtils.checkOffsetValid(document, n);
        return document.getDefaultRootElement().getElement(document.getDefaultRootElement().getElementIndex(n)).getEndOffset() - 1;
    }

    public static int getLineOffset(Document document, int n) throws BadLocationException {
        DocUtils.checkOffsetValid(n, document.getLength() + 1);
        Element element = document.getDefaultRootElement();
        return element.getElementIndex(n);
    }

    public static String debugPosition(Document document, int n) {
        String string;
        if (n >= 0) {
            try {
                int n2 = DocUtils.getLineOffset(document, n) + 1;
                int n3 = DocUtils.getVisualColumn(document, n) + 1;
                string = String.valueOf(n2) + ":" + String.valueOf(n3);
            }
            catch (BadLocationException badLocationException) {
                string = NbBundle.getBundle(DocUtils.class).getString("wrong_position") + ' ' + n + " > " + document.getLength();
            }
        } else {
            string = String.valueOf(n);
        }
        return string;
    }

    public static int getVisualColumn(Document document, int n) throws BadLocationException {
        int n2 = document.getLength();
        if (n == n2 + 1) {
            n = n2;
        }
        try {
            Method method = document.getClass().getMethod("getVisColFromPos", Integer.TYPE);
            return (Integer)method.invoke((Object)document, n);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static boolean isIdentifierPart(Document document, char c) {
        return AcceptorFactory.LETTER_DIGIT.accept(c);
    }

    public static boolean isWhitespace(char c) {
        return AcceptorFactory.WHITESPACE.accept(c);
    }

    public static void atomicLock(Document document) {
        try {
            Method method = document.getClass().getMethod("atomicLock", new Class[0]);
            method.invoke((Object)document, new Object[0]);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    public static void atomicUnlock(Document document) {
        try {
            Method method = document.getClass().getMethod("atomicUnlock", new Class[0]);
            method.invoke((Object)document, new Object[0]);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    private static void checkOffsetValid(Document document, int n) throws BadLocationException {
        DocUtils.checkOffsetValid(n, document.getLength());
    }

    private static void checkOffsetValid(int n, int n2) throws BadLocationException {
        if (n < 0 || n > n2) {
            throw new BadLocationException("Invalid offset=" + n + " not within <0, " + n2 + ">", n);
        }
    }

    private DocUtils() {
    }
}

