/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.modules.editor.lib2.ComponentUtils;
import org.netbeans.modules.editor.lib2.DocumentsRegistry;

public class DocumentsJumpList {
    private static final int MAX_SIZE = 50;
    private static final int CHECK_COUNT = 10;
    private static Entry currentEntry;
    private static int checkCnt;
    private static final PropertyChangeSupport support;
    private static boolean dotAtCurrentEntry;
    private static PropertyChangeListener registryListener;

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        support.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        support.removePropertyChangeListener(propertyChangeListener);
    }

    public static void dotMoved(JTextComponent jTextComponent, int n) {
        if (dotAtCurrentEntry && currentEntry != null && (currentEntry.getComponent() != jTextComponent || currentEntry.getPosition() != n)) {
            support.firePropertyChange(null, null, null);
            dotAtCurrentEntry = false;
        } else {
            dotAtCurrentEntry = currentEntry != null && currentEntry.getComponent() == jTextComponent && currentEntry.getPosition() == n;
        }
    }

    public static void checkAddEntry() {
        JTextComponent jTextComponent = DocumentsRegistry.getMostActiveComponent();
        if (jTextComponent != null) {
            DocumentsJumpList.checkAddEntry(jTextComponent, jTextComponent.getCaret().getDot());
        }
    }

    public static void checkAddEntry(JTextComponent jTextComponent) {
        DocumentsJumpList.checkAddEntry(jTextComponent, jTextComponent.getCaret().getDot());
    }

    public static void checkAddEntry(JTextComponent jTextComponent, int n) {
        if (currentEntry == null || currentEntry.getComponent() != jTextComponent || currentEntry.getPosition() != n) {
            DocumentsJumpList.addEntry(jTextComponent, n);
        }
    }

    public static void addEntry(JTextComponent jTextComponent, int n) {
        try {
            Entry entry;
            currentEntry = entry = new Entry(jTextComponent, n, currentEntry);
            if (++checkCnt >= 10) {
                DocumentsJumpList.sizeCheck();
            }
            dotAtCurrentEntry = true;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void jumpPrev(JTextComponent jTextComponent) {
        int n = jTextComponent.getCaret().getDot();
        if (currentEntry != null) {
            while (true) {
                int n2 = currentEntry.getPosition();
                JTextComponent jTextComponent2 = currentEntry.getComponent();
                if (jTextComponent2 != null && (jTextComponent2 != jTextComponent || n2 >= 0 && n2 != n) && currentEntry.setDot()) {
                    support.firePropertyChange(null, null, null);
                    break;
                }
                if (currentEntry.prev == null) break;
                currentEntry = currentEntry.prev;
            }
        }
    }

    public static boolean hasPrev() {
        Entry entry;
        Caret caret;
        JTextComponent jTextComponent = DocumentsRegistry.getMostActiveComponent();
        Caret caret2 = caret = jTextComponent != null ? jTextComponent.getCaret() : null;
        if (caret != null && (entry = currentEntry) != null) {
            while (true) {
                int n = entry.getPosition();
                JTextComponent jTextComponent2 = entry.getComponent();
                int n2 = caret.getDot();
                if (jTextComponent2 != null && (jTextComponent2 != jTextComponent || n >= 0 && n != n2) && n >= 0 && n <= jTextComponent2.getDocument().getLength()) {
                    return true;
                }
                if (entry.prev == null) break;
                entry = entry.prev;
            }
        }
        return false;
    }

    public static void jumpNext(JTextComponent jTextComponent) {
        int n = jTextComponent.getCaret().getDot();
        if (currentEntry != null) {
            currentEntry = currentEntry.next;
        }
        if (currentEntry != null) {
            while (true) {
                int n2 = currentEntry.getPosition();
                JTextComponent jTextComponent2 = currentEntry.getComponent();
                if (jTextComponent2 != null && (jTextComponent2 != jTextComponent || n2 >= 0 && n2 != n) && currentEntry.setDot()) {
                    support.firePropertyChange(null, null, null);
                    break;
                }
                if (currentEntry.next == null) break;
                currentEntry = currentEntry.next;
            }
        }
    }

    public static boolean hasNext() {
        JTextComponent jTextComponent = DocumentsRegistry.getMostActiveComponent();
        if (jTextComponent != null) {
            Entry entry;
            int n = jTextComponent.getCaret().getDot();
            Entry entry2 = entry = currentEntry != null ? currentEntry.next : currentEntry;
            if (entry != null) {
                while (true) {
                    int n2 = entry.getPosition();
                    JTextComponent jTextComponent2 = entry.getComponent();
                    if (jTextComponent2 != null && (jTextComponent2 != jTextComponent || n2 >= 0 && n2 != n) && n2 >= 0 && n2 <= jTextComponent2.getDocument().getLength()) {
                        return true;
                    }
                    if (entry.next == null) break;
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public static void jumpPrevComponent(JTextComponent jTextComponent) {
        if (currentEntry != null) {
            JTextComponent jTextComponent2;
            while (!((jTextComponent2 = currentEntry.getComponent()) != null && jTextComponent2 != jTextComponent && currentEntry.setDot() || currentEntry.prev == null)) {
                currentEntry = currentEntry.prev;
            }
        }
    }

    public static void jumpNextComponent(JTextComponent jTextComponent) {
        if (currentEntry != null) {
            JTextComponent jTextComponent2;
            while (!((jTextComponent2 = currentEntry.getComponent()) != null && jTextComponent2 != jTextComponent && currentEntry.setDot() || currentEntry.next == null)) {
                currentEntry = currentEntry.next;
            }
        }
    }

    public static String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Entry entry = currentEntry;
        if (entry != null) {
            while (entry.prev != null) {
                entry = entry.prev;
                --n;
            }
            while (entry != null) {
                String string;
                JTextComponent jTextComponent = entry.getComponent();
                String string2 = string = jTextComponent != null ? (String)jTextComponent.getDocument().getProperty("title") : "<Invalid document>";
                if (string == null) {
                    string = "Untitled";
                }
                stringBuffer.append("[" + n++ + "]=" + string + ", " + entry.getPosition() + "\n");
                entry = entry.next;
            }
        } else {
            stringBuffer.append("Empty list");
        }
        return stringBuffer.toString();
    }

    private static void sizeCheck() {
        Entry entry = currentEntry;
        for (int i = 50; entry != null && i > 0; --i) {
            entry = entry.prev;
        }
        if (entry != null) {
            entry.makeFirst();
        }
    }

    static {
        support = new PropertyChangeSupport(DocumentsJumpList.class);
        dotAtCurrentEntry = false;
        registryListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                support.firePropertyChange(null, null, null);
            }
        };
        DocumentsRegistry.addPropertyChangeListener(registryListener);
    }

    public static class Entry {
        private int componentID;
        private Position pos;
        private Entry prev;
        private Entry next;

        private Entry(JTextComponent jTextComponent, int n, Entry entry) throws BadLocationException {
            this.componentID = DocumentsRegistry.getID(jTextComponent);
            this.pos = jTextComponent.getDocument().createPosition(n);
            if (entry != null) {
                entry.next = this;
                this.prev = entry;
            }
        }

        public int getPosition() {
            return this.pos.getOffset();
        }

        public JTextComponent getComponent() {
            return DocumentsRegistry.getComponent(this.componentID);
        }

        public boolean setDot() {
            JTextComponent jTextComponent = this.getComponent();
            if (jTextComponent != null) {
                int n;
                if (DocumentsRegistry.getMostActiveComponent() != jTextComponent) {
                    ComponentUtils.requestFocus(jTextComponent);
                    DocumentsRegistry.activate(jTextComponent);
                }
                if ((n = this.getPosition()) >= 0 && n <= jTextComponent.getDocument().getLength()) {
                    jTextComponent.getCaret().setDot(n);
                    return true;
                }
            }
            return false;
        }

        void makeLast() {
            if (this.next != null) {
                this.next.prev = null;
                this.next = null;
            }
        }

        void makeFirst() {
            if (this.prev != null) {
                this.prev.next = null;
                this.prev = null;
            }
        }
    }
}

