/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.PositionsBag;

public class BlockHighlighting
extends AbstractHighlightsContainer
implements HighlightsChangeListener {
    private static final Logger LOG = Logger.getLogger(BlockHighlighting.class.getName());
    private String layerId;
    private JTextComponent component;
    private Document document;
    private PositionsBag bag;

    public BlockHighlighting(String string, JTextComponent jTextComponent) {
        this.layerId = string;
        this.component = jTextComponent;
        this.document = jTextComponent.getDocument();
        this.bag = new PositionsBag(this.document);
        this.bag.addHighlightsChangeListener(this);
        EditorFindSupport.getInstance().hookLayer(this, jTextComponent);
    }

    public String getLayerTypeId() {
        return this.layerId;
    }

    public HighlightsSequence getHighlights(int n, int n2) {
        return this.bag.getHighlights(n, n2);
    }

    public void highlightChanged(HighlightsChangeEvent highlightsChangeEvent) {
        this.fireHighlightsChange(highlightsChangeEvent.getStartOffset(), highlightsChangeEvent.getEndOffset());
    }

    public void highlightBlock(final int n, final int n2, final String string) {
        this.document.render(new Runnable(){

            public void run() {
                if (n < n2) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Highlighting block: [" + n + ", " + n2 + "]; " + BlockHighlighting.this.getLayerTypeId());
                    }
                    try {
                        PositionsBag positionsBag = new PositionsBag(BlockHighlighting.this.document);
                        positionsBag.addHighlight(BlockHighlighting.this.document.createPosition(n), BlockHighlighting.this.document.createPosition(n2), BlockHighlighting.this.getAttribs(string));
                        BlockHighlighting.this.bag.setHighlights(positionsBag);
                    }
                    catch (BadLocationException badLocationException) {
                        LOG.log(Level.FINE, "Can't add highlight <" + n + ", " + n2 + ", " + string + ">", badLocationException);
                    }
                } else {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Reseting block highlighs; " + BlockHighlighting.this.getLayerTypeId());
                    }
                    BlockHighlighting.this.bag.clear();
                }
            }
        });
    }

    public int[] gethighlightedBlock() {
        HighlightsSequence highlightsSequence = this.bag.getHighlights(Integer.MIN_VALUE, Integer.MAX_VALUE);
        if (highlightsSequence.moveNext()) {
            return new int[]{highlightsSequence.getStartOffset(), highlightsSequence.getEndOffset()};
        }
        return null;
    }

    private AttributeSet getAttribs(String string) {
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.parse((String)this.getMimeType())).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings.getFontColors(string);
        return attributeSet == null ? SimpleAttributeSet.EMPTY : attributeSet;
    }

    private String getMimeType() {
        return this.component.getUI().getEditorKit(this.component).getContentType();
    }
}

