/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.lang.ref.WeakReference;
import java.util.ConcurrentModificationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;

public final class CompoundHighlightsContainer
extends AbstractHighlightsContainer {
    private static final Logger LOG = Logger.getLogger(CompoundHighlightsContainer.class.getName());
    private static final Position MAX_POSITION = new Position(){

        public int getOffset() {
            return Integer.MAX_VALUE;
        }
    };
    private static final int MIN_CACHE_SIZE = 128;
    private Document doc;
    private HighlightsContainer[] layers;
    private long version = 0L;
    private final String LOCK = new String("CompoundHighlightsContainer.LOCK");
    private final LayerListener listener = new LayerListener(this);
    private OffsetsBag cache;
    private Position cacheLowestPos;
    private Position cacheHighestPos;

    public CompoundHighlightsContainer() {
        this(null, null);
    }

    public CompoundHighlightsContainer(Document document, HighlightsContainer[] highlightsContainerArray) {
        this.setLayers(document, highlightsContainerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int n, int n2) {
        assert (0 <= n) : "offsets must be greater than or equal to zero";
        assert (n <= n2) : "startOffset must be less than or equal to endOffset; startOffset = " + n + " endOffset = " + n2;
        String string = this.LOCK;
        synchronized (string) {
            int n3;
            int n4;
            if (this.doc == null || this.layers == null || this.layers.length == 0 || n == n2) {
                return HighlightsSequence.EMPTY;
            }
            int[] nArray = null;
            int n5 = this.cacheLowestPos == null ? -1 : this.cacheLowestPos.getOffset();
            int n6 = n4 = this.cacheHighestPos == null ? -1 : this.cacheHighestPos.getOffset();
            if (n5 == -1 || n4 == -1) {
                this.cache = null;
            } else {
                n3 = Math.max(128, n4 - n5);
                if (n2 > n5 - n3 && n2 <= n4 && n < n5) {
                    nArray = new int[]{n, n5};
                } else if (n < n4 + n3 && n >= n5 && n2 > n4) {
                    nArray = new int[]{n4, n2};
                } else if (n < n5 && n2 > n4) {
                    nArray = new int[]{n, n5, n4, n2};
                } else if (n < n5 || n2 > n4) {
                    this.cache = null;
                }
            }
            if (this.cache == null) {
                this.cache = new OffsetsBag(this.doc, true);
                n4 = -1;
                n5 = -1;
                nArray = new int[]{n, n2};
            }
            if (nArray != null) {
                for (n3 = 0; n3 < nArray.length / 2; ++n3) {
                    if (nArray[2 * n3 + 1] - nArray[2 * n3] < 128) {
                        nArray[2 * n3 + 1] = nArray[2 * n3] + 128;
                        if (nArray[2 * n3 + 1] >= this.doc.getLength()) {
                            nArray[2 * n3 + 1] = Integer.MAX_VALUE;
                        }
                    }
                    this.updateCache(nArray[2 * n3], nArray[2 * n3 + 1]);
                    if (nArray[2 * n3 + 1] == Integer.MAX_VALUE) break;
                }
                if (n5 == -1 || n4 == -1) {
                    this.cacheLowestPos = this.createPosition((int)nArray[0]);
                    this.cacheHighestPos = this.createPosition(nArray[nArray.length - 1]);
                } else {
                    this.cacheLowestPos = this.createPosition(Math.min(n5, (int)nArray[0]));
                    this.cacheHighestPos = this.createPosition(Math.max(n4, nArray[nArray.length - 1]));
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Cache boundaries: <" + (this.cacheLowestPos == null ? "-" : Integer.valueOf(this.cacheLowestPos.getOffset())) + ", " + (this.cacheHighestPos == null ? "-" : Integer.valueOf(this.cacheHighestPos.getOffset())) + "> " + "when asked for <" + n + ", " + n2 + ">");
                }
            }
            return new Seq(this.version, this.cache.getHighlights(n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsContainer[] getLayers() {
        String string = this.LOCK;
        synchronized (string) {
            return this.layers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayers(Document document, HighlightsContainer[] highlightsContainerArray) {
        Document document2 = null;
        String string = this.LOCK;
        synchronized (string) {
            int n;
            if (document == null) assert (highlightsContainerArray == null) : "If doc is null the layers must be null too.";
            Document document3 = document2 = document != null ? document : this.doc;
            if (this.layers != null) {
                for (n = 0; n < this.layers.length; ++n) {
                    this.layers[n].removeHighlightsChangeListener(this.listener);
                }
            }
            this.doc = document;
            this.layers = highlightsContainerArray;
            this.cache = null;
            ++this.version;
            if (this.layers != null) {
                for (n = 0; n < this.layers.length; ++n) {
                    this.layers[n].addHighlightsChangeListener(this.listener);
                }
            }
        }
        if (document2 != null) {
            document2.render(new Runnable(){

                public void run() {
                    CompoundHighlightsContainer.this.fireHighlightsChange(0, Integer.MAX_VALUE);
                }
            });
        }
    }

    public void resetCache() {
        this.layerChanged(null, 0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layerChanged(HighlightsContainer highlightsContainer, final int n, final int n2) {
        Document document = null;
        String string = this.LOCK;
        synchronized (string) {
            this.cache = null;
            ++this.version;
            document = this.doc;
        }
        if (document != null) {
            document.render(new Runnable(){

                public void run() {
                    CompoundHighlightsContainer.this.fireHighlightsChange(n, n2);
                }
            });
        }
    }

    private void updateCache(int n, int n2) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Updating cache: <" + n + ", " + n2 + ">");
        }
        for (HighlightsContainer highlightsContainer : this.layers) {
            HighlightsSequence highlightsSequence = highlightsContainer.getHighlights(n, n2);
            this.cache.addAllHighlights(highlightsSequence);
        }
    }

    private Position createPosition(int n) {
        try {
            if (n == Integer.MAX_VALUE) {
                return MAX_POSITION;
            }
            return this.doc.createPosition(n);
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, "Can't create document position: offset = " + n + ", document.lenght = " + this.doc.getLength(), badLocationException);
            return null;
        }
    }

    private static final class LayerListener
    implements HighlightsChangeListener {
        private WeakReference<CompoundHighlightsContainer> ref;

        public LayerListener(CompoundHighlightsContainer compoundHighlightsContainer) {
            this.ref = new WeakReference<CompoundHighlightsContainer>(compoundHighlightsContainer);
        }

        public void highlightChanged(HighlightsChangeEvent highlightsChangeEvent) {
            CompoundHighlightsContainer compoundHighlightsContainer = (CompoundHighlightsContainer)this.ref.get();
            if (compoundHighlightsContainer != null) {
                compoundHighlightsContainer.layerChanged((HighlightsContainer)highlightsChangeEvent.getSource(), highlightsChangeEvent.getStartOffset(), highlightsChangeEvent.getEndOffset());
            }
        }
    }

    private final class Seq
    implements HighlightsSequence {
        private HighlightsSequence seq;
        private long version;

        public Seq(long l, HighlightsSequence highlightsSequence) {
            this.version = l;
            this.seq = highlightsSequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            String string = CompoundHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                return this.seq.moveNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            String string = CompoundHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                return this.seq.getStartOffset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            String string = CompoundHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                return this.seq.getEndOffset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            String string = CompoundHighlightsContainer.this.LOCK;
            synchronized (string) {
                this.checkVersion();
                return this.seq.getAttributes();
            }
        }

        private void checkVersion() {
            if (this.version != CompoundHighlightsContainer.this.version) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

