/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.highlighting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZOrder {
    private static final Logger LOG = Logger.getLogger(ZOrder.class.getName());
    private static final Collection<String> EMPTY = new HashSet<String>();
    private static final String TOP_RACK_MARKER = "org-netbeans-spi-editor-highlighting-ZOrder-TOP-RACK";
    private static final String SHOW_OFF_RACK_MARKER = "org-netbeans-spi-editor-highlighting-ZOrder-SHOW-OFF-RACK";
    private static final String DEFAULT_RACK_MARKER = "org-netbeans-spi-editor-highlighting-ZOrder-DEFAULT-RACK";
    private static final String CARET_RACK_MARKER = "org-netbeans-spi-editor-highlighting-ZOrder-CARET-RACK";
    private static final String SYNTAX_RACK_MARKER = "org-netbeans-spi-editor-highlighting-ZOrder-SYNTAX-RACK";
    public static final ZOrder TOP_RACK = ZOrder.above("org-netbeans-spi-editor-highlighting-ZOrder-TOP-RACK");
    public static final ZOrder SHOW_OFF_RACK = new ZOrder(Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-TOP-RACK"), Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-SHOW-OFF-RACK"));
    public static final ZOrder DEFAULT_RACK = new ZOrder(Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-SHOW-OFF-RACK"), Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-DEFAULT-RACK"));
    public static final ZOrder CARET_RACK = new ZOrder(Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-DEFAULT-RACK"), Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-CARET-RACK"));
    public static final ZOrder SYNTAX_RACK = new ZOrder(Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-CARET-RACK"), Collections.singleton("org-netbeans-spi-editor-highlighting-ZOrder-SYNTAX-RACK"));
    public static final ZOrder BOTTOM_RACK = ZOrder.below("org-netbeans-spi-editor-highlighting-ZOrder-SYNTAX-RACK");
    final Collection<String> layersAbove;
    final Collection<String> layersBelow;

    public static ZOrder above(String ... stringArray) {
        return new ZOrder(null, Arrays.asList(stringArray));
    }

    public static ZOrder below(String ... stringArray) {
        return new ZOrder(Arrays.asList(stringArray), null);
    }

    static HighlightsLayer[] sort(HighlightsLayer[] highlightsLayerArray) throws TopologicalSortException {
        List<? extends HighlightsLayer> list = ZOrder.sort(Arrays.asList(highlightsLayerArray));
        return list.toArray(new HighlightsLayer[list.size()]);
    }

    static List<? extends HighlightsLayer> sort(Collection<? extends HighlightsLayer> collection) throws TopologicalSortException {
        ArrayList<Object> arrayList;
        Object object2;
        HashMap<String, HighlightsLayer> hashMap = new HashMap<String, HighlightsLayer>();
        HashSet<String> hashSet = new HashSet<String>();
        HashMap hashMap2 = new HashMap();
        hashSet.add(TOP_RACK_MARKER);
        hashSet.add(SHOW_OFF_RACK_MARKER);
        hashSet.add(DEFAULT_RACK_MARKER);
        hashSet.add(CARET_RACK_MARKER);
        hashSet.add(SYNTAX_RACK_MARKER);
        hashMap2.put(SYNTAX_RACK_MARKER, new ArrayList<String>(Collections.singleton(CARET_RACK_MARKER)));
        hashMap2.put(CARET_RACK_MARKER, new ArrayList<String>(Collections.singleton(DEFAULT_RACK_MARKER)));
        hashMap2.put(DEFAULT_RACK_MARKER, new ArrayList<String>(Collections.singleton(SHOW_OFF_RACK_MARKER)));
        hashMap2.put(SHOW_OFF_RACK_MARKER, new ArrayList<String>(Collections.singleton(TOP_RACK_MARKER)));
        for (HighlightsLayer object32 : collection) {
            hashMap.put(object32.getLayerTypeId(), object32);
            for (String string : object32.getZOrder().layersBelow) {
                hashSet.add(string);
                object2 = (List)hashMap2.get(string);
                if (object2 == null) {
                    object2 = new ArrayList();
                    hashMap2.put(string, object2);
                }
                object2.add(object32.getLayerTypeId());
                LOG.finest(string + " < " + object32.getLayerTypeId());
            }
            hashSet.add(object32.getLayerTypeId());
            arrayList = (List)hashMap2.get(object32.getLayerTypeId());
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap2.put(object32.getLayerTypeId(), arrayList);
            }
            for (Object object2 : object32.getZOrder().layersAbove) {
                arrayList.add(object2);
                LOG.finest(object32.getLayerTypeId() + " < " + (String)object2);
            }
        }
        List list = Utilities.topologicalSort(hashSet, hashMap2);
        ArrayList arrayList2 = new ArrayList();
        LOG.finest("Sorted layer Ids: ");
        arrayList = list.iterator();
        while (arrayList.hasNext()) {
            String string = (String)arrayList.next();
            LOG.finest("    " + string);
            object2 = (HighlightsLayer)hashMap.get(string);
            if (object2 == null) continue;
            arrayList2.add(object2);
        }
        LOG.finest("End of Sorted layer Ids: -----------------------");
        return arrayList2;
    }

    private ZOrder(Collection<String> collection, Collection<String> collection2) {
        this.layersAbove = collection == null ? EMPTY : collection;
        this.layersBelow = collection2 == null ? EMPTY : collection2;
    }

    public ZOrder aboveLayers(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(this.layersAbove);
        HashSet<String> hashSet2 = new HashSet<String>(this.layersBelow.size() + stringArray.length);
        hashSet2.addAll(this.layersBelow);
        hashSet2.addAll(Arrays.asList(stringArray));
        return new ZOrder(hashSet, hashSet2);
    }

    public ZOrder belowLayers(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(this.layersBelow);
        HashSet<String> hashSet2 = new HashSet<String>(this.layersAbove.size() + stringArray.length);
        hashSet2.addAll(this.layersAbove);
        hashSet2.addAll(Arrays.asList(stringArray));
        return new ZOrder(hashSet2, hashSet);
    }
}

